/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.ecore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.xml.type.internal.DataValue.Base64;
import org.eclipse.emf.index.ecore.emfindex.impl.EmfindexFactoryImpl;

/**
 * @author koehnlein
 */
public class CustomEmfindexFactoryImpl extends EmfindexFactoryImpl {

	@Override
	public URI createEURIFromString(EDataType eDataType, String initialValue) {
		return URI.createURI(initialValue);
	}

	@Override
	public Serializable createESerializableFromString(EDataType eDataType, String initialValue) {
		try {
			ObjectInputStream objectInputStream = null;
			try {
				byte[] buffer = Base64.decode(initialValue);
				ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
				objectInputStream = new ObjectInputStream(byteArrayInputStream);
				Serializable serializable = (Serializable) objectInputStream.readObject();
				return serializable;
			} finally {
				if (objectInputStream != null)
					objectInputStream.close();
			}
		} catch (Exception e) {
			throw new WrappedException(e);
		}
	}

	@Override
	public String convertESerializableToString(EDataType eDataType, Object instanceValue) {
		try {
			ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
			ObjectOutputStream objectOutputStream = null;
			try {
				objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
				objectOutputStream.writeObject(instanceValue);
				String encode = Base64.encode(byteArrayOutputStream.toByteArray());
				return encode;
			} finally {
				if (objectOutputStream != null)
					objectOutputStream.close();
			}
		} catch (Exception e) {
			throw new WrappedException(e);
		}
	}
}
