/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editor.messages;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.eef.runtime.ui.editor.InteractiveEEFEditor;
import org.eclipse.emf.eef.runtime.ui.editor.messages.MessageHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class MessageProcessor
extends HyperlinkAdapter {
    private FormEditor formEditor;
    private Collection<MessageHandler> handlers = new HashSet<MessageHandler>();

    public void init(InteractiveEEFEditor editor) {
        this.formEditor = editor;
        for (FormPage formPage : editor.getPages()) {
        }
    }

    public void addHandler(MessageHandler handler) {
        handler.setProcessor(this);
        this.handlers.add(handler);
    }

    public void removeHandler(MessageHandler handler) {
        this.handlers.remove(handler);
    }

    public void linkActivated(HyperlinkEvent event) {
        for (MessageHandler handler : this.handlers) {
            if (!handler.handle(event)) continue;
            handler.process(event);
        }
    }

    public void addMessage(final Object key, final String message, final int severity) {
        if (this.formEditor.getSelectedPage() instanceof FormPage) {
            final FormPage selectedPage = (FormPage)this.formEditor.getSelectedPage();
            selectedPage.getPartControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IMessageManager messageManager = selectedPage.getManagedForm().getMessageManager();
                    messageManager.addMessage(key, message, null, severity);
                }
            });
        }
    }

    public void removeAssociatedMessages(Control control) {
        if (this.formEditor.getSelectedPage() instanceof FormPage) {
            ((FormPage)this.formEditor.getSelectedPage()).getManagedForm().getMessageManager().removeMessages(control);
        }
    }
}

