/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BufferOutputStream
extends OutputStream {
    public static final boolean DEFAULT_PROPAGATE_CLOSE = false;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, BufferOutputStream.class);
    private IBufferHandler bufferHandler;
    private IBufferProvider bufferProvider;
    private IBuffer currentBuffer;
    private short channelIndex;

    public BufferOutputStream(IBufferHandler bufferHandler, IBufferProvider bufferProvider, short channelIndex) {
        if (bufferHandler == null) {
            throw new IllegalArgumentException("bufferHandler == null");
        }
        if (bufferProvider == null) {
            throw new IllegalArgumentException("bufferProvider == null");
        }
        this.bufferHandler = bufferHandler;
        this.bufferProvider = bufferProvider;
        this.channelIndex = channelIndex;
    }

    public BufferOutputStream(IBufferHandler bufferHandler, short channelIndex) {
        this(bufferHandler, BufferOutputStream.extractBufferProvider(bufferHandler), channelIndex);
    }

    public void write(int b) throws IOException {
        this.ensureBuffer();
        if (TRACER.isEnabled()) {
            TRACER.trace("--> " + HexUtil.formatByte((int)b) + (b >= 32 ? " " + Character.toString((char)b) : ""));
        }
        ByteBuffer buffer = this.currentBuffer.getByteBuffer();
        buffer.put((byte)b);
        if (!buffer.hasRemaining()) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.currentBuffer != null) {
            this.bufferHandler.handleBuffer(this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    public void flushWithEOS() throws IOException {
        this.ensureBuffer();
        this.currentBuffer.setEOS(true);
        this.flush();
    }

    public void close() throws IOException {
        try {
            if (this.isPropagateClose()) {
                LifecycleUtil.deactivate((Object)this.bufferHandler);
            }
        }
        finally {
            this.bufferHandler = null;
            this.bufferProvider = null;
            this.currentBuffer = null;
            super.close();
        }
    }

    public String toString() {
        return "BufferOutputStream";
    }

    protected void ensureBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.bufferProvider.provideBuffer();
            this.currentBuffer.startPutting(this.channelIndex);
        }
    }

    protected boolean isPropagateClose() {
        return false;
    }

    private static IBufferProvider extractBufferProvider(IBufferHandler bufferHandler) {
        if (bufferHandler instanceof IBufferProvider) {
            return (IBufferProvider)((Object)bufferHandler);
        }
        throw new IllegalArgumentException("Buffer handler unable to provide buffers");
    }
}

