/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol.admin;

import java.io.IOException;
import org.eclipse.net4j.jms.internal.server.protocol.admin.JMSAdminServerProtocol;
import org.eclipse.net4j.jms.server.IDestination;
import org.eclipse.net4j.jms.server.IServer;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSCreateDestinationIndication
extends IndicationWithResponse {
    private boolean ok;

    protected short getSignalID() {
        return 1;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        byte type = in.readByte();
        String name = in.readString();
        JMSAdminServerProtocol protocol = (JMSAdminServerProtocol)this.getProtocol();
        IServer server = protocol.getServer();
        IDestination destination = server.createDestination(name, this.getDestinationType(type));
        if (destination != null) {
            this.ok = true;
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        out.writeBoolean(this.ok);
    }

    private IDestination.Type getDestinationType(byte type) {
        switch (type) {
            case 1: {
                return IDestination.Type.QUEUE;
            }
            case 2: {
                return IDestination.Type.TOPIC;
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

