/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.LoadRevisionRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadRevisionByVersionRequest
extends LoadRevisionRequest {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByVersionRequest.class);
    private int version;

    public LoadRevisionByVersionRequest(IChannel channel, CDOID id, int referenceChunk, int version) {
        super(channel, (Collection<CDOID>)Collections.singleton(id), referenceChunk);
        this.version = version;
    }

    protected short getSignalID() {
        return 9;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        super.requesting(out);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing version: {0}", new Object[]{this.version});
        }
        out.writeInt(this.version);
    }

    public String toString() {
        return MessageFormat.format("{0}(ids={1}, referenceChunk={2}, version={3})", ((Object)((Object)this)).getClass().getSimpleName(), this.getIds(), this.getReferenceChunk(), this.version);
    }
}

