/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.LegacySystemNotAvailableException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.CDOAuditImpl;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.protocol.LoadLibrariesRequest;
import org.eclipse.emf.internal.cdo.protocol.OpenSessionRequest;
import org.eclipse.emf.internal.cdo.protocol.OpenSessionResult;
import org.eclipse.emf.internal.cdo.protocol.QueryObjectTypesRequest;
import org.eclipse.emf.internal.cdo.protocol.ViewsChangedRequest;
import org.eclipse.emf.internal.cdo.util.CDOPackageRegistryImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.emf.internal.cdo.util.ProxyResolverURIResourceMap;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverEvent;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.signal.failover.NOOPFailOverStrategy;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSessionImpl
extends Container<CDOView>
implements CDOSession,
CDOIDObjectFactory {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, CDOSessionImpl.class);
    private int sessionID;
    private boolean legacySupportEnabled;
    private int referenceChunkSize;
    private IFailOverStrategy failOverStrategy;
    private IListener failOverStrategyListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof IFailOverEvent) {
                IFailOverEvent e = (IFailOverEvent)event;
                CDOSessionImpl.this.handleFailOver(e.getOldChannel(), e.getNewChannel(), e.getNewConnector());
            }
        }
    };
    private IConnector connector;
    private IChannel channel;
    private String repositoryName;
    private String repositoryUUID;
    private CDOPackageRegistry packageRegistry;
    private CDOSessionPackageManagerImpl packageManager;
    private CDORevisionManagerImpl revisionManager;
    private Map<CDOID, InternalEObject> idToMetaInstanceMap = new HashMap<CDOID, InternalEObject>();
    private Map<InternalEObject, CDOID> metaInstanceToIDMap = new HashMap<InternalEObject, CDOID>();
    private ConcurrentMap<CDOID, CDOClass> types = new ConcurrentHashMap<CDOID, CDOClass>();
    private Map<ResourceSet, CDOViewImpl> views = new HashMap<ResourceSet, CDOViewImpl>();
    private transient int lastViewID;
    private transient int lastTempMetaID;
    private IListener channelListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOSessionImpl.this.close();
        }
    };
    private CDOIDObjectFactory cdoidObjectFactory;

    public CDOSessionImpl() {
        this.packageManager = this.createPackageManager();
        this.revisionManager = this.createRevisionManager();
        this.referenceChunkSize = (Integer)OM.PREF_REFERENCE_CHUNK_SIZE.getValue();
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public CDOIDObject createCDOIDObject(ExtendedDataInput in) {
        return this.cdoidObjectFactory.createCDOIDObject(in);
    }

    public boolean isLegacySupportEnabled() {
        return this.legacySupportEnabled;
    }

    public void setLegacySupportEnabled(boolean legacySupportEnabled) {
        this.checkInactive();
        if (legacySupportEnabled && !FSMUtil.isLegacySystemAvailable()) {
            throw new LegacySystemNotAvailableException();
        }
        this.legacySupportEnabled = legacySupportEnabled;
    }

    @Override
    public int getReferenceChunkSize() {
        return this.referenceChunkSize;
    }

    @Override
    public void setReferenceChunkSize(int referenceChunkSize) {
        if (referenceChunkSize <= 0) {
            referenceChunkSize = -1;
        }
        this.referenceChunkSize = referenceChunkSize;
    }

    @Override
    public synchronized IFailOverStrategy getFailOverStrategy() {
        if (this.failOverStrategy == null) {
            this.failOverStrategy = new NOOPFailOverStrategy();
        }
        return this.failOverStrategy;
    }

    public synchronized void setFailOverStrategy(IFailOverStrategy failOverStrategy) {
        if (this.failOverStrategy != null) {
            this.failOverStrategy.removeListener(this.failOverStrategyListener);
        }
        this.failOverStrategy = failOverStrategy;
        if (this.failOverStrategy != null) {
            this.failOverStrategy.addListener(this.failOverStrategyListener);
        }
    }

    @Override
    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)this.channel.getReceiveHandler();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public String getRepositoryUUID() {
        return this.repositoryUUID;
    }

    @Override
    public boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public void close() {
        this.deactivate();
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public CDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public CDOSessionPackageManagerImpl getPackageManager() {
        return this.packageManager;
    }

    @Override
    public CDORevisionManagerImpl getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public CDOTransactionImpl openTransaction(ResourceSet resourceSet) {
        CDOTransactionImpl transaction = this.createTransaction(++this.lastViewID);
        this.attach(resourceSet, transaction);
        return transaction;
    }

    protected CDOTransactionImpl createTransaction(int id) {
        return new CDOTransactionImpl(id, this);
    }

    @Override
    public CDOTransactionImpl openTransaction() {
        return this.openTransaction(this.createResourceSet());
    }

    @Override
    public CDOViewImpl openView(ResourceSet resourceSet) {
        CDOViewImpl view = this.createView(++this.lastViewID);
        this.attach(resourceSet, view);
        return view;
    }

    protected CDOViewImpl createView(int id) {
        return new CDOViewImpl(id, this);
    }

    @Override
    public CDOViewImpl openView() {
        return this.openView(this.createResourceSet());
    }

    @Override
    public CDOAuditImpl openAudit(ResourceSet resourceSet, long timeStamp) {
        CDOAuditImpl audit = this.createAudit(++this.lastViewID, timeStamp);
        this.attach(resourceSet, audit);
        return audit;
    }

    protected CDOAuditImpl createAudit(int id, long timeStamp) {
        return new CDOAuditImpl(id, this, timeStamp);
    }

    @Override
    public CDOAuditImpl openAudit(long timeStamp) {
        return this.openAudit(this.createResourceSet(), timeStamp);
    }

    public CDOView getView(int viewID) {
        CDOViewImpl[] cDOViewImplArray = this.getViews();
        int n = cDOViewImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOViewImpl view = cDOViewImplArray[n2];
            if (view.getViewID() == viewID) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOViewImpl[] getViews() {
        Collection<CDOViewImpl> values;
        Map<ResourceSet, CDOViewImpl> map = this.views;
        synchronized (map) {
            values = this.views.values();
        }
        return values.toArray(new CDOViewImpl[values.size()]);
    }

    public CDOView[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewDetached(CDOViewImpl view) {
        ResourceSet resourceSet = view.getResourceSet();
        Map<ResourceSet, CDOViewImpl> map = this.views;
        synchronized (map) {
            if (this.views.remove(resourceSet) == null) {
                return;
            }
        }
        try {
            new ViewsChangedRequest(this.channel, view.getViewID(), 4).send();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        this.fireElementRemovedEvent(view);
    }

    public synchronized CDOIDMetaRange getTempMetaIDRange(int count) {
        CDOIDTemp lowerBound = CDOIDUtil.createTempMeta((int)(this.lastTempMetaID + 1));
        this.lastTempMetaID += count;
        return CDOIDUtil.createMetaRange((CDOID)lowerBound, (int)count);
    }

    public InternalEObject lookupMetaInstance(CDOID id) {
        InternalEObject metaInstance = this.idToMetaInstanceMap.get(id);
        if (metaInstance == null) {
            CDOPackage[] cdoPackages;
            CDOPackage[] cDOPackageArray = cdoPackages = this.packageManager.getPackages();
            int n = cdoPackages.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackage cdoPackage = cDOPackageArray[n2];
                CDOIDMetaRange metaIDRange = cdoPackage.getMetaIDRange();
                if (metaIDRange != null && metaIDRange.contains(id)) {
                    EPackage ePackage = ModelUtil.getEPackage(cdoPackage, this.packageRegistry);
                    this.registerEPackage(ePackage);
                    metaInstance = this.idToMetaInstanceMap.get(id);
                    break;
                }
                ++n2;
            }
        }
        return metaInstance;
    }

    public CDOID lookupMetaInstanceID(InternalEObject metaInstance) {
        return this.metaInstanceToIDMap.get(metaInstance);
    }

    public void registerEPackage(EPackage ePackage, CDOIDMetaRange metaIDRange) {
        if (metaIDRange.isTemporary()) {
            throw new IllegalArgumentException("metaIDRange.isTemporary()");
        }
        CDOIDMetaRange range = CDOIDUtil.createMetaRange((CDOID)metaIDRange.getLowerBound(), (int)0);
        if ((range = CDOSessionImpl.registerMetaInstance((InternalEObject)ePackage, range, this.idToMetaInstanceMap, this.metaInstanceToIDMap)).size() != metaIDRange.size()) {
            throw new IllegalStateException("range.size() != metaIDRange.size()");
        }
    }

    public CDOIDMetaRange registerEPackage(EPackage ePackage) {
        CDOIDMetaRange range = CDOSessionImpl.registerEPackage(ePackage, this.lastTempMetaID + 1, this.idToMetaInstanceMap, this.metaInstanceToIDMap);
        this.lastTempMetaID = ((CDOIDTemp)range.getUpperBound()).getIntValue();
        return range;
    }

    public static CDOIDMetaRange registerEPackage(EPackage ePackage, int firstMetaID, Map<CDOID, InternalEObject> idToMetaInstances, Map<InternalEObject, CDOID> metaInstanceToIDs) {
        CDOIDTemp lowerBound = CDOIDUtil.createTempMeta((int)firstMetaID);
        CDOIDMetaRange range = CDOIDUtil.createMetaRange((CDOID)lowerBound, (int)0);
        range = CDOSessionImpl.registerMetaInstance((InternalEObject)ePackage, range, idToMetaInstances, metaInstanceToIDs);
        return range;
    }

    public static CDOIDMetaRange registerMetaInstance(InternalEObject metaInstance, CDOIDMetaRange range, Map<CDOID, InternalEObject> idToMetaInstances, Map<InternalEObject, CDOID> metaInstanceToIDs) {
        range = range.increase();
        CDOID id = range.getUpperBound();
        if (TRACER.isEnabled()) {
            TRACER.format("Registering meta instance: {0} <-> {1}", new Object[]{id, metaInstance});
        }
        if (idToMetaInstances != null && idToMetaInstances.put(id, metaInstance) != null) {
            throw new IllegalStateException("Duplicate meta ID: " + id + " --> " + metaInstance);
        }
        if (metaInstanceToIDs != null && metaInstanceToIDs.put(metaInstance, id) != null) {
            throw new IllegalStateException("Duplicate metaInstance: " + metaInstance + " --> " + id);
        }
        for (EObject content : metaInstance.eContents()) {
            range = CDOSessionImpl.registerMetaInstance((InternalEObject)content, range, idToMetaInstances, metaInstanceToIDs);
        }
        return range;
    }

    public void remapMetaInstance(CDOID oldID, CDOID newID) {
        InternalEObject metaInstance = this.idToMetaInstanceMap.remove(oldID);
        if (metaInstance == null) {
            throw new IllegalArgumentException("Unknown meta instance id: " + oldID);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping meta instance: {0} --> {1} <-> {2}", new Object[]{oldID, newID, metaInstance});
        }
        this.idToMetaInstanceMap.put(newID, metaInstance);
        this.metaInstanceToIDMap.put(metaInstance, newID);
    }

    public CDOClass getObjectType(CDOID id) {
        return (CDOClass)this.types.get(id);
    }

    public CDOClass requestObjectType(CDOID id) {
        try {
            QueryObjectTypesRequest request = new QueryObjectTypesRequest(this.channel, Collections.singletonList(id));
            CDOClassRef[] typeRefs = (CDOClassRef[])this.getFailOverStrategy().send((RequestWithConfirmation)request);
            CDOClass type = typeRefs[0].resolve((CDOPackageManager)this.packageManager);
            this.registerObjectType(id, type);
            return type;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    public void registerObjectType(CDOID id, CDOClass type) {
        this.types.put(id, type);
    }

    public void notifyInvalidation(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs, CDOViewImpl excludedView) {
        for (CDOIDAndVersion dirtyOID : dirtyOIDs) {
            InternalCDORevision revision = this.getRevisionManager().getRevisionByVersion(dirtyOID.getID(), 0, dirtyOID.getVersion(), false);
            if (revision == null) continue;
            revision.setRevised(timeStamp - 1L);
        }
        dirtyOIDs = Collections.unmodifiableSet(dirtyOIDs);
        CDOViewImpl[] cDOViewImplArray = this.getViews();
        int n = cDOViewImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOViewImpl view = cDOViewImplArray[n2];
            if (view != excludedView) {
                try {
                    view.notifyInvalidation(timeStamp, dirtyOIDs);
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
        this.fireInvalidationEvent(timeStamp, dirtyOIDs, excludedView);
    }

    public void fireInvalidationEvent(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs, CDOViewImpl excludedView) {
        this.fireEvent(new InvalidationEvent(excludedView, timeStamp, dirtyOIDs));
    }

    public String toString() {
        return MessageFormat.format("CDOSession[{0}/{1}]", this.connector, this.repositoryName);
    }

    protected CDOPackageRegistry createPackageRegistry() {
        return new CDOPackageRegistryImpl();
    }

    protected CDOSessionPackageManagerImpl createPackageManager() {
        return new CDOSessionPackageManagerImpl(this);
    }

    protected CDORevisionManagerImpl createRevisionManager() {
        return new CDORevisionManagerImpl(this);
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(ResourceSet resourceSet, CDOViewImpl view) {
        if (CDOUtil.getView(resourceSet) != null) {
            throw new IllegalStateException("CDO view already open");
        }
        resourceSet.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl((EPackage.Registry)this.packageRegistry));
        CDOUtil.prepareResourceSet(resourceSet);
        Map resourceMap = null;
        if (!(resourceSet instanceof ResourceSetImpl)) {
            throw new ImplementationError("Not a " + ResourceSetImpl.class.getName() + ": " + resourceSet.getClass().getName());
        }
        ResourceSetImpl rs = (ResourceSetImpl)resourceSet;
        resourceMap = rs.getURIResourceMap();
        rs.setURIResourceMap((Map)new ProxyResolverURIResourceMap(view, resourceMap));
        Map<ResourceSet, CDOViewImpl> map = this.views;
        synchronized (map) {
            this.views.put(resourceSet, view);
        }
        resourceSet.eAdapters().add((Object)view);
        this.sendViewsNotification(view);
        this.fireElementAddedEvent(view);
    }

    protected void handleFailOver(IChannel oldChannel, IChannel newChannel, IConnector newConnector) {
        EventUtil.removeListener((Object)oldChannel, (IListener)this.channelListener);
        EventUtil.addListener((Object)newChannel, (IListener)this.channelListener);
        this.channel = newChannel;
        this.connector = newConnector;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.legacySupportEnabled && !FSMUtil.isLegacySystemAvailable()) {
            throw new LegacySystemNotAvailableException();
        }
        if (this.channel == null && this.connector == null) {
            throw new IllegalStateException("channel == null && connector == null");
        }
        if (this.repositoryName == null) {
            throw new IllegalStateException("repositoryName == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.packageRegistry == null) {
            this.packageRegistry = this.createPackageRegistry();
        }
        this.packageRegistry.setSession(this);
        if (this.channel == null) {
            this.channel = this.connector.openChannel("cdo", (Object)this);
        }
        OpenSessionRequest request = new OpenSessionRequest(this.channel, this.repositoryName, this.legacySupportEnabled);
        OpenSessionResult result = (OpenSessionResult)this.getFailOverStrategy().send((RequestWithConfirmation)request);
        this.sessionID = result.getSessionID();
        this.repositoryUUID = result.getRepositoryUUID();
        this.handleLibraryDescriptor(result.getLibraryDescriptor());
        this.packageManager.addPackageProxies(result.getPackageInfos());
        this.packageManager.activate();
        this.revisionManager.activate();
        EventUtil.addListener((Object)this.channel, (IListener)this.channelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeactivate() throws Exception {
        EventUtil.removeListener((Object)this.channel, (IListener)this.channelListener);
        this.revisionManager.deactivate();
        this.packageManager.deactivate();
        Map<ResourceSet, CDOViewImpl> map = this.views;
        synchronized (map) {
            CDOViewImpl[] cDOViewImplArray = this.getViews();
            int n = cDOViewImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOViewImpl view = cDOViewImplArray[n2];
                try {
                    view.close();
                }
                catch (RuntimeException runtimeException) {}
                ++n2;
            }
        }
        this.channel.close();
        super.doDeactivate();
    }

    private void handleLibraryDescriptor(CDOIDLibraryDescriptor libraryDescriptor) throws Exception {
        String factoryName = libraryDescriptor.getFactoryName();
        if (TRACER.isEnabled()) {
            TRACER.format("Using CDOID factory: {0}", new Object[]{factoryName});
        }
        File cacheFolder = this.getCacheFolder();
        ClassLoader classLoader = OM.class.getClassLoader();
        Set<String> neededLibraries = this.createSet(libraryDescriptor.getLibraryNames());
        if (!neededLibraries.isEmpty()) {
            IOUtil.mkdirs((File)cacheFolder);
            Set<String> existingLibraries = this.createSet(cacheFolder.list());
            HashSet<String> missingLibraries = new HashSet<String>(neededLibraries);
            missingLibraries.removeAll(existingLibraries);
            if (!missingLibraries.isEmpty()) {
                LoadLibrariesRequest request = new LoadLibrariesRequest(this.channel, missingLibraries, cacheFolder);
                this.getFailOverStrategy().send((RequestWithConfirmation)request);
            }
        }
        int i = 0;
        URL[] urls = new URL[neededLibraries.size()];
        for (String neededLibrary : neededLibraries) {
            File lib = new File(cacheFolder, neededLibrary);
            if (TRACER.isEnabled()) {
                TRACER.format("Using CDOID library: {0}", new Object[]{lib.getAbsolutePath()});
            }
            urls[i++] = new URL("file:///" + lib.getAbsolutePath());
        }
        classLoader = new URLClassLoader(urls, classLoader);
        Class<?> factoryClass = classLoader.loadClass(factoryName);
        this.cdoidObjectFactory = (CDOIDObjectFactory)factoryClass.newInstance();
    }

    private File getCacheFolder() {
        String stateLocation = OM.BUNDLE.getStateLocation();
        File repos = new File(stateLocation, "repos");
        return new File(repos, this.repositoryUUID);
    }

    private Set<String> createSet(String[] fileNames) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.endsWith(".jar")) {
                set.add(fileName);
            }
            ++n2;
        }
        return set;
    }

    private void sendViewsNotification(CDOViewImpl view) {
        try {
            int id = view.getViewID();
            byte kind = this.getKind(view);
            ViewsChangedRequest request = new ViewsChangedRequest(this.channel, id, kind);
            this.getFailOverStrategy().send((RequestWithConfirmation)request);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    private byte getKind(CDOViewImpl view) {
        CDOProtocolView.Type type = view.getViewType();
        switch (type) {
            case TRANSACTION: {
                return 1;
            }
            case READONLY: {
                return 3;
            }
            case AUDIT: {
                return 2;
            }
        }
        throw new ImplementationError("Invalid view type: " + type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOSessionInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private CDOViewImpl view;
        private long timeStamp;
        private Set<CDOIDAndVersion> dirtyOIDs;

        public InvalidationEvent(CDOViewImpl view, long timeStamp, Set<CDOIDAndVersion> dirtyOIDs) {
            super((INotifier)CDOSessionImpl.this);
            this.view = view;
            this.timeStamp = timeStamp;
            this.dirtyOIDs = dirtyOIDs;
        }

        @Override
        public CDOSession getSession() {
            return CDOSessionImpl.this;
        }

        @Override
        public CDOViewImpl getView() {
            return this.view;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<CDOIDAndVersion> getDirtyOIDs() {
            return this.dirtyOIDs;
        }

        public String toString() {
            return "CDOSessionInvalidationEvent: " + this.dirtyOIDs;
        }
    }
}

