/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaRangeImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.spi.common.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.CDOIDLibraryDescriptorImpl;
import org.eclipse.emf.cdo.spi.common.CDOIDLongImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOIDUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CDOIDUtil.class);

    private CDOIDUtil() {
    }

    public static long getLong(CDOID id) {
        if (id == null) {
            return 0L;
        }
        switch (id.getType()) {
            case NULL: {
                return 0L;
            }
            case OBJECT: 
            case LEGACY_OBJECT: {
                if (id instanceof CDOIDLongImpl) {
                    return ((CDOIDLongImpl)id).getLongValue();
                }
                throw new IllegalArgumentException("Unknown CDOIDObject implementation: " + id.getClass().getName());
            }
            case META: {
                return ((CDOIDMeta)id).getLongValue();
            }
            case TEMP_OBJECT: 
            case TEMP_META: {
                throw new IllegalArgumentException("id instanceof CDOIDTemp");
            }
        }
        throw new ImplementationError();
    }

    public static CDOIDTemp createTempMeta(int value) {
        return new CDOIDTempMetaImpl(value);
    }

    public static CDOIDTemp createTempObject(int value) {
        return new CDOIDTempObjectImpl(value);
    }

    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return new CDOIDLongImpl(value);
    }

    public static CDOID read(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
        return CDOIDUtil.read(in, factory, false);
    }

    public static CDOID read(ExtendedDataInput in, CDOIDObjectFactory factory, boolean asLegacy) throws IOException {
        Object type;
        byte ordinal = in.readByte();
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
            }
            catch (RuntimeException ex) {
                type = ex.getMessage();
            }
            TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        type = CDOID.Type.values()[ordinal];
        if (asLegacy) {
            switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    throw new IllegalStateException("Missing classRef");
                }
                case 3: {
                    CDOIDObject id = factory.createCDOIDObject(in);
                    ((AbstractCDOID)((Object)id)).read(in);
                    CDOClassRef classRef = CDOModelUtil.readClassRef(in);
                    return id.asLegacy(classRef);
                }
            }
            throw new ImplementationError();
        }
        switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 4: {
                return new CDOIDTempObjectImpl(in.readInt());
            }
            case 6: {
                return new CDOIDTempMetaImpl(in.readInt());
            }
            case 5: {
                return new CDOIDMetaImpl(in.readLong());
            }
            case 2: {
                CDOIDObject id = factory.createCDOIDObject(in);
                ((AbstractCDOID)((Object)id)).read(in);
                return id;
            }
            case 3: {
                CDOIDObject id = factory.createCDOIDObject(in);
                ((AbstractCDOID)((Object)id)).read(in);
                CDOModelUtil.readClassRef(in);
                return id;
            }
        }
        throw new ImplementationError();
    }

    public static void write(ExtendedDataOutput out, CDOID id) throws IOException {
        CDOIDUtil.write(out, id, false);
    }

    public static void write(ExtendedDataOutput out, CDOID id, boolean asLegacy) throws IOException {
        if (id == null) {
            id = CDOID.NULL;
        }
        CDOID.Type type = id.getType();
        int ordinal = type.ordinal();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        out.writeByte(ordinal);
        if (asLegacy) {
            switch (type) {
                case NULL: 
                case OBJECT: 
                case TEMP_OBJECT: 
                case META: 
                case TEMP_META: {
                    throw new IllegalStateException("Missing classRef");
                }
                case LEGACY_OBJECT: {
                    CDOIDObject legacy = (CDOIDObject)id;
                    ((AbstractCDOID)((Object)legacy)).write(out);
                    CDOModelUtil.writeClassRef(out, legacy.getClassRef());
                    return;
                }
            }
            throw new ImplementationError();
        }
        ((AbstractCDOID)id).write(out);
    }

    public static CDOIDMeta createMeta(long value) {
        return new CDOIDMetaImpl(value);
    }

    public static CDOIDMetaRange createMetaRange(CDOID lowerBound, int count) {
        return new CDOIDMetaRangeImpl(lowerBound, count);
    }

    public static CDOIDMetaRange readMetaRange(ExtendedDataInput in) throws IOException {
        boolean exist = in.readBoolean();
        if (exist) {
            return new CDOIDMetaRangeImpl(CDOIDUtil.read(in, null), in.readInt());
        }
        return null;
    }

    public static void writeMetaRange(ExtendedDataOutput out, CDOIDMetaRange idRange) throws IOException {
        if (idRange == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            CDOIDUtil.write(out, idRange.getLowerBound());
            out.writeInt(idRange.size());
        }
    }

    public static CDOIDLibraryDescriptor readLibraryDescriptor(ExtendedDataInput in) throws IOException {
        return new CDOIDLibraryDescriptorImpl(in);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOID id, int version) {
        return new CDOIDAndVersionImpl(id, version);
    }

    public static CDOIDAndVersion readIDAndVersion(ExtendedDataInput in, CDOIDObjectFactory factory) throws IOException {
        return CDOIDUtil.readIDAndVersion(in, factory, false);
    }

    public static CDOIDAndVersion readIDAndVersion(ExtendedDataInput in, CDOIDObjectFactory factory, boolean asLegacy) throws IOException {
        return new CDOIDAndVersionImpl(in, factory, asLegacy);
    }
}

