/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class PersistenceOptions
implements ExtensionPoint {
    public static final String DEFAULT_CLASSPATH_FILENAME = "/teneo-persistence.properties";
    public static final String RUNTIME_PREFIX = "teneo.runtime.";
    public static final String MAPPING_PREFIX = "teneo.mapping.";
    public static final String NAMING_PREFIX = "teneo.naming.";
    private static Log log = LogFactory.getLog(PersistenceOptions.class);
    public static final String JOIN_TABLE_NAMING_STRATEGY = "teneo.naming.join_table_naming_strategy";
    public static final String JOIN_TABLE_NAMING_STRATEGY_OLD = "teneo.mapping.join_table_naming_strategy";
    public static final String JOIN_COLUMN_NAMING_STRATEGY = "teneo.naming.join_column_naming_strategy";
    public static final String IDBAG_ID_COLUMN_NAME = "teneo.naming.idbag_id_column_name";
    public static final String VERSION_COLUMN_NAME = "teneo.naming.version_column";
    public static final String ID_COLUMN_NAME = "teneo.naming.default_id_column";
    public static final String MAXIMUM_SQL_NAME_LENGTH = "teneo.naming.max_sql_name_length";
    public static final String SQL_CASE_STRATEGY = "teneo.naming.strategy";
    public static final String SET_FOREIGN_KEY_NAME = "teneo.naming.set_foreign_key_name";
    public static final String SQL_NAME_ESCAPE_CHARACTER = "teneo.mapping.sql_name_escape_character";
    public static final String SQL_NAME_STRATEGY = "teneo.naming.sql_name_strategy";
    public static final String SQL_TABLE_NAME_PREFIX = "teneo.naming.sql_table_name_prefix";
    public static final String SQL_COLUMN_NAME_PREFIX = "teneo.naming.sql_column_name_prefix";
    public static final String SQL_FOREIGN_KEY_NAME_PREFIX = "teneo.naming.sql_fk_name_prefix";
    public static final String SQL_DISCRIMINATOR_VERSION_IMMUTABLE_ECLASS = "teneo.naming.sql_discriminator_version_immutable_eclass";
    public static final String ECONTAINER_FEATURE_PERSISTENCE_STRATEGY = "teneo.naming.econtainer_feature_persistence_strategy";
    public static final String USER_XSDDATE_TYPE = "teneo.mapping.UserDateType";
    public static final String USER_XSDDATETIME_TYPE = "teneo.mapping.UserDateTimeType";
    public static final String XSDDATE_CLASS = "teneo.mapping.XSDDateClass";
    public static final String DEFAULT_VARCHAR_LENGTH = "teneo.mapping.default_varchar_length";
    public static final String MAX_COMMENT_LENGTH = "teneo.mapping.max_comment_length";
    public static final String MAP_EMBEDDABLE_AS_EMBEDDED = "teneo.mapping.map_embeddable_as_embedded";
    public static final String OPTIMISTIC = "teneo.mapping.optimistic_locking";
    public static final String ADD_INDEX_FOR_FOREIGN_KEY = "teneo.mapping.add_index_for_fk";
    public static final String SET_DEFAULT_CASCADE_ON_NON_CONTAINMENT = "teneo.mapping.set_default_cascade_on_non_containment";
    public static final String INHERITANCE_MAPPING = "teneo.mapping.inheritance";
    public static final String UPDATE_SCHEMA = "teneo.runtime.update_schema";
    public static final String FETCH_CONTAINMENT_EAGERLY = "teneo.mapping.fetch_containment_eagerly";
    public static final String SET_CASCADE_ALL_ON_CONTAINMENT = "teneo.mapping.cascade_all_on_containment";
    public static final String CASCADE_POLICY_ON_CONTAINMENT = "teneo.mapping.cascade_policy_on_containment";
    public static final String CASCADE_POLICY_ON_NON_CONTAINMENT = "teneo.mapping.cascade_policy_on_non_containment";
    public static final String SET_ENTITY_AUTOMATICALLY = "teneo.mapping.set_entity_automatically";
    public static final String ALWAYS_MAP_LIST_AS_BAG = "teneo.mapping.always_map_list_as_bag";
    public static final String MAP_ALL_LISTS_AS_IDBAG = "teneo.mapping.map_all_lists_as_idbag";
    public static final String USE_MAPPING_FILE = "teneo.mapping.hibernate_mapping_file";
    public static final String MAPPING_FILE_PATH = "teneo.mapping.mapping_file_name";
    public static final String ID_FEATURE_AS_PRIMARY_KEY = "teneo.naming.id_feature_as_primary_key";
    public static final String SET_GENERATED_VALUE_ON_ID_FEATURE = "teneo.naming.set_generated_value_on_id_feature";
    public static final String DEFAULT_ID_FEATURE_NAME = "teneo.naming.default_id_feature";
    public static final String PERSISTENCE_XML = "teneo.mapping.persistence_xml";
    public static final String IGNORE_EANNOTATIONS = "teneo.mapping.ignore_eannotations";
    public static final String EMAP_AS_TRUE_MAP = "teneo.mapping.emap_as_true_map";
    public static final String ALSO_MAP_AS_CLASS = "teneo.mapping.also_map_as_class";
    public static final String SET_PROXY = "teneo.mapping.set_proxy";
    public static final String DISABLE_ECONTAINER_MAPPING = "teneo.mapping.disable_econtainer";
    public static final String JOIN_TABLE_FOR_NON_CONTAINED_ASSOCIATIONS = "teneo.mapping.join_table_for_non_contained_associations";
    public static final String ALWAYS_VERSION = "teneo.mapping.always_version";
    public static final String DEFAULT_CACHE_STRATEGY = "teneo.mapping.default_cache_strategy";
    public static final String DEFAULT_TEMPORAL_VALUE = "teneo.mapping.default_temporal";
    public static final String HANDLE_UNSET_AS_NULL = "teneo.runtime.handle_unset_as_null";
    public static final String MAP_DOCUMENT_ROOT = "teneo.mapping.map_document_root";
    public static final String AUTO_ADD_REFERENCED_EPACKAGES = "teneo.mapping.auto_add_referenced_epackages";
    public static final String EAV_MAPPING = "teneo.mapping.eav_mapping";
    public static final String EAV_MAPPING_FILE = "teneo.mapping.eav_location";
    public static final String FEATUREMAP_AS_COMPONENT = "teneo.mapping.featuremap_as_component";
    public static final String EXTRA_ANNOTATION_SOURCES = "teneo.mapping.extra_annotation_sources";
    public static final String ECONTAINER_CLASS_COLUMN = "econtainer_class_column";
    public static final String ECONTAINER_COLUMN = "e_container_column";
    public static final String ECONTAINER_FEATURE_NAME_COLUMN = "e_container_feature_name_column";
    private final Properties properties = PersistenceOptions.getDefaultProperties();

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        props.setProperty(HANDLE_UNSET_AS_NULL, "false");
        props.setProperty(JOIN_TABLE_FOR_NON_CONTAINED_ASSOCIATIONS, "true");
        props.setProperty(USE_MAPPING_FILE, "false");
        props.setProperty(SET_CASCADE_ALL_ON_CONTAINMENT, "");
        props.setProperty(CASCADE_POLICY_ON_CONTAINMENT, "ALL");
        props.setProperty(OPTIMISTIC, "true");
        props.setProperty(UPDATE_SCHEMA, "false");
        props.setProperty(FETCH_CONTAINMENT_EAGERLY, "false");
        props.setProperty(SET_ENTITY_AUTOMATICALLY, "true");
        props.setProperty(VERSION_COLUMN_NAME, "e_version");
        props.setProperty(SQL_CASE_STRATEGY, "lowercase");
        props.setProperty(ID_COLUMN_NAME, "e_id");
        props.setProperty(DISABLE_ECONTAINER_MAPPING, "false");
        props.setProperty(MAXIMUM_SQL_NAME_LENGTH, "-1");
        props.setProperty(IGNORE_EANNOTATIONS, "false");
        props.setProperty(ALWAYS_VERSION, "true");
        props.setProperty(DEFAULT_CACHE_STRATEGY, "NONE");
        props.setProperty(JOIN_TABLE_NAMING_STRATEGY, "unique");
        props.setProperty(JOIN_COLUMN_NAMING_STRATEGY, "unique");
        props.setProperty(DEFAULT_TEMPORAL_VALUE, "TIMESTAMP");
        props.setProperty(DEFAULT_ID_FEATURE_NAME, "e_id");
        props.setProperty(ID_FEATURE_AS_PRIMARY_KEY, "true");
        props.setProperty(SET_GENERATED_VALUE_ON_ID_FEATURE, "true");
        props.setProperty(EMAP_AS_TRUE_MAP, "true");
        props.setProperty(ALWAYS_MAP_LIST_AS_BAG, "false");
        props.setProperty(ALSO_MAP_AS_CLASS, "true");
        props.setProperty(SET_PROXY, "false");
        props.setProperty(MAP_ALL_LISTS_AS_IDBAG, "false");
        props.setProperty(IDBAG_ID_COLUMN_NAME, "ID");
        props.setProperty(ADD_INDEX_FOR_FOREIGN_KEY, "false");
        props.setProperty(SET_DEFAULT_CASCADE_ON_NON_CONTAINMENT, "");
        props.setProperty(CASCADE_POLICY_ON_NON_CONTAINMENT, "");
        props.setProperty(SET_FOREIGN_KEY_NAME, "true");
        props.setProperty(MAP_EMBEDDABLE_AS_EMBEDDED, "false");
        props.setProperty(MAX_COMMENT_LENGTH, "0");
        props.setProperty(DEFAULT_VARCHAR_LENGTH, "-1");
        props.setProperty(SQL_NAME_ESCAPE_CHARACTER, "`");
        props.setProperty(USER_XSDDATE_TYPE, "org.eclipse.emf.teneo.hibernate.mapping.XSDDate");
        props.setProperty(USER_XSDDATETIME_TYPE, "org.eclipse.emf.teneo.hibernate.mapping.XSDDateTime");
        props.setProperty(XSDDATE_CLASS, "javax.xml.datatype.XMLGregorianCalendar");
        props.setProperty(SQL_DISCRIMINATOR_VERSION_IMMUTABLE_ECLASS, "true");
        props.setProperty(ECONTAINER_FEATURE_PERSISTENCE_STRATEGY, "FEATURENAME");
        props.setProperty(SQL_TABLE_NAME_PREFIX, "");
        props.setProperty(SQL_COLUMN_NAME_PREFIX, "");
        props.setProperty(SQL_FOREIGN_KEY_NAME_PREFIX, "");
        props.setProperty(MAP_DOCUMENT_ROOT, "false");
        props.setProperty(EAV_MAPPING, "false");
        props.setProperty(AUTO_ADD_REFERENCED_EPACKAGES, "false");
        props.setProperty(ECONTAINER_CLASS_COLUMN, "econtainer_class");
        props.setProperty(ECONTAINER_COLUMN, "e_container");
        props.setProperty(ECONTAINER_FEATURE_NAME_COLUMN, "e_container_feature_name");
        props.setProperty(FEATUREMAP_AS_COMPONENT, "false");
        props.setProperty(EXTRA_ANNOTATION_SOURCES, "");
        return props;
    }

    public String getExtraAnnotationSources() {
        return this.properties.getProperty(EXTRA_ANNOTATION_SOURCES);
    }

    public boolean isMapFeatureMapAsComponent() {
        return Boolean.valueOf(this.properties.getProperty(FEATUREMAP_AS_COMPONENT));
    }

    public String getEContainerColumn() {
        return this.properties.getProperty(ECONTAINER_COLUMN);
    }

    public String getEContainerClassColumn() {
        return this.properties.getProperty(ECONTAINER_CLASS_COLUMN);
    }

    public String getEContainerFeatureNameColumn() {
        return this.properties.getProperty(ECONTAINER_FEATURE_NAME_COLUMN);
    }

    public boolean isEAVMapping() {
        return Boolean.valueOf(this.properties.getProperty(EAV_MAPPING));
    }

    public String getEAVMappingFile() {
        return this.properties.getProperty(EAV_MAPPING_FILE);
    }

    public boolean isAutoAddReferencedEPackages() {
        return Boolean.valueOf(this.properties.getProperty(AUTO_ADD_REFERENCED_EPACKAGES));
    }

    public boolean isMapDocumentRoot() {
        return Boolean.valueOf(this.properties.getProperty(MAP_DOCUMENT_ROOT));
    }

    public boolean getHandleUnsetAsNull() {
        return Boolean.valueOf(this.properties.getProperty(HANDLE_UNSET_AS_NULL));
    }

    public PersistenceOptions(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        this.logProperties();
    }

    public PersistenceOptions() {
        Properties props = new Properties();
        InputStream in = null;
        try {
            try {
                in = this.getClass().getResourceAsStream(DEFAULT_CLASSPATH_FILENAME);
                if (in != null) {
                    log.debug((Object)"Loading persistence options from classpath \"/teneo-persistence.properties\".");
                    props.load(in);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading \"/teneo-persistence.properties\" from classpath:" + e.getMessage(), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.properties.putAll((Map<?, ?>)props);
        this.logProperties();
    }

    public void logProperties() {
        log.debug((Object)"Properties of PersistenceOptions:");
        for (Object key : this.properties.keySet()) {
            log.debug((Object)(key + ": " + this.properties.get(key)));
        }
    }

    public String getSQLTableNamePrefix() {
        return this.properties.getProperty(SQL_TABLE_NAME_PREFIX);
    }

    public String getSQLColumnNamePrefix() {
        return this.properties.getProperty(SQL_COLUMN_NAME_PREFIX);
    }

    public String getSQLForeignKeyNamePrefix() {
        return this.properties.getProperty(SQL_FOREIGN_KEY_NAME_PREFIX);
    }

    public String getDefaultTemporalValue() {
        return this.properties.getProperty(DEFAULT_TEMPORAL_VALUE);
    }

    public String getIDBagIDColumnName() {
        return String.valueOf(this.getSQLColumnNamePrefix()) + this.properties.getProperty(IDBAG_ID_COLUMN_NAME);
    }

    public boolean isMapEMapAsTrueMap() {
        return Boolean.valueOf(this.properties.getProperty(EMAP_AS_TRUE_MAP));
    }

    public boolean isSetDefaultCascadeOnNonContainment() {
        String property = this.properties.getProperty(SET_DEFAULT_CASCADE_ON_NON_CONTAINMENT);
        if (!property.equals("")) {
            return Boolean.valueOf(property);
        }
        return !this.properties.getProperty(CASCADE_POLICY_ON_NON_CONTAINMENT).equals("");
    }

    public boolean isSetCascadePolicyForNonContainment() {
        return !this.properties.getProperty(CASCADE_POLICY_ON_NON_CONTAINMENT).equals("");
    }

    public boolean isSetCascadeMergeOnNonContainment() {
        return this.isSetCascadeOnNonContainement(CascadeType.MERGE.getName());
    }

    public boolean isSetCascadePersistOnNonContainment() {
        return this.isSetCascadeOnNonContainement(CascadeType.PERSIST.getName());
    }

    public boolean isSetCascadeRefreshOnNonContainment() {
        return this.isSetCascadeOnNonContainement(CascadeType.REFRESH.getName());
    }

    private boolean isSetCascadeOnNonContainement(String cascadeType) {
        return this.isSetCascade(this.properties.getProperty(CASCADE_POLICY_ON_NON_CONTAINMENT), cascadeType);
    }

    public boolean isSetForeignKeyNames() {
        return Boolean.valueOf(this.properties.getProperty(SET_FOREIGN_KEY_NAME));
    }

    public boolean isAlsoMapAsClass() {
        return Boolean.valueOf(this.properties.getProperty(ALSO_MAP_AS_CLASS));
    }

    public boolean isMapEmbeddableAsEmbedded() {
        return Boolean.valueOf(this.properties.getProperty(MAP_EMBEDDABLE_AS_EMBEDDED));
    }

    public boolean isSetProxy() {
        return Boolean.valueOf(this.properties.getProperty(SET_PROXY));
    }

    public boolean alwaysMapListAsBag() {
        return Boolean.valueOf(this.properties.getProperty(ALWAYS_MAP_LIST_AS_BAG));
    }

    public boolean alwaysMapListAsIdBag() {
        return Boolean.valueOf(this.properties.getProperty(MAP_ALL_LISTS_AS_IDBAG));
    }

    public boolean isAddIndexForForeignKey() {
        return Boolean.valueOf(this.properties.getProperty(ADD_INDEX_FOR_FOREIGN_KEY));
    }

    public boolean isJoinTableForNonContainedAssociations() {
        return Boolean.valueOf(this.properties.getProperty(JOIN_TABLE_FOR_NON_CONTAINED_ASSOCIATIONS));
    }

    public boolean isUseMappingFile() {
        return Boolean.valueOf(this.properties.getProperty(USE_MAPPING_FILE));
    }

    public String getMappingFilePath() {
        return this.properties.getProperty(MAPPING_FILE_PATH);
    }

    public boolean isIDFeatureAsPrimaryKey() {
        return Boolean.valueOf(this.properties.getProperty(ID_FEATURE_AS_PRIMARY_KEY));
    }

    public boolean isSetGeneratedValueOnIDFeature() {
        return Boolean.valueOf(this.properties.getProperty(SET_GENERATED_VALUE_ON_ID_FEATURE));
    }

    public boolean isSetCascadeAllOnContainment() {
        if (!this.properties.getProperty(SET_CASCADE_ALL_ON_CONTAINMENT).equals("")) {
            return Boolean.valueOf(this.properties.getProperty(SET_CASCADE_ALL_ON_CONTAINMENT));
        }
        return this.isSetCascadeOnContainement(CascadeType.ALL.getName());
    }

    public boolean isSetCascadeMergeOnContainment() {
        return this.isSetCascadeOnContainement(CascadeType.MERGE.getName());
    }

    public boolean isSetCascadePersistOnContainment() {
        return this.isSetCascadeOnContainement(CascadeType.PERSIST.getName());
    }

    public boolean isSetCascadeRemoveOnContainment() {
        return this.isSetCascadeOnContainement(CascadeType.REMOVE.getName());
    }

    public boolean isSetCascadeRefreshOnContainment() {
        return this.isSetCascadeOnContainement(CascadeType.REFRESH.getName());
    }

    private boolean isSetCascadeOnContainement(String cascadeType) {
        return this.isSetCascade(this.properties.getProperty(CASCADE_POLICY_ON_CONTAINMENT), cascadeType);
    }

    private boolean isSetCascade(String property, String cascadeType) {
        return Pattern.matches(".*\\b" + cascadeType.toUpperCase() + "\\b.*", property.toUpperCase());
    }

    public boolean isUseOptimisticLocking() {
        return Boolean.valueOf(this.properties.getProperty(OPTIMISTIC));
    }

    public boolean isUpdateSchema() {
        return Boolean.valueOf(this.properties.getProperty(UPDATE_SCHEMA));
    }

    public boolean isFetchContainmentEagerly() {
        return Boolean.valueOf(this.properties.getProperty(FETCH_CONTAINMENT_EAGERLY));
    }

    public boolean isSetEntityAutomatically() {
        return Boolean.valueOf(this.properties.getProperty(SET_ENTITY_AUTOMATICALLY));
    }

    public String getInheritanceMapping() {
        return this.properties.getProperty(INHERITANCE_MAPPING);
    }

    public String getVersionColumnName() {
        return String.valueOf(this.getSQLColumnNamePrefix()) + this.properties.getProperty(VERSION_COLUMN_NAME);
    }

    public String getSQLCaseStrategy() {
        return this.properties.getProperty(SQL_CASE_STRATEGY);
    }

    public String getIdColumnName() {
        return String.valueOf(this.getSQLColumnNamePrefix()) + this.properties.getProperty(ID_COLUMN_NAME);
    }

    public String getDefaultIDFeatureName() {
        return this.properties.getProperty(DEFAULT_ID_FEATURE_NAME);
    }

    public String getSqlNameEscapeCharacter() {
        return this.properties.getProperty(SQL_NAME_ESCAPE_CHARACTER);
    }

    public String getJoinTableNamingStrategy() {
        if (this.properties.get(JOIN_TABLE_NAMING_STRATEGY_OLD) != null) {
            log.warn((Object)"The option teneo.mapping.join_table_naming_strategy is deprecated, please use: teneo.naming.join_table_naming_strategy");
            return this.properties.getProperty(JOIN_TABLE_NAMING_STRATEGY);
        }
        return this.properties.getProperty(JOIN_TABLE_NAMING_STRATEGY);
    }

    public String getJoinColumnNamingStrategy() {
        return this.properties.getProperty(JOIN_COLUMN_NAMING_STRATEGY);
    }

    public String getDefaultCacheStrategy() {
        return this.properties.getProperty(DEFAULT_CACHE_STRATEGY);
    }

    public int getDefaultVarCharLength() {
        return Integer.parseInt(this.properties.getProperty(DEFAULT_VARCHAR_LENGTH));
    }

    public boolean isDisableEContainerMapping() {
        return Boolean.valueOf(this.properties.getProperty(DISABLE_ECONTAINER_MAPPING));
    }

    public int getMaximumCommentLength() {
        String colLength = this.properties.getProperty(MAX_COMMENT_LENGTH);
        try {
            int maxLength = Integer.parseInt(colLength);
            return maxLength;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Property teneo.naming.max_sql_name_length as a non-integer value: " + colLength + " value is ignored"));
            return 0;
        }
    }

    public int getMaximumSqlNameLength() {
        String colLength = this.properties.getProperty(MAXIMUM_SQL_NAME_LENGTH);
        try {
            int maxLength = Integer.parseInt(colLength);
            if (maxLength == 0) {
                throw new TeneoException("The option MAXIMUM_SQL_NAME_LENGTH has a value of zero. This will result in empty column and table names in the mapping! Please change this option to a more usable value.");
            }
            if (maxLength < 4 && maxLength > -1) {
                log.warn((Object)("The option MAXIMUM_SQL_NAME_LENGTH has a low value: " + maxLength + ". Are you sure this is correct?"));
            }
            return maxLength;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Property teneo.naming.max_sql_name_length as a non-integer value: " + colLength + " value is ignored"));
            return -1;
        }
    }

    public Boolean isDiscriminatorVersionOnImmutableEClass() {
        return (boolean)Boolean.valueOf(this.properties.getProperty(SQL_DISCRIMINATOR_VERSION_IMMUTABLE_ECLASS));
    }

    public String getPersistenceXmlPath() {
        return this.properties.getProperty(PERSISTENCE_XML);
    }

    public boolean isIgnoreEAnnotations() {
        return Boolean.valueOf(this.properties.getProperty(IGNORE_EANNOTATIONS));
    }

    public static String[] propertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Field[] fieldArray = PersistenceOptions.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String value;
                if ((field.getModifiers() & 8) > 0 & field.getType().equals(String.class) && (value = (String)field.get(null)).startsWith("teneo.")) {
                    names.add(value);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n2;
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public boolean getAlwaysVersion() {
        return Boolean.valueOf(this.properties.getProperty(ALWAYS_VERSION));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getSQLNameStrategy() {
        return this.properties.getProperty(SQL_NAME_STRATEGY);
    }

    public String getUserXSDDateType() {
        return this.properties.getProperty(USER_XSDDATE_TYPE);
    }

    public String getUserXSDDateTime() {
        return this.properties.getProperty(USER_XSDDATETIME_TYPE);
    }

    public String getXSDDateClass() {
        return this.properties.getProperty(XSDDATE_CLASS);
    }

    public EContainerFeaturePersistenceStrategy getEContainerFeaturePersistenceStrategy() {
        String strategy = this.properties.getProperty(ECONTAINER_FEATURE_PERSISTENCE_STRATEGY);
        if (strategy == null) {
            throw new TeneoException("Option ECONTAINER_FEATURE_PERSISTENCE_STRATEGY not set, please set it to one of: featureid, featurename, both");
        }
        EContainerFeaturePersistenceStrategy result = EContainerFeaturePersistenceStrategy.valueOf(strategy.toUpperCase());
        if (result == null) {
            throw new TeneoException("Option ECONTAINER_FEATURE_PERSISTENCE_STRATEGY not set correctly (" + strategy + "), please set it to one of: featureid, featurename, both");
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EContainerFeaturePersistenceStrategy {
        FEATURENAME,
        FEATUREID,
        BOTH;

    }
}

