/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.simpledom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.teneo.simpledom.Attribute;
import org.eclipse.emf.teneo.simpledom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private List<Element> children = new ArrayList<Element>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Element parent = null;

    public Element() {
    }

    public Element(String name) {
        this.setName(name);
    }

    public Element addAttribute(String name, String text) {
        Attribute attr2;
        for (Attribute attr2 : this.attributes) {
            if (attr2.getName().compareTo(name) != 0) continue;
            attr2.setText(text);
            return this;
        }
        attr2 = new Attribute(name, text);
        this.attributes.add(attr2);
        return this;
    }

    public String getAttributeValue(String name) {
        for (Attribute attr : this.attributes) {
            if (attr.getName().compareTo(name) != 0) continue;
            return attr.getText();
        }
        return null;
    }

    public void removeAttribute(String name) {
        Attribute toRemove = null;
        for (Attribute attr : this.attributes) {
            if (attr.getName().compareTo(name) != 0) continue;
            toRemove = attr;
        }
        if (toRemove != null) {
            this.attributes.remove(toRemove);
        }
    }

    public Element addAttribute(Attribute attr) {
        this.attributes.add(attr);
        return this;
    }

    public Element addElement(String name) {
        Element element = new Element();
        element.setName(name);
        this.children.add(element);
        element.setParent(this);
        return element;
    }

    public Element addElement(Element element) {
        this.children.add(element);
        element.setParent(this);
        return element;
    }

    public void addText(String text) {
        this.setText(String.valueOf(this.getText()) + text);
    }

    public Element add(Element element) {
        this.children.add(element);
        element.setParent(this);
        return element;
    }

    public Element add(int index, Element element) {
        this.children.add(index, element);
        element.setParent(this);
        return element;
    }

    public Element element(String name) {
        for (Element elem : this.children) {
            if (elem.getName().compareTo(name) != 0) continue;
            return elem;
        }
        return null;
    }

    public int indexOf(Element element) {
        return this.children.indexOf(element);
    }

    public boolean remove(Element element) {
        return this.children.remove(element);
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    String emitXML() {
        StringBuffer result = new StringBuffer("\n");
        int level = this.getLevel();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("<" + this.getName());
        i = 0;
        while (i < this.attributes.size()) {
            result.append(" ");
            Attribute attr = this.attributes.get(i);
            result.append(attr.emitXML());
            ++i;
        }
        if (this.children.size() == 0 && (this.getText() == null || this.getText().length() == 0)) {
            result.append("/>");
            return result.toString();
        }
        result.append(">");
        if (this.children.size() == 0) {
            result.append(this.getText());
            result.append("</" + this.getName() + ">");
            return result.toString();
        }
        i = 0;
        while (i < this.children.size()) {
            Element element = this.children.get(i);
            result.append(element.emitXML());
            ++i;
        }
        result.append("\n");
        i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        result.append("</" + this.getName() + ">");
        return result.toString();
    }

    int getLevel() {
        if (this.getParent() != null) {
            return 1 + this.getParent().getLevel();
        }
        return 0;
    }

    public List<Element> getChildren() {
        return this.children;
    }

    public Object clone() {
        Element element = new Element();
        element.setName(this.getName());
        element.setText(this.getText());
        element.children.addAll(this.children);
        element.attributes.addAll(this.attributes);
        element.setParent(this.getParent());
        return element;
    }
}

