/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;

public class ClassicEntityNameStrategy
implements EntityNameStrategy {
    private static Log log = LogFactory.getLog(ClassicEntityNameStrategy.class);
    public static final ClassicEntityNameStrategy INSTANCE = new ClassicEntityNameStrategy();
    private PAnnotatedModel paModel;
    private ExtensionManager extensionManager;

    public String toEntityName(EClass eClass) {
        if (eClass == EOBJECT_ECLASS) {
            return EOBJECT_ECLASS_NAME;
        }
        if (eClass == null) {
            throw new IllegalArgumentException("Passed eclass is null.This can occur if epackages which refer to eachother are placed in different ecore/xsd files and they are not read using one resource set. The reference from one epackage to another must be resolvable by EMF.");
        }
        if (eClass.getName() == null) {
            throw new IllegalArgumentException("EClass " + eClass.toString() + " has a null name." + "This can occur if epackages which refer to eachother are placed in different ecore/xsd files " + "and they are not read using one resource set. The reference from one epackage to another must be " + "resolvable by EMF.");
        }
        return eClass.getName();
    }

    public EClass toEClass(String eClassName) {
        if (eClassName == null) {
            throw new IllegalArgumentException("eClassName may not be null");
        }
        if (eClassName.compareTo(EOBJECT_ECLASS_NAME) == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        EClass eClass = null;
        for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                EClass checkEClass = aClass.getModelEClass();
                if (checkEClass.getName().compareTo(eClassName) == 0 && eClass != null) {
                    throw new IllegalArgumentException("There is more than one EClass with the same name (" + eClassName + " in EPackage " + eClass.getEPackage().getName() + " and " + aPackage.getModelEPackage().getName() + ". A different EClassResolver should be used.");
                }
                eClass = checkEClass;
            }
        }
        if (eClass == null) {
            try {
                Class<?> cls = ClassLoaderResolver.classForName(eClassName);
                eClass = EModelResolver.instance().getEClass(cls);
            }
            catch (StoreClassLoadException e) {
                log.debug((Object)("Failed to retreive ECLass for name: " + eClassName + ". This is no problem if this is a featuremap."));
            }
        }
        if (eClass == null) {
            throw new IllegalArgumentException("No EClass found using " + eClassName);
        }
        return eClass;
    }

    public PAnnotatedModel getPaModel() {
        return this.paModel;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }
}

