/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.tests;

import junit.framework.TestCase;
import org.eclipse.emf.query.conditions.strings.StringValue;
import org.eclipse.emf.query.conditions.strings.SubStringValue;

public class StringConditionsTest
extends TestCase {
    public void test_caseSensitive_stringValue_114105() {
        StringValue cond = new StringValue("aba", true);
        StringConditionsTest.assertTrue((boolean)cond.isSatisfied("aba"));
        StringConditionsTest.assertFalse((boolean)cond.isSatisfied("cdc"));
        StringConditionsTest.assertFalse((boolean)cond.isSatisfied("Aba"));
        StringConditionsTest.assertFalse((boolean)cond.isSatisfied("ABA"));
    }

    public void test_caseInsensitive_stringValue_114105() {
        StringValue cond = new StringValue("aba", false);
        StringConditionsTest.assertTrue((boolean)cond.isSatisfied("aba"));
        StringConditionsTest.assertTrue((boolean)cond.isSatisfied("Aba"));
        StringConditionsTest.assertTrue((boolean)cond.isSatisfied("ABA"));
        StringConditionsTest.assertFalse((boolean)cond.isSatisfied("cdc"));
    }

    public void test_caseSensitive_substringValue_114105() {
        this.assertSubstring("aba", "abacdcaba", true);
        this.assertSubstring("cdc", "abacdcaba", true);
        this.assertSubstring("cab", "abacdcaba", true);
        this.assertSubstring("bac", "abacdcaba", true);
        this.assertNotSubstring("cda", "abacdcaba", true);
        this.assertNotSubstring("Aba", "abacdcaba", true);
        this.assertNotSubstring("CDC", "abacdcaba", true);
    }

    public void test_caseInsensitive_substringValue_114105() {
        this.assertSubstring("abA", "abacdcaba", false);
        this.assertSubstring("CdC", "abacdcaba", false);
        this.assertSubstring("cAb", "abacdcaba", false);
        this.assertSubstring("Bac", "abacdcaba", false);
    }

    public void test_emptyString_substringValue_211055() {
        this.assertSubstring(null, null, false);
        this.assertSubstring("", "", false);
        this.assertNotSubstring("", null, false);
        this.assertNotSubstring("a", "", false);
        Exception throwable = null;
        try {
            this.assertSubstring(null, "", false);
        }
        catch (Exception t) {
            throwable = t;
        }
        StringConditionsTest.assertTrue((boolean)(throwable instanceof NullPointerException));
    }

    void assertSubstring(String substring, String test, boolean caseSensitive) {
        StringConditionsTest.assertTrue((boolean)new SubStringValue(substring, caseSensitive).isSatisfied(test));
    }

    void assertNotSubstring(String substring, String test, boolean caseSensitive) {
        StringConditionsTest.assertFalse((boolean)new SubStringValue(substring, caseSensitive).isSatisfied(test));
    }
}

