/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractMergeContainedAction
extends MergeAction {
    protected Predicate<TreeNode> isFiltered;

    private static Function<TreeNode, Stream<Diff>> treeNodesToLeafDiffs(final Predicate<TreeNode> isFiltered) {
        return new Function<TreeNode, Stream<Diff>>(){

            @Override
            public Stream<Diff> apply(TreeNode input) {
                TreeIterator allContents = input.eAllContents();
                Stream.Builder<Diff> builder = Stream.builder();
                while (allContents.hasNext()) {
                    EObject data;
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof TreeNode) || isFiltered.test((TreeNode)eObject) || !((data = ((TreeNode)eObject).getData()) instanceof Diff)) continue;
                    builder.add((Diff)data);
                }
                return builder.build();
            }
        };
    }

    public AbstractMergeContainedAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable) {
        super(compareConfiguration, mergerRegistry, mode, navigatable);
    }

    public AbstractMergeContainedAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection) {
        super(compareConfiguration, mergerRegistry, mode, navigatable, selection);
    }

    protected abstract Predicate<Diff> getDiffPredicate();

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        return !this.getSelectedDifferences().isEmpty();
    }

    @Override
    protected List<Diff> getSelectedDifferences(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof GroupItemProviderAdapter) {
            Stream<Diff> diffs = ((GroupItemProviderAdapter)firstElement).getChildren(firstElement).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).flatMap(AbstractMergeContainedAction.treeNodesToLeafDiffs(this.isFiltered));
            return this.getSelectedDifferences(diffs).stream().filter(this.getDiffPredicate()).collect(Collectors.toList());
        }
        List selectedObjects = selection.toList();
        Stream<Diff> diffs = selectedObjects.stream().filter(Adapter.class::isInstance).map(adapter -> ((Adapter)adapter).getTarget()).filter(TreeNode.class::isInstance).map(TreeNode.class::cast).flatMap(AbstractMergeContainedAction.treeNodesToLeafDiffs(this.isFiltered));
        return this.getSelectedDifferences(diffs).stream().filter(this.getDiffPredicate()).collect(Collectors.toList());
    }
}

