/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.tree.TreeNode;
import org.junit.Before;

public class AbstractTestTreeNodeItemProviderAdapter {
    protected TreeItemProviderAdapterFactorySpec treeItemProviderAdapterFactory;
    protected EventBus eventBus;
    public static final Function<Object, EObject> TREE_NODE_DATA = new Function<Object, EObject>(){

        public EObject apply(Object node) {
            if (node instanceof TreeNode) {
                return ((TreeNode)node).getData();
            }
            if (node instanceof EObject) {
                return (EObject)node;
            }
            return null;
        }
    };
    public static final Function<Object, Iterator<EObject>> E_ALL_CONTENTS = new Function<Object, Iterator<EObject>>(){

        public Iterator<EObject> apply(Object object) {
            if (object instanceof EObject) {
                return ((EObject)object).eAllContents();
            }
            return null;
        }
    };
    public static Predicate<Object> matchTreeNode = new Predicate<Object>(){

        public boolean apply(Object object) {
            EObject data;
            return object instanceof TreeNode && (data = ((TreeNode)object).getData()) instanceof Match;
        }
    };

    @Before
    public void before() throws IOException {
        this.eventBus = new EventBus();
        this.treeItemProviderAdapterFactory = new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus));
    }

    public static Comparison getComparison(ResourceScopeProvider scopeProvider) throws IOException {
        Resource left = scopeProvider.getLeft();
        ResourceSet leftResourceSet = null;
        if (left != null && (leftResourceSet = left.getResourceSet()) != null) {
            EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        }
        Resource right = scopeProvider.getRight();
        ResourceSet rightResourceSet = null;
        if (right != null && (rightResourceSet = right.getResourceSet()) != null) {
            EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        }
        Resource origin = scopeProvider.getOrigin();
        ResourceSet originResourceSet = null;
        if (origin != null && (originResourceSet = origin.getResourceSet()) != null) {
            EcoreUtil.resolveAll((ResourceSet)originResourceSet);
        }
        DefaultComparisonScope scope = leftResourceSet != null && rightResourceSet != null ? new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet) : new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        return builder.build().compare((IComparisonScope)scope);
    }

    public static TreeNode getTreeNode(TreeNode parent, EObject eObject) {
        for (TreeNode child : parent.getChildren()) {
            EObject data = child.getData();
            if (!eObject.equals(data)) continue;
            return child;
        }
        return null;
    }

    protected Match getMatchWithFeatureValue(Iterable<?> c, String featureName, Object value) {
        Iterable matches = Iterables.filter(c, Match.class);
        Predicate<Match> predicate = this.hasFeatureValue(featureName, value);
        return (Match)Iterables.find((Iterable)matches, predicate);
    }

    protected ReferenceChange getReferenceChangeWithFeatureValue(Iterable<?> c, final String featureName, final Object value) {
        Iterable matches = Iterables.filter(c, ReferenceChange.class);
        Predicate<ReferenceChange> predicate = new Predicate<ReferenceChange>(){

            public boolean apply(ReferenceChange referenceChange) {
                EObject referenceChangeValue = referenceChange.getValue();
                if (referenceChangeValue != null) {
                    return Objects.equal((Object)AbstractTestTreeNodeItemProviderAdapter.this.eGet(referenceChangeValue, featureName), (Object)value);
                }
                return false;
            }
        };
        return (ReferenceChange)Iterables.find((Iterable)matches, (Predicate)predicate);
    }

    protected AttributeChange getAttributeChangeWithFeatureValue(Iterable<?> c, final String featureName, final Object value) {
        Iterable matches = Iterables.filter(c, AttributeChange.class);
        Predicate<AttributeChange> predicate = new Predicate<AttributeChange>(){

            public boolean apply(AttributeChange attributeChange) {
                Object attributeChangeValue = attributeChange.getValue();
                if (attributeChangeValue instanceof EObject) {
                    return Objects.equal((Object)AbstractTestTreeNodeItemProviderAdapter.this.eGet((EObject)attributeChangeValue, featureName), (Object)value);
                }
                if (attributeChangeValue instanceof String) {
                    return featureName.equals(attributeChange.getAttribute().getName()) && value.equals(attributeChangeValue);
                }
                throw new IllegalStateException("Developers need to implement missing cases.");
            }
        };
        return (AttributeChange)Iterables.find((Iterable)matches, (Predicate)predicate);
    }

    protected Predicate<Match> hasFeatureValue(final String featureName, final Object value) {
        Predicate<Match> predicate = new Predicate<Match>(){

            public boolean apply(Match match) {
                EObject left = match.getLeft();
                EObject right = match.getRight();
                EObject origin = match.getOrigin();
                boolean ret = left != null ? Objects.equal((Object)value, (Object)AbstractTestTreeNodeItemProviderAdapter.this.eGet(left, featureName)) : (right != null ? Objects.equal((Object)value, (Object)AbstractTestTreeNodeItemProviderAdapter.this.eGet(right, featureName)) : (origin != null ? Objects.equal((Object)value, (Object)AbstractTestTreeNodeItemProviderAdapter.this.eGet(origin, featureName)) : false));
                return ret;
            }
        };
        return predicate;
    }

    protected Object eGet(EObject eObject, String featureName) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(featureName);
        return eObject.eGet(eStructuralFeature);
    }

    protected ITreeItemContentProvider adaptAsITreeItemContentProvider(Notifier notifier) {
        ITreeItemContentProvider contentProvider = (ITreeItemContentProvider)this.treeItemProviderAdapterFactory.adapt(notifier, ITreeItemContentProvider.class);
        return contentProvider;
    }
}

