/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.TechnicalitiesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Test;

public class TestFeatureMapDifferencesFilter
extends AbstractTestTreeNodeItemProviderAdapter {
    @Test
    public void testFeatureMapDifferencesWithNoEquivalences() throws IOException {
        Comparison comparison = TestFeatureMapDifferencesFilter.getComparison(new TestFeatureMapFilterScope());
        ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter(){

            protected boolean isIncluded(EReference eReference) {
                return eReference == TreePackage.Literals.TREE_NODE__DATA;
            }
        };
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(comparison, Predicates.alwaysTrue(), crossReferenceAdapter);
        List roots = group.getChildren();
        Predicate featureMapDifferencesFilter = new TechnicalitiesFilter().getPredicateWhenSelected();
        for (TreeNode root : roots) {
            TreeIterator nodeIte = root.eAllContents();
            while (nodeIte.hasNext()) {
                EObject n = (EObject)nodeIte.next();
                if (!(n instanceof TreeNode)) continue;
                TreeNode treeNode = (TreeNode)n;
                EObject data = treeNode.getData();
                if (data instanceof FeatureMapChange && ((FeatureMapChange)data).getEquivalence() != null) {
                    Assert.assertTrue((boolean)featureMapDifferencesFilter.apply((Object)treeNode));
                    continue;
                }
                Assert.assertFalse((boolean)featureMapDifferencesFilter.apply((Object)treeNode));
            }
        }
    }

    public class TestFeatureMapFilterScope
    extends AbstractInputData
    implements ResourceScopeProvider {
        public Resource getLeft() throws IOException {
            return this.loadFromClassLoader("data/featuremapfilter/left.nodes");
        }

        public Resource getRight() throws IOException {
            return this.loadFromClassLoader("data/featuremapfilter/right.nodes");
        }

        public Resource getOrigin() throws IOException {
            return null;
        }
    }
}

