/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.stereotypes;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.uml2.internal.DanglingStereotypeApplication;
import org.eclipse.emf.compare.uml2.profile.test.uml2comparetestprofile.UML2CompareTestProfilePackage;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLProfileTest;
import org.eclipse.emf.compare.uml2.tests.stereotypes.data.dangling.DanglingStereotypeApplicationInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPlugin;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DanglingStereotypeApplicationTest
extends AbstractUMLProfileTest {
    private DanglingStereotypeApplicationInputData input;

    @BeforeClass
    public static void fillRegistriesForStatic() {
        DanglingStereotypeApplicationTest.addProfilePathmap();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile", (Object)UML2CompareTestProfilePackage.eINSTANCE);
            Map ePackageNsURIToProfileLocationMap = UMLPlugin.getEPackageNsURIToProfileLocationMap();
            ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile", URI.createURI((String)"pathmap://UML_COMPARE_TESTS_PROFILE/uml2.compare.testprofile.profile.uml#_hZFTgIwkEeC_FYHMbTTxXw"));
        }
    }

    @AfterClass
    public static void resetRegistriesForStatic() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            UMLPlugin.getEPackageNsURIToProfileLocationMap().remove("http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/emf/compare/uml2/1.0.0/testprofile");
        }
        DanglingStereotypeApplicationTest.resetProfilePathmap();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.input = new DanglingStereotypeApplicationInputData();
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    @Test
    public void testDetectDanglingstereotypeApplication_Case1() throws IOException {
        Comparison comparison = this.compare((Notifier)this.input.getCase1Left(), (Notifier)this.input.getCase1Right(), null);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)comparison.getDifferences()));
        Iterable racs = Iterables.filter((Iterable)comparison.getDifferences(), ResourceAttachmentChange.class);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)racs));
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)danglings));
    }

    @Test
    public void testDetectDanglingstereotypeApplication_Case2() throws IOException {
        Comparison comparison = this.compare((Notifier)this.input.getCase2Left(), (Notifier)this.input.getCase2Right(), null);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)comparison.getDifferences()));
        Iterable racs = Iterables.filter((Iterable)comparison.getDifferences(), ResourceAttachmentChange.class);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)racs));
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)danglings));
    }

    @Test
    public void testDetectDanglingstereotypeApplication_Case3() throws IOException {
        Comparison comparison = this.compare((Notifier)this.input.getCase3Left(), (Notifier)this.input.getCase3Right(), null);
        Iterable racs = Iterables.filter((Iterable)comparison.getDifferences(), ResourceAttachmentChange.class);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)racs));
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)danglings));
    }

    @Test
    public void testDetectDanglingStereotypeApplication_Case4() throws IOException {
        Comparison comparison = this.compare((Notifier)this.input.getCase4Left(), (Notifier)this.input.getCase4Right(), null);
        Iterable racs = Iterables.filter((Iterable)comparison.getDifferences(), ResourceAttachmentChange.class);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)racs));
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)danglings));
    }

    @Test
    public void testMergeDanglingstereotypeApplication_Case1_LtR() throws IOException {
        Resource left = this.input.getCase1Left();
        Resource right = this.input.getCase1Right();
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, null);
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        for (Diff diff : danglings) {
            new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diff), null);
        }
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        Iterable unresolved = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)unresolved));
    }

    @Test
    public void testMergeDanglingstereotypeApplication_Case1_RtL() throws IOException {
        Resource left = this.input.getCase1Left();
        Resource right = this.input.getCase1Right();
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, null);
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        for (Diff diff : danglings) {
            new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diff), null);
        }
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Iterable unresolved = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)unresolved));
    }

    @Test
    public void testMergeDanglingstereotypeApplication_Case2_LtR() throws IOException {
        Resource left = this.input.getCase2Left();
        Resource right = this.input.getCase2Right();
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, null);
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        for (Diff diff : danglings) {
            new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diff), null);
        }
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)1L, (long)right.getContents().size());
        Iterable unresolved = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)unresolved));
    }

    @Test
    public void testMergeDanglingstereotypeApplication_Case2_RtL() throws IOException {
        Resource left = this.input.getCase2Left();
        Resource right = this.input.getCase2Right();
        Assert.assertEquals((long)1L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, null);
        Iterable danglings = Iterables.filter((Iterable)comparison.getDifferences(), DanglingStereotypeApplication.class);
        for (Diff diff : danglings) {
            new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diff), null);
        }
        Assert.assertEquals((long)2L, (long)left.getContents().size());
        Assert.assertEquals((long)2L, (long)right.getContents().size());
        Iterable unresolved = Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)unresolved));
    }
}

