/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Array;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public class EqualityHelper
extends AdapterImpl
implements IEqualityHelper {
    private final LoadingCache<EObject, URI> uriCache;
    private Comparison comparision;
    private MatchSpec eObjectMatch;
    private EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry = null;

    @Deprecated
    public EqualityHelper() {
        this(EqualityHelper.createDefaultCache((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(1024L)));
    }

    public EqualityHelper(LoadingCache<EObject, URI> uriCache) {
        this.uriCache = uriCache;
    }

    public EqualityHelper(LoadingCache<EObject, URI> uriCache, EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        this.uriCache = uriCache;
        this.equalityHelperExtensionProviderRegistry = equalityHelperExtensionProviderRegistry;
    }

    @Override
    public Comparison getTarget() {
        return this.comparision;
    }

    public void setTarget(Notifier newTarget) {
        this.comparision = (Comparison)newTarget;
        super.setTarget(newTarget);
    }

    public boolean isAdapterForType(Object type) {
        return type == IEqualityHelper.class;
    }

    @Deprecated
    public boolean matchingValues(Comparison comparison, Object object1, Object object2) {
        return this.matchingValues(object1, object2);
    }

    @Override
    public boolean matchingValues(Object object1, Object object2) {
        boolean equal;
        if (object1 == object2) {
            equal = true;
        } else if (object1 == null) {
            equal = "".equals(object2);
        } else if (object2 == null) {
            equal = "".equals(object1);
        } else {
            MatchSpec currentEObjectMatch = this.eObjectMatch;
            if (currentEObjectMatch != null && currentEObjectMatch.matches(object1)) {
                equal = currentEObjectMatch.matches(object2);
            } else if (object1 instanceof EObject) {
                equal = object2 instanceof EObject ? this.matchingEObjects((EObject)object1, (EObject)object2) : false;
            } else if (object1 instanceof String || object1 instanceof Integer || object1 instanceof Boolean) {
                equal = object1.equals(object2);
            } else if (object1.getClass().isArray() && object2.getClass().isArray()) {
                equal = this.matchingArrays(object1, object2);
            } else if (object1 instanceof FeatureMap.Entry && object2 instanceof FeatureMap.Entry) {
                FeatureMap.Entry featureMapEntry2;
                EStructuralFeature key2;
                FeatureMap.Entry featureMapEntry1 = (FeatureMap.Entry)object1;
                EStructuralFeature key1 = featureMapEntry1.getEStructuralFeature();
                if (key1.equals(key2 = (featureMapEntry2 = (FeatureMap.Entry)object2).getEStructuralFeature())) {
                    Object value1 = featureMapEntry1.getValue();
                    Object value2 = featureMapEntry2.getValue();
                    equal = this.matchingValues(value1, value2);
                } else {
                    equal = false;
                }
            } else {
                equal = object1.equals(object2);
            }
        }
        return equal;
    }

    protected boolean matchingEObjects(EObject object1, EObject object2) {
        boolean matching;
        EqualityHelperExtensionProvider.SpecificMatch specificMatch;
        EqualityHelperExtensionProvider equalityHelperExtensionProvider;
        MatchSpec match = (MatchSpec)this.getMatch(object1);
        if (match != null && (match.getLeft() == object2 || match.getRight() == object2 || match.getOrigin() == object2)) {
            return true;
        }
        if (this.equalityHelperExtensionProviderRegistry != null && object1 != null && object2 != null && (equalityHelperExtensionProvider = this.equalityHelperExtensionProviderRegistry.getHighestRankingEqualityHelperExtensionProvider(object1.eClass().getEPackage())) != null && (specificMatch = equalityHelperExtensionProvider.matchingEObjects(object1, object2, this)) != null) {
            switch (specificMatch) {
                case MATCH: {
                    return true;
                }
                case UNMATCH: {
                    return false;
                }
            }
        }
        if (match != null) {
            this.eObjectMatch = match;
            matching = match.matches(object2);
        } else {
            matching = this.getTarget().getMatch(object2) != null || object1.eClass() != object2.eClass() ? false : this.matchingURIs(object1, object2);
        }
        return matching;
    }

    protected Match getMatch(EObject o) {
        return this.getTarget().getMatch(o);
    }

    protected boolean matchingURIs(EObject object1, EObject object2) {
        boolean equal;
        if (!object1.eIsProxy() && this.isUncontained(object1) || !object2.eIsProxy() && this.isUncontained(object2)) {
            return false;
        }
        URI uri1 = (URI)this.uriCache.getUnchecked((Object)object1);
        URI uri2 = (URI)this.uriCache.getUnchecked((Object)object2);
        if (uri1.hasFragment() && uri2.hasFragment()) {
            String uri1Fragment = this.removeURIAttachment(uri1.fragment());
            String uri2Fragment = this.removeURIAttachment(uri2.fragment());
            equal = uri1Fragment.equals(uri2Fragment);
        } else {
            equal = uri1.equals(uri2);
        }
        return equal;
    }

    private String removeURIAttachment(String fragment) {
        boolean hasTwoQuestionMarks;
        int questionMark1 = fragment.indexOf(63);
        boolean bl = hasTwoQuestionMarks = questionMark1 != -1 && fragment.indexOf(63, questionMark1 + 1) != -1;
        if (hasTwoQuestionMarks) {
            return fragment.substring(0, questionMark1);
        }
        return fragment;
    }

    private boolean isUncontained(EObject object) {
        return object.eContainer() == null && object.eResource() == null;
    }

    @Override
    public boolean matchingAttributeValues(Object object1, Object object2) {
        return this.matchingValues(object1, object2);
    }

    private boolean matchingArrays(Object object1, Object object2) {
        boolean equal = true;
        int length1 = Array.getLength(object1);
        if (length1 != Array.getLength(object2)) {
            equal = false;
        } else {
            int i = 0;
            while (i < length1 && equal) {
                Object element1 = Array.get(object1, i);
                Object element2 = Array.get(object2, i);
                equal = this.matchingValues(element1, element2);
                ++i;
            }
        }
        return equal;
    }

    @Deprecated
    public URI getURI(EObject object) {
        try {
            return (URI)this.uriCache.get((Object)object);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Deprecated
    public Cache<EObject, URI> getCache() {
        return this.uriCache;
    }

    public static LoadingCache<EObject, URI> createDefaultCache(CacheBuilder<Object, Object> cacheBuilder) {
        return cacheBuilder.build(CacheLoader.from((Function)new URICacheFunction()));
    }

    private static class URICacheFunction
    implements Function<EObject, URI> {
        private URICacheFunction() {
        }

        public URI apply(EObject input) {
            if (input == null) {
                return null;
            }
            return EcoreUtil.getURI((EObject)input);
        }
    }
}

