/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view.registry;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.ILogicalModelViewHandler;

public class LogicalModelViewHandlerDescriptor {
    private final IConfigurationElement configurationElement;
    private final String handlerClassPropertyName;
    private final int ranking;
    private final String className;
    private ILogicalModelViewHandler handler;
    private boolean logOnce;

    LogicalModelViewHandlerDescriptor(IConfigurationElement configurationElement, String handlerClassPropertyName, int ranking) {
        this.configurationElement = (IConfigurationElement)Preconditions.checkNotNull((Object)configurationElement);
        this.handlerClassPropertyName = (String)Preconditions.checkNotNull((Object)handlerClassPropertyName);
        this.className = (String)Preconditions.checkNotNull((Object)configurationElement.getAttribute(handlerClassPropertyName));
        this.ranking = ranking;
    }

    public int getRanking() {
        return this.ranking;
    }

    public String getClassName() {
        return this.className;
    }

    ILogicalModelViewHandler getHandler() {
        block3: {
            if (this.handler == null) {
                try {
                    this.handler = (ILogicalModelViewHandler)this.configurationElement.createExecutableExtension(this.handlerClassPropertyName);
                }
                catch (CoreException e) {
                    if (this.logOnce) break block3;
                    this.logOnce = true;
                    String message = EMFCompareIDEUIMessages.getString("LogicalModelViewHandlerRegistry.invalidHandler", this.handlerClassPropertyName);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.handler;
    }
}

