/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.match;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.match.WeightProviderDescriptorRCPImpl;

public class WeightProviderDescriptorRegistryListener
extends AbstractRegistryEventListener {
    public static final String ATT_CLASS = "class";
    private static final String TAG_WEIGHT_PROVIDER = "provider";
    private static final String ATT_RANKING = "ranking";
    private static final String ATT_NS_URI = "nsURI";
    private final WeightProvider.Descriptor.Registry weightProviderRegistry;

    public WeightProviderDescriptorRegistryListener(String pluginID, String extensionPointID, ILog log, WeightProvider.Descriptor.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.weightProviderRegistry = registry;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (TAG_WEIGHT_PROVIDER.equals(element.getName())) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                this.logMissingAttribute(element, ATT_RANKING);
                ret = false;
            } else if (element.getAttribute(ATT_NS_URI) == null) {
                this.logMissingAttribute(element, ATT_NS_URI);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) != null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException nfe) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                    return false;
                }
                ret = true;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATT_CLASS);
        String nsURI = element.getAttribute(ATT_NS_URI);
        int rank = Integer.parseInt(element.getAttribute(ATT_RANKING));
        WeightProviderDescriptorRCPImpl descriptor = new WeightProviderDescriptorRCPImpl(element, rank, Pattern.compile(nsURI));
        WeightProvider.Descriptor previous = this.weightProviderRegistry.put(className, (WeightProvider.Descriptor)descriptor);
        if (previous != null) {
            this.log(2, element, EMFCompareRCPMessages.getString("duplicate.extension", this.weightProviderRegistry.getClass().getName()));
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        this.weightProviderRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

