/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.CherryPickOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.InternalGitTestSupport;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.junit.Assert;

public class GitTestSupport
extends InternalGitTestSupport {
    public static final String COMPARE_NO_PROJECT_SELECTED = "noProject";
    private MergeResult mergeResult;
    private RebaseResult rebaseResult;
    private CherryPickResult cherryPickResult;

    public Repository getRepository() {
        return this.repository;
    }

    public List<IProject> getProjects() throws CoreException {
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        return Lists.newArrayList((Object[])this.projects);
    }

    public Status getStatus() throws Exception {
        try (Git git = new Git(this.repository);){
            Status status = git.status().call();
            return status;
        }
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public RebaseResult getRebaseResult() {
        return this.rebaseResult;
    }

    public CherryPickResult getCherryPickResult() {
        return this.cherryPickResult;
    }

    public void merge(String local, String remote) throws CoreException, IOException, InterruptedException {
        this.checkoutBranch(GitTestSupport.normalizeBranch(local));
        MergeOperation op = new MergeOperation(this.repository, GitTestSupport.normalizeBranch(remote));
        op.execute((IProgressMonitor)new NullProgressMonitor());
        this.mergeResult = op.getResult();
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }

    public void cherryPick(String local, String remote) throws CoreException, IOException, InterruptedException {
        this.checkoutBranch(GitTestSupport.normalizeBranch(local));
        try (RevWalk revWalk = new RevWalk(this.repository);){
            RevCommit commitId = revWalk.parseCommit((AnyObjectId)this.repository.findRef(remote).getObjectId());
            CherryPickOperation op = new CherryPickOperation(this.repository, commitId);
            op.execute((IProgressMonitor)new NullProgressMonitor());
            this.cherryPickResult = op.getResult();
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        }
    }

    public void rebase(String local, String remote) throws CoreException, IOException, InterruptedException {
        this.checkoutBranch(GitTestSupport.normalizeBranch(local));
        RebaseOperation op = new RebaseOperation(this.repository, this.repository.findRef(remote));
        op.execute((IProgressMonitor)new NullProgressMonitor());
        this.rebaseResult = op.getResult();
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }

    public Comparison compare(String from, String to, String fileName) throws IOException, CoreException {
        return this.compare(from, to, fileName, COMPARE_NO_PROJECT_SELECTED);
    }

    public Comparison compare(String from, String to, String fileName, String containerProject) throws IOException, CoreException {
        String normalizedFrom = GitTestSupport.normalizeBranch(from);
        String normalizedTo = GitTestSupport.normalizeBranch(to);
        IFile file = null;
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!containerProject.equals(COMPARE_NO_PROJECT_SELECTED)) {
                if (project.getName().equals(containerProject)) {
                    file = project.getFile(fileName);
                    break;
                }
            } else {
                file = project.getFile(fileName);
                break;
            }
            ++n2;
        }
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Could not find file " + fileName + ": wrong test set-up?");
        }
        this.checkoutBranch(normalizedFrom);
        String fullPath = file.getFullPath().toString();
        GitSynchronizeData data = new GitSynchronizeData(this.getRepository(), normalizedFrom, normalizedTo, true);
        final GitSynchronizeDataSet gsds = new GitSynchronizeDataSet(data);
        final GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(gsds);
        subscriber.init((IProgressMonitor)new NullProgressMonitor());
        GitSubscriberResourceMappingContext context = new GitSubscriberResourceMappingContext(subscriber, gsds);
        HashSet<IFile> includedResources = new HashSet<IFile>(Arrays.asList(file));
        HashSet<ResourceMapping> allMappings = new HashSet<ResourceMapping>();
        HashSet<Object> newResources = new HashSet<IFile>(includedResources);
        do {
            HashSet<IFile> copy = newResources;
            newResources = new HashSet();
            for (IResource iResource : copy) {
                ResourceMapping[] mappings = ResourceUtil.getResourceMappings((IResource)iResource, (ResourceMappingContext)context);
                allMappings.addAll(Arrays.asList(mappings));
                newResources.addAll(this.collectResources(mappings, (ResourceMappingContext)context));
            }
        } while (includedResources.addAll(newResources));
        ResourceMapping[] mappings = allMappings.toArray(new ResourceMapping[allMappings.size()]);
        GitSynchronizeData gitSynchronizeData = new GitSynchronizeData(this.repository, normalizedFrom, normalizedTo, true, includedResources);
        final GitSynchronizeDataSet gsds2 = new GitSynchronizeDataSet(gitSynchronizeData);
        final GitResourceVariantTreeSubscriber subscriber2 = new GitResourceVariantTreeSubscriber(gsds2);
        GitSubscriberResourceMappingContext remoteContext = new GitSubscriberResourceMappingContext(subscriber2, gsds2);
        final SubscriberScopeManager subscriberScopeManager = new SubscriberScopeManager(subscriber2.getName(), mappings, (Subscriber)subscriber2, (RemoteResourceMappingContext)remoteContext, true);
        subscriber2.init((IProgressMonitor)new NullProgressMonitor());
        this.disposers.add(new Runnable(){

            @Override
            public void run() {
                subscriber.dispose();
                gsds.dispose();
                subscriber2.dispose();
                gsds2.dispose();
                subscriberScopeManager.dispose();
            }
        });
        SubscriberStorageAccessor accessor = new SubscriberStorageAccessor((Subscriber)subscriber2);
        IStorageProvider remoteProvider = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.REMOTE);
        IStorageProvider ancestorProvider = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.ORIGIN);
        Assert.assertNotNull((Object)remoteProvider);
        Assert.assertNotNull((Object)ancestorProvider);
        NullProgressMonitor monitor = new NullProgressMonitor();
        StorageTypedElement left = new StorageTypedElement((IStorage)file, fullPath);
        StorageTypedElement right = new StorageTypedElement(remoteProvider.getStorage((IProgressMonitor)monitor), fullPath);
        StorageTypedElement origin = new StorageTypedElement(ancestorProvider.getStorage((IProgressMonitor)monitor), fullPath);
        EMFCompareIDEUIPlugin p = EMFCompareIDEUIPlugin.getDefault();
        IModelResolver resolver = p.getModelResolverRegistry().getBestResolverFor((IStorage)file);
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), (IStorageProviderAccessor)accessor);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)left, (ITypedElement)right, (ITypedElement)origin, (IProgressMonitor)monitor);
        ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
        ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
        Assert.assertFalse((boolean)leftResourceSet.getResources().isEmpty());
        Assert.assertFalse((boolean)rightResourceSet.getResources().isEmpty());
        Assert.assertFalse((boolean)originResourceSet.getResources().isEmpty());
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        return comparisonBuilder.build().compare(scope, (Monitor)new BasicMonitor());
    }

    private Set<IResource> collectResources(ResourceMapping[] mappings, ResourceMappingContext context) {
        HashSet<IResource> resources = new HashSet<IResource>();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(context, (IProgressMonitor)new NullProgressMonitor());
                int n3 = traversals.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResourceTraversal traversal = resourceTraversalArray[n4];
                    resources.addAll(Arrays.asList(traversal.getResources()));
                    ++n4;
                }
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return resources;
    }

    public void checkoutBranch(String refName) throws CoreException, IOException {
        ResetOperation reset = new ResetOperation(this.repository, this.repository.getBranch(), ResetCommand.ResetType.HARD);
        reset.execute(null);
        BranchOperation op = new BranchOperation(this.getRepository(), GitTestSupport.normalizeBranch(refName));
        op.execute(null);
        CheckoutResult result = op.getResult();
        if (result.getStatus() != CheckoutResult.Status.OK) {
            throw new IllegalStateException("Unable to checkout branch " + refName + " result:" + result);
        }
    }

    public boolean noConflict() throws Exception {
        return this.getStatus().getConflicting().isEmpty();
    }

    public boolean fileExists(String path) {
        return new File(this.repository.getWorkTree(), path).exists();
    }
}

