/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.req;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.req.data.ReqInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ReqComputingTest {
    private ReqInputData input = new ReqInputData();

    @Test
    public void testA1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB1(TestKind.DELETE, comparison);
    }

    @Test
    public void testA2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB2(TestKind.DELETE, comparison);
    }

    @Test
    public void testA3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB3(TestKind.DELETE, comparison);
    }

    @Test
    public void testA4UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB4(TestKind.DELETE, comparison);
    }

    @Test
    public void testA5UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB5(TestKind.DELETE, comparison);
    }

    @Test
    public void testA6UseCase() throws IOException {
        Resource left = this.input.getA6Left();
        Resource right = this.input.getA6Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB6(TestKind.DELETE, comparison);
    }

    @Test
    public void testA7UseCase() throws IOException {
        Resource left = this.input.getA7Left();
        Resource right = this.input.getA7Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB7(TestKind.ADD, comparison);
    }

    @Test
    public void testA8UseCase() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB8(TestKind.ADD, comparison);
    }

    @Test
    public void testA9UseCase() throws IOException {
        Resource left = this.input.getA9Left();
        Resource right = this.input.getA9Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB9(TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA10Left();
        Resource right = this.input.getA10Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB10(TestKind.ADD, comparison);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA11Left();
        Resource right = this.input.getA11Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB11(TestKind.ADD, comparison);
    }

    @Test
    public void testB1UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB1(TestKind.ADD, comparison);
    }

    @Test
    public void testB2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB2(TestKind.ADD, comparison);
    }

    @Test
    public void testB3UseCase() throws IOException {
        Resource left = this.input.getA3Left();
        Resource right = this.input.getA3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB3(TestKind.ADD, comparison);
    }

    @Test
    public void testB4UseCase() throws IOException {
        Resource left = this.input.getA4Left();
        Resource right = this.input.getA4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB4(TestKind.ADD, comparison);
    }

    @Test
    public void testB5UseCase() throws IOException {
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB5(TestKind.ADD, comparison);
    }

    @Test
    public void testB6UseCase() throws IOException {
        Resource left = this.input.getA6Left();
        Resource right = this.input.getA6Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB6(TestKind.ADD, comparison);
    }

    @Test
    public void testB7UseCase() throws IOException {
        Resource left = this.input.getA7Left();
        Resource right = this.input.getA7Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB7(TestKind.DELETE, comparison);
    }

    @Test
    public void testB8UseCase() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB8(TestKind.DELETE, comparison);
    }

    @Test
    public void testB9UseCase() throws IOException {
        Resource left = this.input.getA9Left();
        Resource right = this.input.getA9Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB9(TestKind.DELETE, comparison);
    }

    @Test
    public void testB10UseCase() throws IOException {
        Resource left = this.input.getA10Left();
        Resource right = this.input.getA10Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB10(TestKind.DELETE, comparison);
    }

    @Test
    public void testB11UseCase() throws IOException {
        Resource left = this.input.getA11Left();
        Resource right = this.input.getA11Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB11(TestKind.DELETE, comparison);
    }

    @Test
    public void testC1UseCase() throws IOException {
        Resource left = this.input.getC1Left();
        Resource right = this.input.getC1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD1(TestKind.DELETE, comparison);
    }

    @Test
    public void testC2UseCase() throws IOException {
        Resource left = this.input.getC2Left();
        Resource right = this.input.getC2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD2(TestKind.DELETE, comparison);
    }

    @Test
    public void testC3UseCase() throws IOException {
        Resource left = this.input.getC3Left();
        Resource right = this.input.getC3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD3(TestKind.DELETE, comparison);
    }

    @Test
    public void testC4UseCase() throws IOException {
        Resource left = this.input.getC4Left();
        Resource right = this.input.getC4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD4(TestKind.DELETE, comparison);
    }

    @Test
    public void testC5UseCase() throws IOException {
        Resource left = this.input.getC5Left();
        Resource right = this.input.getC5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD5(TestKind.DELETE, comparison);
    }

    @Test
    public void testD1UseCase() throws IOException {
        Resource left = this.input.getC1Left();
        Resource right = this.input.getC1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD1(TestKind.ADD, comparison);
    }

    @Test
    public void testD2UseCase() throws IOException {
        Resource left = this.input.getC2Left();
        Resource right = this.input.getC2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD2(TestKind.ADD, comparison);
    }

    @Test
    public void testD3UseCase() throws IOException {
        Resource left = this.input.getC3Left();
        Resource right = this.input.getC3Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD3(TestKind.ADD, comparison);
    }

    @Test
    public void testD4UseCase() throws IOException {
        Resource left = this.input.getC4Left();
        Resource right = this.input.getC4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD4(TestKind.ADD, comparison);
    }

    @Test
    public void testD5UseCase() throws IOException {
        Resource left = this.input.getC5Left();
        Resource right = this.input.getC5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD5(TestKind.ADD, comparison);
    }

    @Test
    public void testE1UseCase1() throws IOException {
        Resource left = this.input.getE1Left();
        Resource right = this.input.getE1Right();
        Resource ancestor = this.input.getE1Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB1(TestKind.DELETE, comparison);
    }

    @Test
    public void testE2UseCase() throws IOException {
        Resource left = this.input.getE2Left();
        Resource right = this.input.getE2Right();
        Resource ancestor = this.input.getE2Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB2(TestKind.DELETE, comparison);
    }

    @Test
    public void testE3UseCase() throws IOException {
        Resource left = this.input.getE3Left();
        Resource right = this.input.getE3Right();
        Resource ancestor = this.input.getE3Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB3(TestKind.DELETE, comparison);
    }

    @Test
    public void testE4UseCase() throws IOException {
        Resource left = this.input.getE4Left();
        Resource right = this.input.getE4Right();
        Resource ancestor = this.input.getE4Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB4(TestKind.DELETE, comparison);
    }

    @Test
    public void testE5UseCase() throws IOException {
        Resource left = this.input.getE5Left();
        Resource right = this.input.getE5Right();
        Resource ancestor = this.input.getE5Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB5(TestKind.DELETE, comparison);
    }

    @Test
    public void testE6UseCase() throws IOException {
        Resource left = this.input.getE6Left();
        Resource right = this.input.getE6Right();
        Resource ancestor = this.input.getE6Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB6(TestKind.DELETE, comparison);
    }

    @Test
    public void testE7UseCase() throws IOException {
        Resource left = this.input.getE7Left();
        Resource right = this.input.getE7Right();
        Resource ancestor = this.input.getE7Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD1(TestKind.DELETE, comparison);
    }

    @Test
    public void testE8UseCase() throws IOException {
        Resource left = this.input.getE8Left();
        Resource right = this.input.getE8Right();
        Resource ancestor = this.input.getE8Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD2(TestKind.DELETE, comparison);
    }

    @Test
    public void testE9UseCase() throws IOException {
        Resource left = this.input.getE9Left();
        Resource right = this.input.getE9Right();
        Resource ancestor = this.input.getE9Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD3(TestKind.DELETE, comparison);
    }

    @Test
    public void testE10UseCase() throws IOException {
        Resource left = this.input.getE10Left();
        Resource right = this.input.getE10Right();
        Resource ancestor = this.input.getE10Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD4(TestKind.DELETE, comparison);
    }

    @Test
    public void testE11UseCase() throws IOException {
        Resource left = this.input.getE11Left();
        Resource right = this.input.getE11Right();
        Resource ancestor = this.input.getE11Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD5(TestKind.DELETE, comparison);
    }

    @Test
    public void testF1UseCase1() throws IOException {
        Resource left = this.input.getF1Left();
        Resource right = this.input.getF1Right();
        Resource ancestor = this.input.getF1Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB1(TestKind.ADD, comparison);
    }

    @Test
    public void testF2UseCase() throws IOException {
        Resource left = this.input.getF2Left();
        Resource right = this.input.getF2Right();
        Resource ancestor = this.input.getF2Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB2(TestKind.ADD, comparison);
    }

    @Test
    public void testF3UseCase() throws IOException {
        Resource left = this.input.getF3Left();
        Resource right = this.input.getF3Right();
        Resource ancestor = this.input.getF3Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB3(TestKind.ADD, comparison);
    }

    @Test
    public void testF4UseCase() throws IOException {
        Resource left = this.input.getF4Left();
        Resource right = this.input.getF4Right();
        Resource ancestor = this.input.getF4Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB4(TestKind.ADD, comparison);
    }

    @Test
    public void testF5UseCase() throws IOException {
        Resource left = this.input.getF5Left();
        Resource right = this.input.getF5Right();
        Resource ancestor = this.input.getF5Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB5(TestKind.ADD, comparison);
    }

    @Test
    public void testF6UseCase() throws IOException {
        Resource left = this.input.getF6Left();
        Resource right = this.input.getF6Right();
        Resource ancestor = this.input.getF6Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testAB6(TestKind.ADD, comparison);
    }

    @Test
    public void testF7UseCase() throws IOException {
        Resource left = this.input.getF7Left();
        Resource right = this.input.getF7Right();
        Resource ancestor = this.input.getF7Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD1(TestKind.ADD, comparison);
    }

    @Test
    public void testF8UseCase() throws IOException {
        Resource left = this.input.getF8Left();
        Resource right = this.input.getF8Right();
        Resource ancestor = this.input.getF8Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD2(TestKind.ADD, comparison);
    }

    @Test
    public void testF9UseCase() throws IOException {
        Resource left = this.input.getF9Left();
        Resource right = this.input.getF9Right();
        Resource ancestor = this.input.getF9Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD3(TestKind.ADD, comparison);
    }

    @Test
    public void testF10UseCase() throws IOException {
        Resource left = this.input.getF10Left();
        Resource right = this.input.getF10Right();
        Resource ancestor = this.input.getF10Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD4(TestKind.ADD, comparison);
    }

    @Test
    public void testF11UseCase() throws IOException {
        Resource left = this.input.getF11Left();
        Resource right = this.input.getF11Right();
        Resource ancestor = this.input.getF11Ancestor();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testCD5(TestKind.ADD, comparison);
    }

    @Test
    public void testG1UseCase() throws IOException {
        Resource left = this.input.getG1Left();
        Resource right = this.input.getG1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        String root = "root";
        String node1 = String.valueOf(root) + ".node1";
        String node2 = String.valueOf(node1) + ".node2";
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff added1 = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.added((String)node1)), null);
        Assert.assertNotNull((Object)added1);
        Diff added2 = (Diff)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.added((String)node2)), null);
        Assert.assertNotNull((Object)added2);
        ReferenceChange singleChange = null;
        for (ReferenceChange change : Iterables.filter((Iterable)differences, ReferenceChange.class)) {
            if (!"singleValuedReference".equals(change.getReference().getName())) continue;
            singleChange = change;
            break;
        }
        Assert.assertNotNull(singleChange);
        assert (singleChange != null);
        Assert.assertTrue((boolean)singleChange.getValue().eIsProxy());
        Assert.assertEquals((long)0L, (long)added1.getRequires().size());
        Assert.assertEquals((long)1L, (long)added2.getRequires().size());
        Assert.assertTrue((boolean)added2.getRequires().contains((Object)added1));
        Assert.assertEquals((long)1L, (long)singleChange.getRequires().size());
        Assert.assertTrue((boolean)singleChange.getRequires().contains((Object)added2));
    }

    @Test
    public void testH1UseCase() throws IOException {
        Resource left = this.input.getH1Left();
        Resource origin = this.input.getH1Ancestor();
        Resource right = this.input.getH1Right();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)1L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testH(TestKind.DELETE, comparison);
        scope = new DefaultComparisonScope((Notifier)rightSet, (Notifier)leftSet, (Notifier)originSet);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testH(TestKind.DELETE, comparison);
    }

    @Test
    public void testH2UseCase() throws IOException {
        Resource left = this.input.getH2Left();
        Resource origin = this.input.getH2Ancestor();
        Resource right = this.input.getH2Right();
        ResourceSet leftSet = left.getResourceSet();
        ResourceSet originSet = origin.getResourceSet();
        ResourceSet rightSet = right.getResourceSet();
        Assert.assertNotNull((Object)leftSet);
        Assert.assertNotNull((Object)originSet);
        Assert.assertNotNull((Object)rightSet);
        EcoreUtil.resolveAll((ResourceSet)leftSet);
        EcoreUtil.resolveAll((ResourceSet)originSet);
        EcoreUtil.resolveAll((ResourceSet)rightSet);
        Assert.assertEquals((long)2L, (long)leftSet.getResources().size());
        Assert.assertEquals((long)1L, (long)originSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightSet.getResources().size());
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftSet, (Notifier)rightSet, (Notifier)originSet);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testH(TestKind.ADD, comparison);
        scope = new DefaultComparisonScope((Notifier)rightSet, (Notifier)leftSet, (Notifier)originSet);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.testH(TestKind.ADD, comparison);
    }

    private void testH(TestKind testKind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Collection racs = Collections2.filter((Collection)differences, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        Assert.assertEquals((long)1L, (long)racs.size());
        Diff rac = (Diff)racs.iterator().next();
        Predicate deleteFragmentedDiffDescription = null;
        Predicate deleteInnerNodeDiffDescription = null;
        if (testKind == TestKind.DELETE) {
            deleteFragmentedDiffDescription = EMFComparePredicates.removed((String)"root.fragmented");
            deleteInnerNodeDiffDescription = EMFComparePredicates.removed((String)"root.fragmented.innerNode");
        } else {
            deleteFragmentedDiffDescription = EMFComparePredicates.added((String)"root.fragmented");
            deleteInnerNodeDiffDescription = EMFComparePredicates.added((String)"root.fragmented.innerNode");
        }
        Diff deleteFragmentedDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)deleteFragmentedDiffDescription);
        Diff deleteInnerNodeDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)deleteInnerNodeDiffDescription);
        if (testKind == TestKind.DELETE) {
            Assert.assertEquals((long)1L, (long)rac.getRequiredBy().size());
            Assert.assertEquals((Object)deleteFragmentedDiff, (Object)rac.getRequiredBy().get(0));
            Assert.assertEquals((long)0L, (long)rac.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteInnerNodeDiff.getRequiredBy().size());
            Assert.assertEquals((Object)deleteFragmentedDiff, (Object)deleteInnerNodeDiff.getRequiredBy().get(0));
            Assert.assertEquals((long)0L, (long)deleteInnerNodeDiff.getRequires().size());
        } else {
            Assert.assertEquals((long)1L, (long)rac.getRequires().size());
            Assert.assertEquals((Object)deleteFragmentedDiff, (Object)rac.getRequires().get(0));
            Assert.assertEquals((long)0L, (long)rac.getRequiredBy().size());
            Assert.assertEquals((long)1L, (long)deleteInnerNodeDiff.getRequires().size());
            Assert.assertEquals((Object)deleteFragmentedDiff, (Object)deleteInnerNodeDiff.getRequires().get(0));
            Assert.assertEquals((long)0L, (long)deleteInnerNodeDiff.getRequiredBy().size());
        }
    }

    private void testAB1(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate deleteSourceDiffDescription = null;
        Predicate deleteDestinationDiffDescription = null;
        Predicate changedSingleValuedRefDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteSourceDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerSource.source");
            deleteDestinationDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination");
            changedSingleValuedRefDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.containerSource.source", (String)"singleValuedReference", (String)"Requirements.containerDestination.destination", null);
        } else {
            deleteSourceDiffDescription = EMFComparePredicates.added((String)"Requirements.containerSource.source");
            deleteDestinationDiffDescription = EMFComparePredicates.added((String)"Requirements.containerDestination.destination");
            changedSingleValuedRefDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.containerSource.source", (String)"singleValuedReference", null, (String)"Requirements.containerDestination.destination");
        }
        Diff deleteSourceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteSourceDiffDescription);
        Diff deleteDestinationDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteDestinationDiffDescription);
        Diff changedSingleValuedRefDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changedSingleValuedRefDiffDescription);
        Assert.assertNotNull((Object)deleteSourceDiff);
        Assert.assertNotNull((Object)deleteDestinationDiff);
        Assert.assertNotNull((Object)changedSingleValuedRefDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteSourceDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertEquals((long)2L, (long)changedSingleValuedRefDiff.getRequires().size());
            Assert.assertTrue((boolean)changedSingleValuedRefDiff.getRequires().contains((Object)deleteDestinationDiff));
            Assert.assertTrue((boolean)changedSingleValuedRefDiff.getRequires().contains((Object)deleteSourceDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteSourceDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)changedSingleValuedRefDiff.getRequires().size());
        }
    }

    private void testAB2(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate deleteSourceDiffDescription = null;
        Predicate deleteDestinationDiffDescription = null;
        Predicate deleteMultiValuedRefDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteSourceDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerSource.source");
            deleteDestinationDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination");
            deleteMultiValuedRefDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination");
        } else {
            deleteSourceDiffDescription = EMFComparePredicates.added((String)"Requirements.containerSource.source");
            deleteDestinationDiffDescription = EMFComparePredicates.added((String)"Requirements.containerDestination.destination");
            deleteMultiValuedRefDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination");
        }
        Diff deleteSourceDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteSourceDiffDescription);
        Diff deleteDestinationDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteDestinationDiffDescription);
        Diff deleteMultiValuedRefDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteMultiValuedRefDiffDescription);
        Assert.assertNotNull((Object)deleteSourceDiff);
        Assert.assertNotNull((Object)deleteDestinationDiff);
        Assert.assertNotNull((Object)deleteMultiValuedRefDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteSourceDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertEquals((long)2L, (long)deleteMultiValuedRefDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteMultiValuedRefDiff.getRequires().contains((Object)deleteDestinationDiff));
            Assert.assertTrue((boolean)deleteMultiValuedRefDiff.getRequires().contains((Object)deleteSourceDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteSourceDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteSourceDiff.getRequires().contains((Object)deleteMultiValuedRefDiff));
            Assert.assertEquals((long)1L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteDestinationDiff.getRequires().contains((Object)deleteMultiValuedRefDiff));
            Assert.assertEquals((long)0L, (long)deleteMultiValuedRefDiff.getRequires().size());
        }
    }

    private void testAB3(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate deleteDestinationDiffDescription = null;
        Predicate changedSingleValuedRefDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteDestinationDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination2");
            changedSingleValuedRefDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.containerSource.source", (String)"singleValuedReference", (String)"Requirements.containerDestination.destination2", (String)"Requirements.destination1");
        } else {
            deleteDestinationDiffDescription = EMFComparePredicates.added((String)"Requirements.containerDestination.destination2");
            changedSingleValuedRefDiffDescription = EMFComparePredicates.changedReference((String)"Requirements.containerSource.source", (String)"singleValuedReference", (String)"Requirements.destination1", (String)"Requirements.containerDestination.destination2");
        }
        Diff deleteDestinationDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteDestinationDiffDescription);
        Diff changedSingleValuedRefDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)changedSingleValuedRefDiffDescription);
        Assert.assertNotNull((Object)deleteDestinationDiff);
        Assert.assertNotNull((Object)changedSingleValuedRefDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)changedSingleValuedRefDiff.getRequires().size());
            Assert.assertTrue((boolean)changedSingleValuedRefDiff.getRequires().contains((Object)deleteDestinationDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteDestinationDiff.getRequires().contains((Object)changedSingleValuedRefDiff));
            Assert.assertEquals((long)0L, (long)changedSingleValuedRefDiff.getRequires().size());
        }
    }

    private void testAB4(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate deleteDestinationDiffDescription = null;
        Predicate deletedMultiValuedRefDiffDescription = null;
        Predicate addedMultiValuedRefDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteDestinationDiffDescription = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination2");
            deletedMultiValuedRefDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination2");
            addedMultiValuedRefDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination1");
        } else {
            deleteDestinationDiffDescription = EMFComparePredicates.added((String)"Requirements.containerDestination.destination2");
            deletedMultiValuedRefDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination2");
            addedMultiValuedRefDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination1");
        }
        Diff deleteDestinationDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteDestinationDiffDescription);
        Diff deletedMultiValuedRefDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deletedMultiValuedRefDiffDescription);
        Diff addedMultiValuedRefDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)addedMultiValuedRefDiffDescription);
        Assert.assertNotNull((Object)deleteDestinationDiff);
        Assert.assertNotNull((Object)deletedMultiValuedRefDiff);
        Assert.assertNotNull((Object)addedMultiValuedRefDiffDescription);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deletedMultiValuedRefDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)addedMultiValuedRefDiff.getRequires().size());
            Assert.assertTrue((boolean)deletedMultiValuedRefDiff.getRequires().contains((Object)deleteDestinationDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteDestinationDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteDestinationDiff.getRequires().contains((Object)deletedMultiValuedRefDiff));
            Assert.assertEquals((long)0L, (long)deletedMultiValuedRefDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)addedMultiValuedRefDiff.getRequires().size());
        }
    }

    private void testAB5(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)8L, (long)differences.size());
        Predicate addDest4Description = null;
        Predicate delDest2Description = null;
        Predicate delDest3Description = null;
        Predicate addRefDest1Description = null;
        Predicate addRefDest4Description = null;
        Predicate delRefDest2Description = null;
        Predicate delRefDest3Description = null;
        Predicate delRefDest5Description = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            addDest4Description = EMFComparePredicates.added((String)"Requirements.destination4");
            delDest2Description = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination2");
            delDest3Description = EMFComparePredicates.removed((String)"Requirements.containerDestination.destination3");
            addRefDest1Description = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination1");
            addRefDest4Description = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination4");
            delRefDest2Description = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination2");
            delRefDest3Description = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination3");
            delRefDest5Description = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination5");
        } else {
            addDest4Description = EMFComparePredicates.removed((String)"Requirements.destination4");
            delDest2Description = EMFComparePredicates.added((String)"Requirements.containerDestination.destination2");
            delDest3Description = EMFComparePredicates.added((String)"Requirements.containerDestination.destination3");
            addRefDest1Description = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination1");
            addRefDest4Description = EMFComparePredicates.removedFromReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination4");
            delRefDest2Description = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination2");
            delRefDest3Description = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.containerDestination.destination3");
            delRefDest5Description = EMFComparePredicates.addedToReference((String)"Requirements.containerSource.source", (String)"multiValuedReference", (String)"Requirements.destination5");
        }
        Diff addDest4 = (Diff)Iterators.find(differences.iterator(), (Predicate)addDest4Description);
        Diff delDest2 = (Diff)Iterators.find(differences.iterator(), (Predicate)delDest2Description);
        Diff delDest3 = (Diff)Iterators.find(differences.iterator(), (Predicate)delDest3Description);
        Diff addRefDest1 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefDest1Description);
        Diff addRefDest4 = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefDest4Description);
        Diff delRefDest2 = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefDest2Description);
        Diff delRefDest3 = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefDest3Description);
        Diff delRefDest5 = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefDest5Description);
        Assert.assertNotNull((Object)addDest4);
        Assert.assertNotNull((Object)delDest2);
        Assert.assertNotNull((Object)delDest3);
        Assert.assertNotNull((Object)addRefDest1);
        Assert.assertNotNull((Object)addRefDest4);
        Assert.assertNotNull((Object)delRefDest2);
        Assert.assertNotNull((Object)delRefDest3);
        Assert.assertNotNull((Object)delRefDest5);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addDest4.getRequires().size());
            Assert.assertTrue((boolean)addDest4.getRequires().contains((Object)addRefDest4));
            Assert.assertEquals((long)0L, (long)delDest2.getRequires().size());
            Assert.assertEquals((long)0L, (long)delDest3.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefDest1.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefDest4.getRequires().size());
            Assert.assertEquals((long)1L, (long)delRefDest2.getRequires().size());
            Assert.assertTrue((boolean)delRefDest2.getRequires().contains((Object)delDest2));
            Assert.assertEquals((long)1L, (long)delRefDest3.getRequires().size());
            Assert.assertTrue((boolean)delRefDest3.getRequires().contains((Object)delDest3));
            Assert.assertEquals((long)0L, (long)delRefDest5.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addDest4.getRequires().size());
            Assert.assertEquals((long)1L, (long)delDest2.getRequires().size());
            Assert.assertTrue((boolean)delDest2.getRequires().contains((Object)delRefDest2));
            Assert.assertEquals((long)1L, (long)delDest3.getRequires().size());
            Assert.assertTrue((boolean)delDest3.getRequires().contains((Object)delRefDest3));
            Assert.assertEquals((long)0L, (long)addRefDest1.getRequires().size());
            Assert.assertEquals((long)1L, (long)addRefDest4.getRequires().size());
            Assert.assertTrue((boolean)addRefDest4.getRequires().contains((Object)addDest4));
            Assert.assertEquals((long)0L, (long)delRefDest2.getRequires().size());
            Assert.assertEquals((long)0L, (long)delRefDest3.getRequires().size());
            Assert.assertEquals((long)0L, (long)delRefDest5.getRequires().size());
        }
    }

    private void testAB6(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)7L, (long)differences.size());
        Predicate delDestDescription = null;
        Predicate delContainerDescription = null;
        Predicate delSubContainerDescription = null;
        Predicate delSource1Description = null;
        Predicate delSource2Description = null;
        Predicate delRefSource1Description = null;
        Predicate delRefSource2Description = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            delDestDescription = EMFComparePredicates.removed((String)"Requirements.destination");
            delContainerDescription = EMFComparePredicates.removed((String)"Requirements.container");
            delSubContainerDescription = EMFComparePredicates.removed((String)"Requirements.container.subContainer");
            delSource1Description = EMFComparePredicates.removed((String)"Requirements.container.subContainer.source1");
            delSource2Description = EMFComparePredicates.removed((String)"Requirements.container.subContainer.source2");
            delRefSource1Description = EMFComparePredicates.changedReference((String)"Requirements.container.subContainer.source1", (String)"singleValuedReference", (String)"Requirements.destination", null);
            delRefSource2Description = EMFComparePredicates.removedFromReference((String)"Requirements.container.subContainer.source2", (String)"multiValuedReference", (String)"Requirements.destination");
        } else {
            delDestDescription = EMFComparePredicates.added((String)"Requirements.destination");
            delContainerDescription = EMFComparePredicates.added((String)"Requirements.container");
            delSubContainerDescription = EMFComparePredicates.added((String)"Requirements.container.subContainer");
            delSource1Description = EMFComparePredicates.added((String)"Requirements.container.subContainer.source1");
            delSource2Description = EMFComparePredicates.added((String)"Requirements.container.subContainer.source2");
            delRefSource1Description = EMFComparePredicates.changedReference((String)"Requirements.container.subContainer.source1", (String)"singleValuedReference", null, (String)"Requirements.destination");
            delRefSource2Description = EMFComparePredicates.addedToReference((String)"Requirements.container.subContainer.source2", (String)"multiValuedReference", (String)"Requirements.destination");
        }
        Diff delDest = (Diff)Iterators.find(differences.iterator(), (Predicate)delDestDescription);
        Diff delContainer = (Diff)Iterators.find(differences.iterator(), (Predicate)delContainerDescription);
        Diff delSubContainer = (Diff)Iterators.find(differences.iterator(), (Predicate)delSubContainerDescription);
        Diff delSource1 = (Diff)Iterators.find(differences.iterator(), (Predicate)delSource1Description);
        Diff delSource2 = (Diff)Iterators.find(differences.iterator(), (Predicate)delSource2Description);
        Diff delRefSource1 = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefSource1Description);
        Diff delRefSource2 = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefSource2Description);
        Assert.assertNotNull((Object)delDest);
        Assert.assertNotNull((Object)delContainer);
        Assert.assertNotNull((Object)delSubContainer);
        Assert.assertNotNull((Object)delSource1);
        Assert.assertNotNull((Object)delSource2);
        Assert.assertNotNull((Object)delRefSource1);
        Assert.assertNotNull((Object)delRefSource2);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)delDest.getRequires().size());
            Assert.assertEquals((long)0L, (long)delContainer.getRequires().size());
            Assert.assertEquals((long)1L, (long)delSubContainer.getRequires().size());
            Assert.assertTrue((boolean)delSubContainer.getRequires().contains((Object)delContainer));
            Assert.assertEquals((long)1L, (long)delSource1.getRequires().size());
            Assert.assertTrue((boolean)delSource1.getRequires().contains((Object)delSubContainer));
            Assert.assertEquals((long)1L, (long)delSource2.getRequires().size());
            Assert.assertTrue((boolean)delSource2.getRequires().contains((Object)delSubContainer));
            Assert.assertEquals((long)2L, (long)delRefSource1.getRequires().size());
            Assert.assertTrue((boolean)delRefSource1.getRequires().contains((Object)delSource1));
            Assert.assertTrue((boolean)delRefSource2.getRequires().contains((Object)delSource2));
            Assert.assertEquals((long)2L, (long)delRefSource2.getRequires().size());
            Assert.assertTrue((boolean)delRefSource1.getRequires().contains((Object)delDest));
            Assert.assertTrue((boolean)delRefSource2.getRequires().contains((Object)delDest));
        } else {
            Assert.assertEquals((long)2L, (long)delDest.getRequires().size());
            Assert.assertTrue((boolean)delDest.getRequires().contains((Object)delRefSource1));
            Assert.assertTrue((boolean)delDest.getRequires().contains((Object)delRefSource2));
            Assert.assertEquals((long)1L, (long)delContainer.getRequires().size());
            Assert.assertTrue((boolean)delContainer.getRequires().contains((Object)delSubContainer));
            Assert.assertEquals((long)2L, (long)delSubContainer.getRequires().size());
            Assert.assertTrue((boolean)delSubContainer.getRequires().contains((Object)delSource1));
            Assert.assertTrue((boolean)delSubContainer.getRequires().contains((Object)delSource2));
            Assert.assertEquals((long)1L, (long)delSource1.getRequires().size());
            Assert.assertTrue((boolean)delSource1.getRequires().contains((Object)delRefSource1));
            Assert.assertEquals((long)1L, (long)delSource2.getRequires().size());
            Assert.assertTrue((boolean)delSource2.getRequires().contains((Object)delRefSource2));
            Assert.assertEquals((long)0L, (long)delRefSource1.getRequires().size());
            Assert.assertEquals((long)0L, (long)delRefSource2.getRequires().size());
        }
    }

    private void testAB7(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate addBDescription = null;
        Predicate delCDescription = null;
        Predicate addEDescription = null;
        Predicate delFDescription = null;
        if (kind.equals((Object)TestKind.ADD)) {
            addBDescription = EMFComparePredicates.added((String)"Requirements.A.B");
            delCDescription = EMFComparePredicates.removed((String)"Requirements.A.C");
            addEDescription = EMFComparePredicates.added((String)"Requirements.D.E");
            delFDescription = EMFComparePredicates.removed((String)"Requirements.D.F");
        } else {
            addBDescription = EMFComparePredicates.removed((String)"Requirements.A.B");
            delCDescription = EMFComparePredicates.added((String)"Requirements.A.C");
            addEDescription = EMFComparePredicates.removed((String)"Requirements.D.E");
            delFDescription = EMFComparePredicates.added((String)"Requirements.D.F");
        }
        Diff addB = (Diff)Iterators.find(differences.iterator(), (Predicate)addBDescription);
        Diff delC = (Diff)Iterators.find(differences.iterator(), (Predicate)delCDescription);
        Diff addE = (Diff)Iterators.find(differences.iterator(), (Predicate)addEDescription);
        Diff delF = (Diff)Iterators.find(differences.iterator(), (Predicate)delFDescription);
        Assert.assertNotNull((Object)addB);
        Assert.assertNotNull((Object)delC);
        Assert.assertNotNull((Object)addE);
        Assert.assertNotNull((Object)delF);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addB.getRequires().size());
            Assert.assertTrue((boolean)addB.getRequires().contains((Object)delC));
            Assert.assertEquals((long)0L, (long)delC.getRequires().size());
            Assert.assertEquals((long)0L, (long)addE.getRequires().size());
            Assert.assertEquals((long)0L, (long)delF.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addB.getRequires().size());
            Assert.assertEquals((long)1L, (long)delC.getRequires().size());
            Assert.assertTrue((boolean)delC.getRequires().contains((Object)addB));
            Assert.assertEquals((long)0L, (long)addE.getRequires().size());
            Assert.assertEquals((long)0L, (long)delF.getRequires().size());
        }
    }

    private void testAB8(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)7L, (long)differences.size());
        Predicate addBDescription = null;
        Predicate delCDescription = null;
        Predicate changeRefBDescription = null;
        Predicate addEDescription = null;
        Predicate delFDescription = null;
        Predicate addRefEDescription = null;
        Predicate delRefFDescription = null;
        if (kind.equals((Object)TestKind.ADD)) {
            addBDescription = EMFComparePredicates.added((String)"Requirements.B");
            delCDescription = EMFComparePredicates.removed((String)"Requirements.C");
            changeRefBDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"singleValuedReference", (String)"Requirements.C", (String)"Requirements.B");
            addEDescription = EMFComparePredicates.added((String)"Requirements.E");
            delFDescription = EMFComparePredicates.removed((String)"Requirements.F");
            addRefEDescription = EMFComparePredicates.addedToReference((String)"Requirements.D", (String)"multiValuedReference", (String)"Requirements.E");
            delRefFDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D", (String)"multiValuedReference", (String)"Requirements.F");
        } else {
            addBDescription = EMFComparePredicates.removed((String)"Requirements.B");
            delCDescription = EMFComparePredicates.added((String)"Requirements.C");
            changeRefBDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"singleValuedReference", (String)"Requirements.B", (String)"Requirements.C");
            addEDescription = EMFComparePredicates.removed((String)"Requirements.E");
            delFDescription = EMFComparePredicates.added((String)"Requirements.F");
            addRefEDescription = EMFComparePredicates.removedFromReference((String)"Requirements.D", (String)"multiValuedReference", (String)"Requirements.E");
            delRefFDescription = EMFComparePredicates.addedToReference((String)"Requirements.D", (String)"multiValuedReference", (String)"Requirements.F");
        }
        Diff addB = (Diff)Iterators.find(differences.iterator(), (Predicate)addBDescription);
        Diff delC = (Diff)Iterators.find(differences.iterator(), (Predicate)delCDescription);
        Diff changeRefB = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefBDescription);
        Diff addE = (Diff)Iterators.find(differences.iterator(), (Predicate)addEDescription);
        Diff delF = (Diff)Iterators.find(differences.iterator(), (Predicate)delFDescription);
        Diff addRefE = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefEDescription);
        Diff delRefF = (Diff)Iterators.find(differences.iterator(), (Predicate)delRefFDescription);
        Assert.assertNotNull((Object)addB);
        Assert.assertNotNull((Object)delC);
        Assert.assertNotNull((Object)changeRefB);
        Assert.assertNotNull((Object)addE);
        Assert.assertNotNull((Object)delF);
        Assert.assertNotNull((Object)addRefE);
        Assert.assertNotNull((Object)delRefF);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addB.getRequires().size());
            Assert.assertEquals((long)1L, (long)delC.getRequires().size());
            Assert.assertTrue((boolean)delC.getRequires().contains((Object)changeRefB));
            Assert.assertEquals((long)1L, (long)changeRefB.getRequires().size());
            Assert.assertTrue((boolean)changeRefB.getRequires().contains((Object)addB));
            Assert.assertEquals((long)0L, (long)addE.getRequires().size());
            Assert.assertEquals((long)1L, (long)delF.getRequires().size());
            Assert.assertTrue((boolean)delF.getRequires().contains((Object)delRefF));
            Assert.assertEquals((long)1L, (long)addRefE.getRequires().size());
            Assert.assertTrue((boolean)addRefE.getRequires().contains((Object)addE));
            Assert.assertEquals((long)0L, (long)delRefF.getRequires().size());
        } else {
            Assert.assertEquals((long)1L, (long)addB.getRequires().size());
            Assert.assertTrue((boolean)addB.getRequires().contains((Object)changeRefB));
            Assert.assertEquals((long)0L, (long)delC.getRequires().size());
            Assert.assertEquals((long)1L, (long)changeRefB.getRequires().size());
            Assert.assertTrue((boolean)changeRefB.getRequires().contains((Object)delC));
            Assert.assertEquals((long)1L, (long)addE.getRequires().size());
            Assert.assertTrue((boolean)addE.getRequires().contains((Object)addRefE));
            Assert.assertEquals((long)0L, (long)delF.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefE.getRequires().size());
            Assert.assertEquals((long)1L, (long)delRefF.getRequires().size());
            Assert.assertTrue((boolean)delRefF.getRequires().contains((Object)delF));
        }
    }

    private void testAB9(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate addBDescription = null;
        Predicate addCDescription = null;
        if (kind.equals((Object)TestKind.ADD)) {
            addBDescription = EMFComparePredicates.added((String)"Requirements.A.B");
            addCDescription = EMFComparePredicates.added((String)"Requirements.A.B.C");
        } else {
            addBDescription = EMFComparePredicates.removed((String)"Requirements.A.B");
            addCDescription = EMFComparePredicates.removed((String)"Requirements.A.B.C");
        }
        Diff addB = (Diff)Iterators.find(differences.iterator(), (Predicate)addBDescription);
        Diff addC = (Diff)Iterators.find(differences.iterator(), (Predicate)addCDescription);
        Assert.assertNotNull((Object)addB);
        Assert.assertNotNull((Object)addC);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addB.getRequires().size());
            Assert.assertEquals((long)1L, (long)addC.getRequires().size());
            Assert.assertTrue((boolean)addC.getRequires().contains((Object)addB));
        } else {
            Assert.assertEquals((long)1L, (long)addB.getRequires().size());
            Assert.assertTrue((boolean)addB.getRequires().contains((Object)addC));
            Assert.assertEquals((long)0L, (long)addC.getRequires().size());
        }
    }

    private void testAB10(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate addADescription = null;
        Predicate addCDescription = null;
        Predicate changeRefBDescription = null;
        Predicate addRefBDescription = null;
        if (kind.equals((Object)TestKind.ADD)) {
            addADescription = EMFComparePredicates.added((String)"Requirements.A");
            addCDescription = EMFComparePredicates.added((String)"Requirements.C");
            changeRefBDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"singleValuedReference", null, (String)"Requirements.B");
            addRefBDescription = EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"multiValuedReference", (String)"Requirements.B");
        } else {
            addADescription = EMFComparePredicates.removed((String)"Requirements.A");
            addCDescription = EMFComparePredicates.removed((String)"Requirements.C");
            changeRefBDescription = EMFComparePredicates.changedReference((String)"Requirements.A", (String)"singleValuedReference", (String)"Requirements.B", null);
            addRefBDescription = EMFComparePredicates.removedFromReference((String)"Requirements.C", (String)"multiValuedReference", (String)"Requirements.B");
        }
        Diff addA = (Diff)Iterators.find(differences.iterator(), (Predicate)addADescription);
        Diff addC = (Diff)Iterators.find(differences.iterator(), (Predicate)addCDescription);
        Diff changeRefB = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefBDescription);
        Diff addRefB = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefBDescription);
        Assert.assertNotNull((Object)addA);
        Assert.assertNotNull((Object)addC);
        Assert.assertNotNull((Object)changeRefB);
        Assert.assertNotNull((Object)addRefB);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addA.getRequires().size());
            Assert.assertEquals((long)0L, (long)addC.getRequires().size());
            Assert.assertEquals((long)1L, (long)changeRefB.getRequires().size());
            Assert.assertTrue((boolean)changeRefB.getRequires().contains((Object)addA));
            Assert.assertEquals((long)1L, (long)addRefB.getRequires().size());
            Assert.assertTrue((boolean)addRefB.getRequires().contains((Object)addC));
        } else {
            Assert.assertEquals((long)1L, (long)addA.getRequires().size());
            Assert.assertTrue((boolean)addA.getRequires().contains((Object)changeRefB));
            Assert.assertEquals((long)1L, (long)addC.getRequires().size());
            Assert.assertTrue((boolean)addC.getRequires().contains((Object)addRefB));
            Assert.assertEquals((long)0L, (long)changeRefB.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefB.getRequires().size());
        }
    }

    private void testAB11(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate delBDescription = null;
        Predicate moveCDescription = null;
        Predicate moveDDescription = null;
        Predicate moveEDescription = null;
        if (kind.equals((Object)TestKind.ADD)) {
            delBDescription = EMFComparePredicates.removed((String)"Requirements.A.B");
            moveCDescription = EMFComparePredicates.movedInReference((String)"Requirements.A", (String)"containmentRef1", (String)"Requirements.A.C");
            moveDDescription = EMFComparePredicates.movedInReference((String)"Requirements.A", (String)"containmentRef1", (String)"Requirements.A.D");
            moveEDescription = EMFComparePredicates.movedInReference((String)"Requirements.A.D", (String)"containmentRef1", (String)"Requirements.A.D.E");
        } else {
            delBDescription = EMFComparePredicates.added((String)"Requirements.A.B");
            moveCDescription = EMFComparePredicates.movedInReference((String)"Requirements.A.B", (String)"containmentRef1", (String)"Requirements.A.B.C");
            moveDDescription = EMFComparePredicates.movedInReference((String)"Requirements.A.E", (String)"containmentRef1", (String)"Requirements.A.E.D");
            moveEDescription = EMFComparePredicates.movedInReference((String)"Requirements.A", (String)"containmentRef1", (String)"Requirements.A.E");
        }
        Diff delB = (Diff)Iterators.find(differences.iterator(), (Predicate)delBDescription);
        Diff moveC = (Diff)Iterators.find(differences.iterator(), (Predicate)moveCDescription);
        Diff moveD = (Diff)Iterators.find(differences.iterator(), (Predicate)moveDDescription);
        Diff moveE = (Diff)Iterators.find(differences.iterator(), (Predicate)moveEDescription);
        Assert.assertNotNull((Object)delB);
        Assert.assertNotNull((Object)moveC);
        Assert.assertNotNull((Object)moveD);
        Assert.assertNotNull((Object)moveE);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)delB.getRequires().size());
            Assert.assertTrue((boolean)delB.getRequires().contains((Object)moveC));
            Assert.assertEquals((long)0L, (long)moveC.getRequires().size());
            Assert.assertEquals((long)0L, (long)moveD.getRequires().size());
            Assert.assertEquals((long)1L, (long)moveE.getRequires().size());
            Assert.assertTrue((boolean)moveE.getRequires().contains((Object)moveD));
        } else {
            Assert.assertEquals((long)0L, (long)delB.getRequires().size());
            Assert.assertEquals((long)1L, (long)moveC.getRequires().size());
            Assert.assertTrue((boolean)moveC.getRequires().contains((Object)delB));
            Assert.assertEquals((long)1L, (long)moveD.getRequires().size());
            Assert.assertTrue((boolean)moveD.getRequires().contains((Object)moveE));
            Assert.assertEquals((long)0L, (long)moveE.getRequires().size());
        }
    }

    private void testCD1(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        Predicate deleteADiffDescription = null;
        Predicate deleteBDiffDescription = null;
        Predicate deleteCDiffDescription = null;
        Predicate deleteRefBDiffDescription = null;
        Predicate deleteRefCDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteADiffDescription = EMFComparePredicates.removed((String)"Requirements.A");
            deleteBDiffDescription = EMFComparePredicates.removed((String)"Requirements.B");
            deleteCDiffDescription = EMFComparePredicates.removed((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        } else {
            deleteADiffDescription = EMFComparePredicates.added((String)"Requirements.A");
            deleteBDiffDescription = EMFComparePredicates.added((String)"Requirements.B");
            deleteCDiffDescription = EMFComparePredicates.added((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        }
        Diff deleteADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteADiffDescription);
        Diff deleteBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteBDiffDescription);
        Diff deleteCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteCDiffDescription);
        Diff deleteRefBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefBDiffDescription);
        Diff deleteRefCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefCDiffDescription);
        Assert.assertNotNull((Object)deleteADiff);
        Assert.assertNotNull((Object)deleteBDiff);
        Assert.assertNotNull((Object)deleteCDiff);
        Assert.assertNotNull((Object)deleteRefBDiff);
        Assert.assertNotNull((Object)deleteRefCDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteADiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteCDiff.getRequires().size());
            Assert.assertEquals((long)2L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefBDiff.getRequires().contains((Object)deleteBDiff));
            Assert.assertTrue((boolean)deleteRefBDiff.getRequires().contains((Object)deleteADiff));
            Assert.assertEquals((long)2L, (long)deleteRefCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteCDiff));
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteADiff));
        } else {
            Assert.assertEquals((long)2L, (long)deleteADiff.getRequires().size());
            Assert.assertTrue((boolean)deleteADiff.getRequires().contains((Object)deleteRefBDiff));
            Assert.assertTrue((boolean)deleteADiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)1L, (long)deleteBDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteBDiff.getRequires().contains((Object)deleteRefBDiff));
            Assert.assertEquals((long)1L, (long)deleteCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteCDiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)0L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteRefCDiff.getRequires().size());
        }
    }

    private void testCD2(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate deleteADiffDescription = null;
        Predicate deleteCDiffDescription = null;
        Predicate deleteRefBDiffDescription = null;
        Predicate deleteRefCDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteADiffDescription = EMFComparePredicates.removed((String)"Requirements.A");
            deleteCDiffDescription = EMFComparePredicates.removed((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        } else {
            deleteADiffDescription = EMFComparePredicates.added((String)"Requirements.A");
            deleteCDiffDescription = EMFComparePredicates.added((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        }
        Diff deleteADiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteADiffDescription);
        Diff deleteCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteCDiffDescription);
        Diff deleteRefBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefBDiffDescription);
        Diff deleteRefCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefCDiffDescription);
        Assert.assertNotNull((Object)deleteADiff);
        Assert.assertNotNull((Object)deleteCDiff);
        Assert.assertNotNull((Object)deleteRefBDiff);
        Assert.assertNotNull((Object)deleteRefCDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteADiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteCDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefBDiff.getRequires().contains((Object)deleteADiff));
            Assert.assertEquals((long)2L, (long)deleteRefCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteCDiff));
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteADiff));
        } else {
            Assert.assertEquals((long)2L, (long)deleteADiff.getRequires().size());
            Assert.assertTrue((boolean)deleteADiff.getRequires().contains((Object)deleteRefBDiff));
            Assert.assertTrue((boolean)deleteADiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)1L, (long)deleteCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteCDiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)0L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteRefCDiff.getRequires().size());
        }
    }

    private void testCD3(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate deleteBDiffDescription = null;
        Predicate deleteCDiffDescription = null;
        Predicate deleteRefBDiffDescription = null;
        Predicate deleteRefCDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteBDiffDescription = EMFComparePredicates.removed((String)"Requirements.B");
            deleteCDiffDescription = EMFComparePredicates.removed((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        } else {
            deleteBDiffDescription = EMFComparePredicates.added((String)"Requirements.B");
            deleteCDiffDescription = EMFComparePredicates.added((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        }
        Diff deleteBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteBDiffDescription);
        Diff deleteCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteCDiffDescription);
        Diff deleteRefBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefBDiffDescription);
        Diff deleteRefCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefCDiffDescription);
        Assert.assertNotNull((Object)deleteBDiff);
        Assert.assertNotNull((Object)deleteCDiff);
        Assert.assertNotNull((Object)deleteRefBDiff);
        Assert.assertNotNull((Object)deleteRefCDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteCDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefBDiff.getRequires().contains((Object)deleteBDiff));
            Assert.assertEquals((long)1L, (long)deleteRefCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteCDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteBDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteBDiff.getRequires().contains((Object)deleteRefBDiff));
            Assert.assertEquals((long)1L, (long)deleteCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteCDiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)0L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteRefCDiff.getRequires().size());
        }
    }

    private void testCD4(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate deleteCDiffDescription = null;
        Predicate deleteRefBDiffDescription = null;
        Predicate deleteRefCDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteCDiffDescription = EMFComparePredicates.removed((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        } else {
            deleteCDiffDescription = EMFComparePredicates.added((String)"Requirements.C");
            deleteRefBDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.B");
            deleteRefCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        }
        Diff deleteCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteCDiffDescription);
        Diff deleteRefBDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefBDiffDescription);
        Diff deleteRefCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefCDiffDescription);
        Assert.assertNotNull((Object)deleteCDiff);
        Assert.assertNotNull((Object)deleteRefBDiff);
        Assert.assertNotNull((Object)deleteRefCDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteCDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteRefCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteCDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteCDiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)0L, (long)deleteRefBDiff.getRequires().size());
            Assert.assertEquals((long)0L, (long)deleteRefCDiff.getRequires().size());
        }
    }

    private void testCD5(TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Predicate deleteCDiffDescription = null;
        Predicate deleteRefCDiffDescription = null;
        if (kind.equals((Object)TestKind.DELETE)) {
            deleteCDiffDescription = EMFComparePredicates.removed((String)"Requirements.C");
            deleteRefCDiffDescription = EMFComparePredicates.removedFromReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        } else {
            deleteCDiffDescription = EMFComparePredicates.added((String)"Requirements.C");
            deleteRefCDiffDescription = EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"multiValuedReference", (String)"Requirements.C");
        }
        Diff deleteCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteCDiffDescription);
        Diff deleteRefCDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)deleteRefCDiffDescription);
        Assert.assertNotNull((Object)deleteCDiff);
        Assert.assertNotNull((Object)deleteRefCDiff);
        if (kind.equals((Object)TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)deleteCDiff.getRequires().size());
            Assert.assertEquals((long)1L, (long)deleteRefCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteRefCDiff.getRequires().contains((Object)deleteCDiff));
        } else {
            Assert.assertEquals((long)1L, (long)deleteCDiff.getRequires().size());
            Assert.assertTrue((boolean)deleteCDiff.getRequires().contains((Object)deleteRefCDiff));
            Assert.assertEquals((long)0L, (long)deleteRefCDiff.getRequires().size());
        }
    }

    static enum TestKind {
        ADD,
        DELETE;

    }
}

