/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.match.data.MatchInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ProxyMatchingTest {
    private MatchInputData input = new MatchInputData();

    @Test
    public void testProxyA1() throws IOException {
        Resource left = this.input.getProxyMatchingA1Left();
        Resource right = this.input.getProxyMatchingA1Right();
        ResourceSet leftResourceSet = left.getResourceSet();
        ResourceSet rightResourceSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList matches = comparison.getMatches();
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = (Match)matches.get(0);
        EList subMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)2L, (long)subMatches.size());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
    }

    @Test
    public void testProxyA2() throws IOException {
        Resource left = this.input.getProxyMatchingA2Left();
        Resource right = this.input.getProxyMatchingA2Right();
        ResourceSet leftResourceSet = left.getResourceSet();
        ResourceSet rightResourceSet = right.getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList matches = comparison.getMatches();
        Assert.assertEquals((long)1L, (long)matches.size());
        Match rootMatch = (Match)matches.get(0);
        EList subMatches = rootMatch.getSubmatches();
        Assert.assertEquals((long)1L, (long)subMatches.size());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Assert.assertTrue((boolean)(differences.get(0) instanceof ResourceAttachmentChange));
    }
}

