/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import java.io.File;
import java.util.Arrays;
import org.apache.log4j.Level;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMFC_APPENDER_NAME = "EMFCFile";
    private Combo levelCombo;
    private Text fileField;
    private Text maxSizeField;
    private Text maxBackupField;
    private final String[] LOG_LEVELS = new String[]{"OFF", "ERROR", "INFO", "DEBUG"};
    public static final String LOG_FILENAME_KEY = "org.eclipse.emf.compare.log.file.name";
    public static final String LOG_LEVEL_KEY = "org.eclipse.emf.compare.log.level";
    public static final String LOG_BACKUP_COUNT_KEY = "org.eclipse.emf.compare.log.backup.count";
    public static final String LOG_FILE_MAX_SIZE_KEY = "org.eclipse.emf.compare.log.file.max.size";

    public LoggingPreferencePage() {
    }

    public LoggingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public LoggingPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return EMFCompareRCPUIPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.preferencePage.description"));
        new Label((Composite)group, 16384).setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.level"));
        this.levelCombo = new Combo((Composite)group, 4);
        this.levelCombo.setItems(this.LOG_LEVELS);
        this.levelCombo.setLayoutData((Object)this.getDefaultFieldGridData(40));
        Label fileLabel = new Label((Composite)group, 16384);
        fileLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file"));
        this.fileField = new Text((Composite)group, 2052);
        this.fileField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button fileButton = new Button((Composite)group, 8);
        fileButton.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.filebutton.label"));
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(LoggingPreferencePage.this.getShell(), 8192);
                File file = new File(LoggingPreferencePage.this.fileField.getText());
                dlg.setFileName(file.getName());
                dlg.setFilterPath(file.getParent());
                String fileName = dlg.open();
                if (fileName != null) {
                    LoggingPreferencePage.this.fileField.setText(fileName);
                }
            }
        });
        Label maxSizeLabel = new Label((Composite)group, 16384);
        maxSizeLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.file.size"));
        this.maxSizeField = new Text((Composite)group, 2052);
        this.maxSizeField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxSizeField.addVerifyListener((VerifyListener)new VerifyIntegerListener());
        Label maxBackupLabel = new Label((Composite)group, 16384);
        maxBackupLabel.setText(EMFCompareRCPUIMessages.getString("LoggingPreferencePage.log.backup.count"));
        this.maxBackupField = new Text((Composite)group, 2052);
        this.maxBackupField.setLayoutData((Object)this.getDefaultFieldGridData(80));
        this.maxBackupField.addVerifyListener((VerifyListener)new VerifyIntegerListener());
        this.refreshWidgets();
        return group;
    }

    protected GridData getDefaultFieldGridData(int width) {
        GridData gd = new GridData(16384, 128, false, false, 2, 1);
        gd.widthHint = width;
        return gd;
    }

    protected void savePreferences() {
        this.getPreferenceStore().setValue(LOG_FILENAME_KEY, this.fileField.getText());
        this.getPreferenceStore().setValue(LOG_LEVEL_KEY, this.levelCombo.getText());
        this.getPreferenceStore().setValue(LOG_BACKUP_COUNT_KEY, this.maxBackupField.getText());
        this.getPreferenceStore().setValue(LOG_FILE_MAX_SIZE_KEY, this.maxSizeField.getText());
    }

    protected void resetPreferences() {
        this.getPreferenceStore().setToDefault(LOG_FILENAME_KEY);
        this.getPreferenceStore().setToDefault(LOG_LEVEL_KEY);
        this.getPreferenceStore().setToDefault(LOG_BACKUP_COUNT_KEY);
        this.getPreferenceStore().setToDefault(LOG_FILE_MAX_SIZE_KEY);
    }

    protected void refreshWidgets() {
        String fileName = this.getPreferenceStore().getString(LOG_FILENAME_KEY);
        String level = this.getPreferenceStore().getString(LOG_LEVEL_KEY);
        int maxBackupCount = this.getPreferenceStore().getInt(LOG_BACKUP_COUNT_KEY);
        int maxSizeInMB = this.getPreferenceStore().getInt(LOG_FILE_MAX_SIZE_KEY);
        this.levelCombo.select(Arrays.asList(this.LOG_LEVELS).indexOf(level));
        this.levelCombo.pack();
        this.fileField.setText(fileName);
        this.maxBackupField.setText(Integer.toString(maxBackupCount));
        this.maxSizeField.setText(Integer.toString(maxSizeInMB));
    }

    public boolean performOk() {
        String item = this.levelCombo.getItem(this.levelCombo.getSelectionIndex());
        EMFCompareRCPUIPlugin.LOGGER.setLevel(Level.toLevel((String)item));
        this.savePreferences();
        this.refreshWidgets();
        return super.performOk();
    }

    protected void performDefaults() {
        this.resetPreferences();
        this.refreshWidgets();
        super.performDefaults();
    }

    private static class VerifyIntegerListener
    implements VerifyListener {
        private VerifyIntegerListener() {
        }

        public void verifyText(VerifyEvent evt) {
            try {
                Integer.parseInt(evt.text);
            }
            catch (NumberFormatException numberFormatException) {
                evt.doit = false;
            }
        }
    }
}

