/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FiltersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.emf.compare.rcp.ui.preferencePage.filters";
    public static final String SYNCHRONIZATION_BEHAVIOR = "org.eclipse.emf.compare.rcp.ui.filters.syncbehavior";
    private static final List<String> comboValues = Lists.newArrayList((Object[])new String[]{"always", "never", "prompt"});
    private DifferenceFilterManager filterManager;
    private InteractiveFilterUIContent filterInteractiveContent;

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp.ui");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, true));
        this.filterManager = EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterManager();
        this.filterInteractiveContent = new InteractiveFilterUIContent(container, this.filterManager.getAllFilters(), this.filterManager.getCurrentByDefaultFilters());
        this.filterInteractiveContent.setComboInput(this.getCurrentSynchronizationBehavior());
        return container;
    }

    public String getCurrentSynchronizationBehavior() {
        String value = this.getPreferenceStore().getString(SYNCHRONIZATION_BEHAVIOR);
        if (value == null || !comboValues.contains(value)) {
            value = this.getDefaultSynchronizationBehavior();
        }
        return value;
    }

    public String getDefaultSynchronizationBehavior() {
        return "prompt";
    }

    public void setCurrentSynchronizationBehavior(String newBehavior) {
        if (this.getDefaultSynchronizationBehavior().equals(newBehavior)) {
            this.getPreferenceStore().setToDefault(SYNCHRONIZATION_BEHAVIOR);
        } else {
            this.getPreferenceStore().setValue(SYNCHRONIZATION_BEHAVIOR, newBehavior);
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder builder = new StringBuilder();
            builder.append("Preference ").append(SYNCHRONIZATION_BEHAVIOR).append(":\n");
            String preferenceValue = this.getPreferenceStore().getString(SYNCHRONIZATION_BEHAVIOR);
            builder.append(preferenceValue);
            EMFCompareRCPUIPlugin.getDefault().log(1, builder.toString());
        }
    }

    public boolean performOk() {
        this.filterManager.setCurrentByDefaultFilters(this.filterInteractiveContent.getCheckedFilter());
        this.setCurrentSynchronizationBehavior(this.filterInteractiveContent.getSynchronizationBehavior());
        return super.performOk();
    }

    protected void performDefaults() {
        this.filterInteractiveContent.checkElements(this.filterManager.getInitialByDefaultFilters());
        this.filterInteractiveContent.setComboInput(this.getDefaultSynchronizationBehavior());
        super.performDefaults();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InteractiveFilterUIContent {
        private final Label descriptionText;
        private CheckboxTableViewer viewer;
        private FilterDataHolder dataHolder = new FilterDataHolder();
        private Combo combo;
        private String synchronizationBehaviorValue;

        private InteractiveFilterUIContent(Composite parent, Collection<IDifferenceFilter> filters, Collection<IDifferenceFilter> defaultCheck) {
            Composite contentComposite = new Composite(parent, 2048);
            contentComposite.setLayout((Layout)new GridLayout(1, true));
            contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Label introductionText = new Label(contentComposite, 64);
            introductionText.setText(EMFCompareRCPUIMessages.getString("FiltersPreferencePage.INTRO_TEXT"));
            introductionText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            Composite viewerComposite = new Composite(contentComposite, 0);
            viewerComposite.setLayout((Layout)new GridLayout(1, true));
            viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.viewer = this.createViewer(viewerComposite);
            this.descriptionText = this.createDescriptionComposite(contentComposite);
            this.createSynchronizationBehaviorContent(parent);
            this.setViewerInput(Lists.newArrayList(filters));
            this.bindAndInit(Sets.newLinkedHashSet(defaultCheck));
        }

        private void createSynchronizationBehaviorContent(Composite parent) {
            Group synchronizationGroup = new Group(parent, 0);
            GridData layoutData = new GridData(4, 1024, true, false);
            GridLayout layout = new GridLayout(2, false);
            synchronizationGroup.setLayout((Layout)layout);
            synchronizationGroup.setLayoutData((Object)layoutData);
            synchronizationGroup.setText(EMFCompareRCPUIMessages.getString("InteractiveFilterUIContent.sync.behavior.group.label"));
            Label label = new Label((Composite)synchronizationGroup, 64);
            label.setText(EMFCompareRCPUIMessages.getString("InteractiveFilterUIContent.sync.behavior.label"));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.combo = new Combo((Composite)synchronizationGroup, 12);
            for (String comboLabel : comboValues) {
                this.combo.add(comboLabel);
            }
            this.combo.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (InteractiveFilterUIContent.this.combo.equals(e.getSource())) {
                        InteractiveFilterUIContent.this.synchronizationBehaviorValue = InteractiveFilterUIContent.this.combo.getItem(InteractiveFilterUIContent.this.combo.getSelectionIndex());
                    }
                }
            });
        }

        public String getSynchronizationBehavior() {
            return this.synchronizationBehaviorValue;
        }

        public Set<IDifferenceFilter> getCheckedFilter() {
            return this.dataHolder.getFilters();
        }

        private void setViewerInput(List<IDifferenceFilter> filters) {
            Collections.sort(filters, new Comparator<IDifferenceFilter>(){

                @Override
                public int compare(IDifferenceFilter o1, IDifferenceFilter o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null || o1.getLabel() == null) {
                        return -1;
                    }
                    if (o2 == null || o2.getLabel() == null) {
                        return 1;
                    }
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            this.viewer.setInput(filters);
            this.select(filters.iterator().next());
        }

        private CheckboxTableViewer createViewer(Composite viewerCompsite) {
            CheckboxTableViewer descriptorViewer = CheckboxTableViewer.newCheckList((Composite)viewerCompsite, (int)68096);
            descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            descriptorViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            descriptorViewer.getControl().setLayoutData((Object)gd);
            this.setViewer(descriptorViewer);
            return descriptorViewer;
        }

        private void bindAndInit(Set<IDifferenceFilter> defaultCheck) {
            if (this.dataHolder != null) {
                if (defaultCheck != null) {
                    this.dataHolder.setFilters(defaultCheck);
                }
                this.bindMultipleData(this.viewer, this.dataHolder);
            }
        }

        private void bindMultipleData(CheckboxTableViewer descriptorViewer, FilterDataHolder dataObject) {
            DataBindingContext ctx = new DataBindingContext();
            IViewerObservableSet target = ViewersObservables.observeCheckedElements((CheckboxTableViewer)descriptorViewer, IDifferenceFilter.class);
            IObservableSet model = PojoProperties.set(FilterDataHolder.class, (String)"filters").observe((Object)dataObject);
            ctx.bindSet((IObservableSet)target, model);
        }

        public void checkElements(Set<IDifferenceFilter> checkedFilter) {
            this.viewer.setCheckedElements(checkedFilter.toArray());
            this.dataHolder.setFilters(checkedFilter);
        }

        private Label createDescriptionComposite(Composite composite) {
            Group descriptionComposite = new Group(composite, 0);
            descriptionComposite.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.descriptionComposite.label"));
            descriptionComposite.setLayout((Layout)new GridLayout(1, false));
            descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Label engineDescriptionLabel = new Label((Composite)descriptionComposite, 64);
            engineDescriptionLabel.setBackground(Display.getCurrent().getSystemColor(22));
            GridData layoutData = new GridData(4, 4, true, false, 1, 1);
            layoutData.widthHint = 400;
            layoutData.heightHint = 50;
            engineDescriptionLabel.setLayoutData((Object)layoutData);
            return engineDescriptionLabel;
        }

        public void select(IDifferenceFilter descriptor) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)descriptor), true);
            String description = descriptor.getDescription();
            if (description != null) {
                this.descriptionText.setText(description);
            } else {
                this.descriptionText.setText("");
            }
        }

        public void setViewer(CheckboxTableViewer inputViewer) {
            this.viewer = inputViewer;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)new DescriptionListener());
        }

        public void setComboInput(String behavior) {
            int index = 0;
            for (String value : comboValues) {
                if (value.equals(behavior)) {
                    this.combo.select(index);
                    this.synchronizationBehaviorValue = behavior;
                }
                ++index;
            }
        }

        private final class DescriptionListener
        implements ISelectionChangedListener {
            private DescriptionListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structSelection;
                Object selected;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IDifferenceFilter) {
                    IDifferenceFilter desc = (IDifferenceFilter)selected;
                    String description = desc.getDescription();
                    if (description != null) {
                        InteractiveFilterUIContent.this.descriptionText.setText(description);
                    } else {
                        InteractiveFilterUIContent.this.descriptionText.setText("");
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class FilterDataHolder {
            private static final String FIELD_NAME = "filters";
            private Set<IDifferenceFilter> filters;

            private FilterDataHolder() {
            }

            public Set<IDifferenceFilter> getFilters() {
                return this.filters;
            }

            public void setFilters(Set<IDifferenceFilter> filters) {
                this.filters = filters;
            }
        }

        private static final class FilterLabelProvider
        extends LabelProvider {
            private FilterLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof IDifferenceFilter) {
                    return ((IDifferenceFilter)element).getLabel();
                }
                return super.getText(element);
            }
        }
    }
}

