/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeRunnable;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.internal.utils.PruningIterator;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAllNonConflictingRunnable
extends AbstractMergeRunnable
implements IMergeAllNonConflictingRunnable {
    public MergeAllNonConflictingRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        super(isLeftEditable, isRightEditable, mergeMode);
    }

    public Iterable<Diff> merge(Comparison comparison, boolean leftToRight, IMerger.Registry mergerRegistry) {
        ArrayList affectedDiffs;
        Preconditions.checkState((this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) == leftToRight ? 1 : 0) != 0);
        BasicMonitor emfMonitor = new BasicMonitor();
        if (MergeAllNonConflictingRunnable.hasRealConflict(comparison)) {
            Graph differencesGraph = MergeDependenciesUtil.mapDifferences((Comparison)comparison, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0);
            PruningIterator iterator = differencesGraph.breadthFirstIterator();
            affectedDiffs = new ArrayList();
            while (iterator.hasNext()) {
                Diff next = (Diff)iterator.next();
                if (EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)next)) {
                    iterator.prune();
                    continue;
                }
                if (next.getState() == DifferenceState.MERGED) continue;
                affectedDiffs.add(next);
                IMerger merger = mergerRegistry.getHighestRankingMerger(next);
                if (leftToRight) {
                    merger.copyLeftToRight(next, (Monitor)emfMonitor);
                    continue;
                }
                merger.copyRightToLeft(next, (Monitor)emfMonitor);
            }
        } else {
            BatchMerger merger = new BatchMerger(mergerRegistry);
            boolean threeWay = comparison.isThreeWay();
            if (threeWay && leftToRight) {
                affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
                merger.copyAllLeftToRight((Iterable)affectedDiffs, (Monitor)emfMonitor);
            } else if (threeWay) {
                affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
                merger.copyAllRightToLeft((Iterable)affectedDiffs, (Monitor)emfMonitor);
            } else if (leftToRight) {
                affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
                merger.copyAllLeftToRight((Iterable)affectedDiffs, (Monitor)emfMonitor);
            } else {
                affectedDiffs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
                merger.copyAllRightToLeft((Iterable)affectedDiffs, (Monitor)emfMonitor);
            }
        }
        this.addOrUpdateMergeData(affectedDiffs, this.getMergeMode());
        return affectedDiffs;
    }

    private static boolean hasRealConflict(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (conflict.getKind() != ConflictKind.REAL) continue;
            return true;
        }
        return false;
    }
}

