/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.ForwardingObject;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.graphics.Image;

public class CompareInputWrapper
extends ForwardingObject
implements ICompareInput {
    private final ListenerList listeners = new ListenerList(1);
    private final ICompareInput fDelegate;

    public final ICompareInput delegate() {
        return this.fDelegate;
    }

    CompareInputWrapper(ICompareInput delegate) {
        this.fDelegate = delegate;
        this.fDelegate.addCompareInputChangeListener(new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                CompareInputWrapper.this.fireChange();
            }
        });
    }

    public String getName() {
        return this.delegate().getName();
    }

    public Image getImage() {
        return this.delegate().getImage();
    }

    public int getKind() {
        return this.delegate().getKind();
    }

    public ITypedElement getAncestor() {
        ITypedElement typedElement = this.delegate().getAncestor();
        if (typedElement != null) {
            return new TypedElementWrapper(typedElement);
        }
        return null;
    }

    public ITypedElement getLeft() {
        ITypedElement typedElement = this.delegate().getLeft();
        if (typedElement != null) {
            return new TypedElementWrapper(typedElement);
        }
        return null;
    }

    public ITypedElement getRight() {
        ITypedElement typedElement = this.delegate().getRight();
        if (typedElement != null) {
            return new TypedElementWrapper(typedElement);
        }
        return null;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireChange() {
        if (!this.listeners.isEmpty()) {
            Object[] allListeners = this.listeners.getListeners();
            int i = 0;
            while (i < allListeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)allListeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)CompareInputWrapper.this);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    public void copy(boolean leftToRight) {
        this.delegate().copy(leftToRight);
    }

    public static class TypedElementWrapper
    extends ForwardingObject
    implements ITypedElement {
        private final ITypedElement delegate;

        public TypedElementWrapper(ITypedElement delegate) {
            this.delegate = delegate;
        }

        public String getName() {
            return "__" + this.delegate().getName() + "__";
        }

        public Image getImage() {
            return this.delegate().getImage();
        }

        public String getType() {
            return "org.eclipse.emf.compare.rcp.ui.fallbackText";
        }

        protected ITypedElement delegate() {
            return this.delegate;
        }
    }
}

