/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KindGroupProvider
extends AbstractDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;
    private ImmutableList<IDifferenceGroup> differenceGroups;
    private Comparison comp;

    @Override
    public Collection<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        if (this.differenceGroups == null || !comparison.equals(this.comp)) {
            this.dispose();
            this.comp = comparison;
            BasicDifferenceGroupImpl additions = new BasicDifferenceGroupImpl(comparison, this, (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), "Additions", this.getCrossReferenceAdapter());
            BasicDifferenceGroupImpl deletions = new BasicDifferenceGroupImpl(comparison, this, (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), "Deletions", this.getCrossReferenceAdapter());
            BasicDifferenceGroupImpl changes = new BasicDifferenceGroupImpl(comparison, this, (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), "Changes", this.getCrossReferenceAdapter());
            BasicDifferenceGroupImpl moves = new BasicDifferenceGroupImpl(comparison, this, (Predicate<? super Diff>)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), "Moves", this.getCrossReferenceAdapter());
            ArrayList groups = Lists.newArrayList();
            if (!additions.getChildren().isEmpty()) {
                groups.add(additions);
            }
            if (!deletions.getChildren().isEmpty()) {
                groups.add(deletions);
            }
            if (!changes.getChildren().isEmpty()) {
                groups.add(changes);
            }
            if (!moves.getChildren().isEmpty()) {
                groups.add(moves);
            }
            this.differenceGroups = ImmutableList.copyOf((Collection)groups);
        }
        return this.differenceGroups;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return true;
    }

    @Override
    public void dispose() {
        this.comp = null;
        if (this.differenceGroups != null) {
            for (IDifferenceGroup group : this.differenceGroups) {
                group.dispose();
            }
            this.differenceGroups = null;
        }
    }
}

