/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DifferenceSource implements Enumerator
{
    LEFT(0, "LEFT", "LEFT"),
    RIGHT(1, "RIGHT", "RIGHT");

    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";
    public static final int LEFT_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    private static final DifferenceSource[] VALUES_ARRAY;
    public static final List<DifferenceSource> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DifferenceSource[]{LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DifferenceSource get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceSource result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceSource getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DifferenceSource result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DifferenceSource get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return RIGHT;
            }
        }
        return null;
    }

    private DifferenceSource(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

