/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.policy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadOnDemandPolicyRegistryImpl
implements ILoadOnDemandPolicy.Registry {
    private final Map<String, ILoadOnDemandPolicy> map = new ConcurrentHashMap<String, ILoadOnDemandPolicy>();

    @Override
    public boolean hasAnyAuthorizingPolicy(URI uri) {
        for (ILoadOnDemandPolicy policy : this.getPolicies()) {
            if (!policy.isAuthorizing(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ILoadOnDemandPolicy> getPolicies() {
        return Lists.newArrayList(this.map.values());
    }

    @Override
    public ILoadOnDemandPolicy addPolicy(ILoadOnDemandPolicy policy) {
        return this.map.put(policy.getClass().getName(), policy);
    }

    @Override
    public ILoadOnDemandPolicy removePolicy(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

