/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import java.util.Collection;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.extensions.NodeChange;
import org.eclipse.emf.compare.diagram.internal.factories.AbstractDiagramChangeFactory;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChangeFactory
extends AbstractDiagramChangeFactory {
    public Class<? extends Diff> getExtensionKind() {
        return NodeChange.class;
    }

    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createNodeChange();
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        extension.getRefinedBy().add((Object)refiningDiff);
        if (extensionKind != DifferenceKind.MOVE && refiningDiff instanceof ReferenceChange) {
            extension.getRefinedBy().addAll((Collection)this.getAllContainedDifferences((ReferenceChange)refiningDiff));
        }
    }

    protected Collection<Diff> getAllDifferencesForChange(Diff input) {
        return input.getMatch().getDifferences();
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToAnAddNode(input);
    }

    protected static boolean isRelatedToAnAddNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.ADD;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToADeleteNode(input);
    }

    protected static boolean isRelatedToADeleteNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.DELETE;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return this.isExclusive() && NodeChangeFactory.isRelatedToAMoveNode(input);
    }

    protected static boolean isRelatedToAMoveNode(ReferenceChange input) {
        return NodeChangeFactory.isContainmentOnSemanticNode(input) && input.getKind() == DifferenceKind.MOVE;
    }

    protected boolean isExclusive() {
        return this.getExtensionKind() == NodeChange.class;
    }

    private static boolean isContainmentOnSemanticNode(ReferenceChange input) {
        return input.getReference().isContainment() && input.getValue() instanceof Node && ReferenceUtil.safeEGet((EObject)input.getValue(), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }
}

