/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.IResourceContentsAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.InsertionPoint;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MatchedObject;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContentsAccessorImpl
implements IResourceContentsAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final ImmutableList<Diff> fDifferences;

    public ResourceContentsAccessorImpl(Diff diff, IMergeViewer.MergeViewerSide side) {
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
        this.fDifferences = this.computeDifferences();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        IMergeViewerItem ret = null;
        ImmutableList<? extends IMergeViewerItem> items = this.getItems();
        for (IMergeViewerItem item : items) {
            Diff diff = item.getDiff();
            if (diff != this.fDiff) continue;
            ret = item;
        }
        return ret;
    }

    @Override
    public Resource getResource(IMergeViewer.MergeViewerSide side) {
        Resource resource = null;
        EList matchResources = this.fOwnerMatch.getComparison().getMatchedResources();
        String diffResourceURI = ((ResourceAttachmentChange)this.fDiff).getResourceURI();
        for (MatchResource matchResource : matchResources) {
            URI resourceURI;
            switch (side) {
                case ANCESTOR: {
                    resource = matchResource.getOrigin();
                    break;
                }
                case LEFT: {
                    resource = matchResource.getLeft();
                    break;
                }
                case RIGHT: {
                    resource = matchResource.getRight();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (resource == null || !diffResourceURI.equals((resourceURI = resource.getURI()).toString())) continue;
            return resource;
        }
        return resource;
    }

    public List<EObject> getResourceContents(IMergeViewer.MergeViewerSide side) {
        Resource resource = this.getResource(side);
        if (resource != null) {
            return resource.getContents();
        }
        return Collections.emptyList();
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected final ImmutableList<Diff> getDifferences() {
        return this.fDifferences;
    }

    protected ImmutableList<Diff> computeDifferences() {
        Iterable concat = Iterables.concat(this.getResourceContents(IMergeViewer.MergeViewerSide.LEFT), this.getResourceContents(IMergeViewer.MergeViewerSide.RIGHT), this.getResourceContents(IMergeViewer.MergeViewerSide.ANCESTOR));
        final Comparison comparison = this.fOwnerMatch.getComparison();
        Iterable matches = Iterables.transform((Iterable)concat, (Function)new Function<EObject, Match>(){

            public Match apply(EObject eObject) {
                return comparison.getMatch(eObject);
            }
        });
        Iterable siblingDifferences = Iterables.concat((Iterable)Iterables.transform((Iterable)matches, (Function)new Function<Match, List<Diff>>(){

            public List<Diff> apply(Match match) {
                return match.getDifferences();
            }
        }));
        Predicate diffFilter = Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, (Predicate)diffFilter)).asList();
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        List<EObject> list = this.getResourceContents(this.getSide());
        List<? extends IMergeViewerItem> ret = this.createMergeViewerItemFrom(list);
        if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
            ret = this.createInsertionPoints(ret);
        }
        return ImmutableList.copyOf(ret);
    }

    private List<? extends IMergeViewerItem> createMergeViewerItemFrom(List<?> values) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            IMergeViewerItem valueToAdd = this.createMergeViewerItemFrom(value);
            ret.add(valueToAdd);
        }
        return ret;
    }

    private IMergeViewerItem createMergeViewerItemFrom(Object object) {
        Diff diff = this.getDiffWithValue(object);
        Object left = this.matchingValue(object, IMergeViewer.MergeViewerSide.LEFT);
        Object right = this.matchingValue(object, IMergeViewer.MergeViewerSide.RIGHT);
        Object ancestor = this.matchingValue(object, IMergeViewer.MergeViewerSide.ANCESTOR);
        return new MatchedObject(diff, left, right, ancestor);
    }

    private List<? extends IMergeViewerItem> createInsertionPoints(List<? extends IMergeViewerItem> values) {
        ArrayList ret = Lists.newArrayList(values);
        for (Diff diff : this.getDifferences().reverse()) {
            boolean rightEmptyBox;
            boolean rightToLeft = this.getSide() == IMergeViewer.MergeViewerSide.LEFT;
            Object left = this.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.LEFT);
            Object right = this.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.RIGHT);
            if (left == null && right == null) continue;
            boolean leftEmptyBox = this.getSide() == IMergeViewer.MergeViewerSide.LEFT && (left == null || !this.getResourceContents(this.getSide()).contains(left));
            boolean bl = rightEmptyBox = this.getSide() == IMergeViewer.MergeViewerSide.RIGHT && (right == null || !this.getResourceContents(this.getSide()).contains(right));
            if (!leftEmptyBox && !rightEmptyBox) continue;
            Object ancestor = this.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.ANCESTOR);
            InsertionPoint insertionPoint = new InsertionPoint(diff, left, right, ancestor);
            int insertionIndex = Math.min(this.findInsertionIndex(diff, rightToLeft), ret.size());
            List subList = ret.subList(0, insertionIndex);
            int nbInsertionPointBefore = Iterables.size((Iterable)Iterables.filter(subList, InsertionPoint.class));
            int index = Math.min(insertionIndex + nbInsertionPointBefore, ret.size());
            ret.add(index, insertionPoint);
        }
        return ret;
    }

    protected int findInsertionIndex(Diff diff, boolean rightToLeft) {
        Resource expectedResource;
        Resource initialResource;
        Match valueMatch = diff.getMatch();
        Comparison comparison = valueMatch.getComparison();
        EObject expectedValue = valueMatch.getLeft() != null ? valueMatch.getLeft() : valueMatch.getRight();
        if (rightToLeft) {
            initialResource = this.getResource(IMergeViewer.MergeViewerSide.RIGHT);
            expectedResource = this.getResource(IMergeViewer.MergeViewerSide.LEFT);
        } else {
            initialResource = this.getResource(IMergeViewer.MergeViewerSide.LEFT);
            expectedResource = this.getResource(IMergeViewer.MergeViewerSide.RIGHT);
        }
        if (expectedResource != null) {
            EList sourceList = initialResource.getContents();
            EList targetList = expectedResource.getContents();
            return DiffUtil.findInsertionIndex((Comparison)comparison, (List)sourceList, (List)targetList, (Object)expectedValue);
        }
        return 0;
    }

    private Diff getDiffWithValue(Object value) {
        Diff ret = null;
        for (Diff diff : this.getDifferences()) {
            Object valueOfDiff = this.getValueFromDiff(diff, this.getSide());
            if (valueOfDiff != value) continue;
            ret = diff;
            break;
        }
        return ret;
    }

    protected Object getValueFromDiff(Diff diff, IMergeViewer.MergeViewerSide side) {
        Object diffValue = this.getDiffValue(diff, side);
        Object ret = this.matchingValue(diffValue, side);
        return ret;
    }

    private Object matchingValue(Object object, IMergeViewer.MergeViewerSide side) {
        Object ret;
        block7: {
            block5: {
                block6: {
                    if (!(object instanceof EObject)) break block5;
                    Match matchOfValue = this.getComparison().getMatch((EObject)object);
                    if (matchOfValue == null) break block6;
                    switch (side) {
                        case ANCESTOR: {
                            ret = matchOfValue.getOrigin();
                            break block7;
                        }
                        case LEFT: {
                            ret = matchOfValue.getLeft();
                            break block7;
                        }
                        case RIGHT: {
                            ret = matchOfValue.getRight();
                            break block7;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                ret = this.matchingValue(object, this.getResourceContents(side));
                break block7;
            }
            ret = this.matchingValue(object, this.getResourceContents(side));
        }
        return ret;
    }

    private Object matchingValue(Object value, List<?> in) {
        Object ret = null;
        IEqualityHelper equalityHelper = this.getComparison().getEqualityHelper();
        Iterator<?> valuesIterator = in.iterator();
        while (valuesIterator.hasNext() && ret == null) {
            Object object = valuesIterator.next();
            if (!equalityHelper.matchingValues(object, value)) continue;
            ret = object;
        }
        return ret;
    }

    protected Object getDiffValue(Diff diff, IMergeViewer.MergeViewerSide side) {
        EObject ret;
        block10: {
            block9: {
                if (!(diff instanceof ResourceAttachmentChange)) break block9;
                Match match = ((ResourceAttachmentChange)diff).getMatch();
                switch (side) {
                    case ANCESTOR: {
                        switch (diff.getSource()) {
                            case LEFT: {
                                ret = match.getRight();
                                break block10;
                            }
                            case RIGHT: {
                                ret = match.getLeft();
                                break block10;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    case LEFT: {
                        ret = match.getLeft();
                        break block10;
                    }
                    case RIGHT: {
                        ret = match.getRight();
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            ret = null;
        }
        return ret;
    }

    @Override
    public String getName() {
        return ResourceContentsAccessorImpl.class.getName();
    }

    @Override
    public Image getImage() {
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EObject"));
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eResourceDiff";
    }
}

