/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.DiffSide;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.subscribers.Subscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class RevisionedURIConverter
extends StorageURIConverter {
    private Subscriber subscriber;
    private DiffSide side;

    public RevisionedURIConverter(URIConverter delegate, Subscriber subscriber, DiffSide side) {
        super(delegate);
        this.subscriber = subscriber;
        this.side = side;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = null;
        URI normalizedUri = this.normalize(uri);
        if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
            stream = super.createInputStream(normalizedUri, options);
        } else {
            IFile targetFile;
            if (normalizedUri.isPlatform()) {
                Path platformString = new Path(normalizedUri.trimFragment().toPlatformString(true));
                IFile temp = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
                targetFile = !temp.exists() && normalizedUri.isPlatformResource() && platformString.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile(platformString.removeFirstSegments(1)) : temp;
            } else {
                targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toString()));
            }
            if (targetFile != null) {
                stream = this.openRevisionStream((IResource)targetFile);
            }
            if (stream == null) {
                return super.createInputStream(uri, options);
            }
        }
        return stream;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        if (this.subscriber != null) {
            IDiff diff = null;
            try {
                diff = this.subscriber.getDiff(targetFile);
            }
            catch (CoreException e) {
                RevisionedURIConverter.logError((Exception)((Object)e));
            }
            IFileRevision revision = null;
            switch (this.side) {
                case LEFT: {
                    ITwoWayDiff change;
                    if (diff instanceof IThreeWayDiff) {
                        change = ((IThreeWayDiff)diff).getLocalChange();
                        if (!(change instanceof ResourceDiff)) break;
                        revision = ((ResourceDiff)change).getAfterState();
                        break;
                    }
                    if (!(diff instanceof ResourceDiff)) break;
                    revision = ((ResourceDiff)diff).getAfterState();
                    break;
                }
                case RIGHT: {
                    ITwoWayDiff change;
                    if (diff instanceof IThreeWayDiff) {
                        change = ((IThreeWayDiff)diff).getRemoteChange();
                        if (!(change instanceof ResourceDiff)) break;
                        revision = ((ResourceDiff)change).getAfterState();
                        break;
                    }
                    if (!(diff instanceof ResourceDiff)) break;
                    revision = ((ResourceDiff)diff).getBeforeState();
                    break;
                }
                case ORIGIN: {
                    ITwoWayDiff change;
                    if (!(diff instanceof IThreeWayDiff) || !((change = ((IThreeWayDiff)diff).getLocalChange()) instanceof ResourceDiff)) break;
                    revision = ((ResourceDiff)change).getBeforeState();
                    break;
                }
            }
            if (revision != null) {
                try {
                    IStorage storage = revision.getStorage((IProgressMonitor)new NullProgressMonitor());
                    this.getLoadedRevisions().add(storage);
                    return storage.getContents();
                }
                catch (CoreException e) {
                    RevisionedURIConverter.logError((Exception)((Object)e));
                }
            }
        }
        return null;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide.ui", e.getMessage(), (Throwable)e);
        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
    }
}

