/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.SyncResourceSet;
import org.eclipse.emf.compare.ide.ui.logical.DiffSide;
import org.eclipse.emf.compare.ide.ui.logical.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.subscribers.Subscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class EMFSynchronizationModel {
    private final StorageTraversal leftTraversal;
    private final StorageTraversal rightTraversal;
    private final StorageTraversal originTraversal;
    private final boolean leftEditable;
    private final boolean rightEditable;

    private EMFSynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal, boolean leftEditable, boolean rightEditable) {
        this.leftTraversal = leftTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : leftTraversal;
        this.rightTraversal = rightTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : rightTraversal;
        this.originTraversal = originTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : originTraversal;
        this.leftEditable = leftEditable;
        this.rightEditable = rightEditable;
    }

    public static EMFSynchronizationModel createSynchronizationModel(Subscriber subscriber, IResource left, IResource right, IResource origin) {
        boolean canEditLeft = left != null;
        boolean canEditRight = right != null;
        IFileRevision leftRevision = null;
        IFileRevision rightRevision = null;
        IFileRevision originRevision = null;
        if (subscriber != null && left != null) {
            try {
                IDiff diff = subscriber.getDiff(left);
                if (diff instanceof IThreeWayDiff) {
                    ITwoWayDiff localChange = ((IThreeWayDiff)diff).getLocalChange();
                    ITwoWayDiff remoteChange = ((IThreeWayDiff)diff).getRemoteChange();
                    if (localChange instanceof ResourceDiff) {
                        leftRevision = ((ResourceDiff)localChange).getAfterState();
                        originRevision = ((ResourceDiff)localChange).getBeforeState();
                    }
                    if (remoteChange instanceof ResourceDiff) {
                        rightRevision = ((ResourceDiff)remoteChange).getAfterState();
                    }
                } else if (diff instanceof ResourceDiff) {
                    leftRevision = ((ResourceDiff)diff).getAfterState();
                    rightRevision = ((ResourceDiff)diff).getBeforeState();
                }
            }
            catch (CoreException coreException) {}
        }
        StorageTraversal leftTraversal = leftRevision == null ? EMFSynchronizationModel.resolveTraversal(left) : EMFSynchronizationModel.resolveTraversal(subscriber, leftRevision, DiffSide.LEFT);
        StorageTraversal rightTraversal = rightRevision == null ? EMFSynchronizationModel.resolveTraversal(right) : EMFSynchronizationModel.resolveTraversal(subscriber, rightRevision, DiffSide.RIGHT);
        StorageTraversal originTraversal = originRevision == null ? EMFSynchronizationModel.resolveTraversal(origin) : EMFSynchronizationModel.resolveTraversal(subscriber, originRevision, DiffSide.ORIGIN);
        return new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal, canEditLeft, canEditRight);
    }

    public static EMFSynchronizationModel createSynchronizationModel(Subscriber subscriber, ITypedElement left, ITypedElement right, ITypedElement origin) {
        IResource leftResource = EMFSynchronizationModel.findResource(left);
        IResource rightResource = EMFSynchronizationModel.findResource(right);
        IResource originResource = EMFSynchronizationModel.findResource(origin);
        return EMFSynchronizationModel.createSynchronizationModel(subscriber, leftResource, rightResource, originResource);
    }

    public IComparisonScope createMinimizedScope() {
        this.minimize();
        NotLoadingResourceSet leftResourceSet = new NotLoadingResourceSet(this.leftTraversal);
        NotLoadingResourceSet rightResourceSet = new NotLoadingResourceSet(this.rightTraversal);
        NotLoadingResourceSet originResourceSet = this.originTraversal == null || this.originTraversal.getStorages().isEmpty() ? null : new NotLoadingResourceSet(this.originTraversal);
        LinkedHashSet urisInScope = Sets.newLinkedHashSet();
        for (IStorage left : this.leftTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)left));
        }
        for (IStorage right : this.rightTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)right));
        }
        for (IStorage origin : this.originTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)origin));
        }
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
        scope.setResourceSetContentFilter(EMFSynchronizationModel.isInScope(urisInScope));
        return scope;
    }

    public void minimize() {
        boolean threeWay = !this.originTraversal.getStorages().isEmpty();
        LinkedHashSet leftCopy = Sets.newLinkedHashSet((Iterable)this.leftTraversal.getStorages());
        LinkedHashSet rightCopy = Sets.newLinkedHashSet((Iterable)this.rightTraversal.getStorages());
        LinkedHashSet originCopy = Sets.newLinkedHashSet((Iterable)this.originTraversal.getStorages());
        for (IStorage left : leftCopy) {
            IStorage right = this.removeLikeNamedStorageFrom(left, rightCopy);
            if (right != null && threeWay) {
                IStorage origin = this.removeLikeNamedStorageFrom(left, originCopy);
                if (origin == null || !ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right, (IStorage)origin)) continue;
                this.leftTraversal.getStorages().remove(left);
                this.rightTraversal.getStorages().remove(right);
                this.originTraversal.getStorages().remove(origin);
                continue;
            }
            if (right != null && ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right)) {
                this.leftTraversal.getStorages().remove(left);
                this.rightTraversal.getStorages().remove(right);
                continue;
            }
            if (right != null || !left.isReadOnly()) continue;
            this.leftTraversal.getStorages().remove(left);
        }
        for (IStorage right : rightCopy) {
            if (!right.isReadOnly()) continue;
            this.rightTraversal.getStorages().remove(right);
        }
        for (IStorage origin : originCopy) {
            if (!origin.isReadOnly()) continue;
            this.originTraversal.getStorages().remove(origin);
        }
    }

    private IStorage removeLikeNamedStorageFrom(IStorage reference, Set<IStorage> candidates) {
        String referenceName = reference.getName();
        Iterator<IStorage> candidatesIterator = candidates.iterator();
        while (candidatesIterator.hasNext()) {
            IStorage candidate = candidatesIterator.next();
            String candidateName = candidate.getName();
            if (!referenceName.equals(candidateName)) continue;
            candidatesIterator.remove();
            return candidate;
        }
        return null;
    }

    public boolean isLeftEditable() {
        return this.leftEditable;
    }

    public boolean isRightEditable() {
        return this.rightEditable;
    }

    static StorageTraversal resolveTraversal(IResource start) {
        if (!(start instanceof IFile)) {
            return new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        StorageURIConverter converter = new StorageURIConverter(resourceSet.getURIConverter());
        resourceSet.setURIConverter((URIConverter)converter);
        if (resourceSet.resolveAll((IStorage)((IFile)start))) {
            LinkedHashSet storages = Sets.newLinkedHashSet((Iterable)Sets.union(Collections.singleton((IFile)start), (Set)converter.getLoadedRevisions()));
            return new StorageTraversal((Set)storages);
        }
        return new StorageTraversal(Collections.singleton((IFile)start));
    }

    private static StorageTraversal resolveTraversal(Subscriber subscriber, IFileRevision start, DiffSide side) {
        if (start == null) {
            return new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        StorageTraversal traversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        SyncResourceSet resourceSet = new SyncResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), subscriber, side);
        resourceSet.setURIConverter((URIConverter)converter);
        try {
            IStorage startStorage = start.getStorage((IProgressMonitor)new NullProgressMonitor());
            if (resourceSet.resolveAll(startStorage)) {
                LinkedHashSet storages = Sets.newLinkedHashSet();
                storages.add(startStorage);
                IPath startPath = startStorage.getFullPath();
                for (IStorage loaded : converter.getLoadedRevisions()) {
                    if (startPath.equals((Object)loaded.getFullPath())) continue;
                    storages.add(loaded);
                }
                traversal = new StorageTraversal((Set)storages);
            }
        }
        catch (CoreException coreException) {}
        return traversal;
    }

    private static IResource findResource(ITypedElement element) {
        if (element == null) {
            return null;
        }
        IResource resource = EMFSynchronizationModel.adaptAs(element, IResource.class);
        if (resource == null && element instanceof IResourceProvider) {
            resource = ((IResourceProvider)element).getResource();
        }
        return resource;
    }

    private static <T> T adaptAs(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        } else if (object instanceof IAdaptable) {
            result = ((IAdaptable)object).getAdapter(clazz);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, clazz);
        }
        return (T)result;
    }

    private static Predicate<Resource> isInScope(final Set<URI> uris) {
        return new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return input != null && uris.contains(input.getURI());
            }
        };
    }
}

