/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.sections;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.activities.ExplorerActivity;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.FormHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.HTMLHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.Couple;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IOrdered;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IVisibility;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ActivityExplorerSection
implements IVisibility,
IOrdered,
IPropertyChangeListener {
    private static final Pattern P_PATTERN = Pattern.compile("<p>.*</p>");
    private TreeSet<ExplorerActivity> activities;
    private String id;
    private String name;
    private int index;
    private boolean isExpanded;
    private boolean isFiltering;
    private String description;
    private IAction[] toolbarActions;
    private Section widget;
    private FormToolkit toolkit;
    private Composite activityContainer;
    private IFormPage page;

    public ActivityExplorerSection(IConfigurationElement contributor) {
        this.id = ActivityExplorerExtensionManager.getId(contributor);
        this.name = ActivityExplorerExtensionManager.getName(contributor);
        this.isExpanded = ActivityExplorerExtensionManager.getIsExpanded(contributor);
        String desc = ActivityExplorerExtensionManager.getDescription(contributor);
        if (desc != null) {
            boolean isInParagraph = P_PATTERN.matcher(desc).find();
            this.description = isInParagraph ? HTMLHelper.formWrapper2(desc) : HTMLHelper.formWrapper(desc);
        }
        String indice = ActivityExplorerExtensionManager.getIndex(contributor);
        try {
            this.index = Integer.parseInt(indice);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(MessageFormat.format("Attribute ''{0}'' of section {1} must be an int, but was ''{2}''", "index", ActivityExplorerExtensionManager.getId(contributor), indice));
        }
        this.isFiltering = ActivityExplorerExtensionManager.getIsFiltering(contributor);
        this.createActivities(contributor);
    }

    public ActivityExplorerSection(String id, String name, int index, boolean isExpanded, boolean isFiltering, String description, List<ExplorerActivity> activities) {
        this.id = id;
        this.name = name;
        this.index = index;
        this.isExpanded = isExpanded;
        this.isFiltering = isFiltering;
        this.activities.addAll(activities);
    }

    private void createActivities(IConfigurationElement contributor) {
        this.activities = new TreeSet();
        List<IConfigurationElement> activities = ActivityExplorerExtensionManager.getActivities(contributor);
        for (IConfigurationElement element : activities) {
            try {
                this.activities.add(new ExplorerActivity(element));
            }
            catch (NumberFormatException e) {
                StringBuilder message = new StringBuilder();
                message.append("ActivityExplorerSection.createActivities(...) _ ");
                message.append("The Activity contribution ");
                message.append(ActivityExplorerExtensionManager.getId(contributor));
                message.append(" has wrong index format (");
                message.append(ActivityExplorerExtensionManager.getIndex(contributor));
                message.append("). Only integers are valid");
                ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
            }
        }
    }

    public Set<ExplorerActivity> getActivities() {
        return this.activities;
    }

    public ExplorerActivity getActivityById(String id) {
        ExplorerActivity result = null;
        for (ExplorerActivity activity : this.getActivities()) {
            if (!activity.getId().equals(id)) continue;
            result = activity;
        }
        return result;
    }

    public void setActivities(TreeSet<ExplorerActivity> activities) {
        this.activities = activities;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isFiltering() {
        return this.isFiltering;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isVisible() {
        return ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean(this.getId()) && !this.getVisibleActivities().isEmpty();
    }

    @Override
    public int getPosition() {
        return this.index;
    }

    @Override
    public void setPosition(int index) {
        this.index = index;
    }

    public Control init(Composite sectionContainer, IFormPage page, IManagedForm managedForm) {
        this.page = page;
        this.toolkit = managedForm.getToolkit();
        Couple<Section, Composite> section = FormHelper.createTwistieSectionWithToolbar(sectionContainer, managedForm, this.getName(), null, this.isExpanded, Arrays.asList(this.getToolBarActions()));
        this.widget = section.getKey();
        this.activityContainer = section.getValue();
        ActivityExplorerActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        return this.widget;
    }

    public Control initialize(Composite sectionContainer, IFormPage page, IManagedForm managedForm) {
        this.init(sectionContainer, page, managedForm);
        this.initOwnActivities(this.activityContainer, this.toolkit);
        return this.widget;
    }

    public Section getWidget() {
        return this.widget;
    }

    public List<ExplorerActivity> getVisibleActivities() {
        ArrayList<ExplorerActivity> visibleActivities = new ArrayList<ExplorerActivity>();
        for (ExplorerActivity activity : this.getActivities()) {
            if (!activity.isVisible()) continue;
            visibleActivities.add(activity);
        }
        return visibleActivities;
    }

    private void initOwnActivities(Composite activityContainer, FormToolkit toolkit) {
        for (ExplorerActivity activity : this.getVisibleActivities()) {
            activity.init(activityContainer, toolkit);
        }
    }

    protected IAction[] getToolBarActions() {
        return this.toolbarActions;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean value = Boolean.valueOf(event.getNewValue().toString());
        if (this.doPropertyChange(event, value, property) && ActivityExplorerManager.INSTANCE.getEditor() != null && ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance() != null) {
            ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance().getManagedForm().reflow(true);
        }
    }

    protected boolean doPropertyChange(PropertyChangeEvent event, boolean value, String property) {
        boolean result = false;
        if (this.isActivity(property)) {
            this.updateSectionForm();
            result = true;
        }
        return result;
    }

    private boolean isActivity(String id) {
        return ActivityExplorerExtensionManager.isActivity(this.page.getId(), this.getId(), id);
    }

    public void dispose() {
        if (this.widget != null && !this.widget.isDisposed()) {
            this.widget.dispose();
        }
        ActivityExplorerManager.INSTANCE.getEditor().dispose();
        ActivityExplorerActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public int compareTo(IOrdered arg0) {
        int value = new Integer(this.getPosition()).compareTo(new Integer(arg0.getPosition()));
        return value == 0 ? 1 : value;
    }

    public void updateSectionForm() {
        if (!this.activityContainer.isDisposed()) {
            Control[] controlArray = this.activityContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.initOwnActivities(this.activityContainer, this.toolkit);
        }
    }
}

