/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.view.focus;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.core.ext.AbstractExtensionPointManager;
import org.eclipse.amalgam.explorer.contextual.view.focus.IFocusInEditor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class FocusInEditorExtensionsManager
extends AbstractExtensionPointManager {
    private static final String _FOCUSMANAGER_EXTPOINT_ID = "FocusInEditor";
    private static List<IFocusInEditor> _focusRegistry;
    private static FocusInEditorExtensionsManager _instance;

    static {
        _instance = null;
    }

    public static FocusInEditorExtensionsManager getInstance() {
        if (_instance == null) {
            _instance = new FocusInEditorExtensionsManager();
        }
        return _instance;
    }

    protected FocusInEditorExtensionsManager() {
        _focusRegistry = new ArrayList<IFocusInEditor>();
        this.initRegistry();
    }

    public boolean accept(IEditorPart activeEditor_p, ISelection selection_p) {
        for (IFocusInEditor iFocusInEditor : _focusRegistry) {
            boolean accept = iFocusInEditor.accept(activeEditor_p, selection_p);
            if (!accept) continue;
            return true;
        }
        return false;
    }

    public boolean doFocus(IEditorPart activeEditor_p, ISelection selection_p) {
        for (IFocusInEditor iFocusInEditor : _focusRegistry) {
            boolean accept = iFocusInEditor.accept(activeEditor_p, selection_p);
            if (!accept) continue;
            return iFocusInEditor.focusInEditor(activeEditor_p, selection_p);
        }
        return false;
    }

    private void initRegistry() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = FocusInEditorExtensionsManager.getConfigurationElementsFor((String)"org.eclipse.amalgam.explorer.contextual.ui", (String)_FOCUSMANAGER_EXTPOINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConElement = iConfigurationElementArray[n2];
            IFocusInEditor focusManager = (IFocusInEditor)FocusInEditorExtensionsManager.createTypedInstance((IConfigurationElement)iConElement, (String)"class", IFocusInEditor.class);
            if (focusManager != null) {
                _focusRegistry.add(focusManager);
            }
            ++n2;
        }
    }
}

