/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineContentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineInput;
import org.eclipse.ocl.cst.CSTNode;

public class QvtOutlineNodeSelector {
    private final TreeViewer myViewer;
    private final QvtOutlineContentProvider myContentProvider;

    public QvtOutlineNodeSelector(TreeViewer viewer) {
        this.myViewer = viewer;
        this.myContentProvider = (QvtOutlineContentProvider)this.myViewer.getContentProvider();
    }

    public void selectCorrespondingNode(TextSelection selection) {
        OutlineNode nodeToSelect = null;
        Object[] roots = ((QvtOutlineInput)this.myViewer.getInput()).getChildren();
        int i = 0;
        while (i < roots.length) {
            nodeToSelect = this.findCorrespondingNode((OutlineNode)roots[i], selection);
            if (nodeToSelect != null) break;
            ++i;
        }
        this.select(nodeToSelect);
    }

    private void select(OutlineNode node) {
        IStructuredSelection ss;
        List elements;
        ISelection currentSelection = this.myViewer.getSelection();
        if (currentSelection instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)currentSelection).toList()).contains(node) && node != null) {
            this.myViewer.setSelection((ISelection)new StructuredSelection((Object)node), false);
        }
    }

    private OutlineNode findCorrespondingNode(OutlineNode root, TextSelection selection) {
        Object[] children = this.myContentProvider.getChildren(root);
        int i = 0;
        while (i < children.length) {
            OutlineNode subResult;
            OutlineNode node = (OutlineNode)children[i];
            CSTNode elem = node.getSyntaxElement();
            if (elem != null) {
                CSTNode pos = (CSTNode)EcoreUtil.create((EClass)elem.eClass());
                pos.setStartOffset(elem.getStartOffset());
                pos.setEndOffset(elem.getEndOffset());
                if (this.isInside(selection, pos)) {
                    return node;
                }
            }
            if ((subResult = this.findCorrespondingNode(node, selection)) != null) {
                return subResult;
            }
            ++i;
        }
        return null;
    }

    private boolean isInside(TextSelection selection, CSTNode elementPositions) {
        return elementPositions.getStartOffset() <= selection.getOffset() && elementPositions.getStartOffset() + elementPositions.getEndOffset() >= selection.getOffset();
    }
}

