/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.common.ATLLaunchConstants;
import org.eclipse.m2m.atl.dsls.core.EMFTCSInjector;
import org.eclipse.m2m.atl.emftvm.compiler.AtlResourceFactoryImpl;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFolder;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.atl.atl2qvtr.ATL2QVTr;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.compiler.internal.common.DefaultConfigurations;
import org.eclipse.qvtd.compiler.internal.common.TargetConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ConnectivityChecker;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationToStringVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.pivot.qvttemplate.QVTtemplatePackage;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtrelation.tests.Families2PersonsNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.FlatStateMachineNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.Forward2ReverseNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.NamesNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.QVTrNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.QVTrelationTestFileSystemHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QVTrCompilerTests
extends LoadTestCase {
    public static final boolean ENABLE_ATL2QVTr_CG_exec = false;
    public static final boolean ENABLE_ATL2QVTr_reverse_CG = false;
    private static boolean NO_MERGES = true;
    public QVTrelationTestFileSystemHelper testFileSystemHelper = null;

    protected @NonNull OCLInternal createOCL() {
        return QVTrelation.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
    }

    protected @NonNull QVTrelationTestFileSystemHelper getTestFileSystemHelper() {
        QVTrelationTestFileSystemHelper testFileSystemHelper2 = this.testFileSystemHelper;
        if (testFileSystemHelper2 == null) {
            this.testFileSystemHelper = testFileSystemHelper2 = new QVTrelationTestFileSystemHelper();
        }
        return testFileSystemHelper2;
    }

    @Before
    public void setUp() throws Exception {
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        super.setUp();
        OCLstdlib.install();
        XtextCompilerUtil.doQVTrelationSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
        ConnectivityChecker.CONNECTIVITY.setState(true);
    }

    @After
    public void tearDown() throws Exception {
        ConnectivityChecker.CONNECTIVITY.setState(false);
        super.tearDown();
    }

    @Test
    public void testQVTrCompiler_ATL2QVTr_CG() throws Exception {
        Class txClass3;
        QVTrelationTestFileSystemHelper testFileSystemHelper = this.getTestFileSystemHelper();
        testFileSystemHelper.addRequiredBundle("org.eclipse.qvtd.atl");
        testFileSystemHelper.addExportedPackage("org.eclipse.qvtd.xtext.qvtrelation.tests.newatl2qvtr");
        Class txClass1 = null;
        URI txURI1 = this.getModelsURI("newATL2QVTr/NewATL2QVTr.qvtr");
        MyQVT myQVT1 = this.createQVT("NewATL2QVTr", txURI1);
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//ATL");
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//OCL");
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//PrimitiveTypes");
        myQVT1.addUsedGenPackage("org.eclipse.ocl.pivot/model/Pivot.genmodel", "//pivot");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvtbase/model/QVTbase.genmodel", "//qvtbase");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvtrelation/model/QVTrelation.genmodel", "//qvtrelation");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvttemplate/model/QVTtemplate.genmodel", "//qvttemplate");
        JavaClasspath classpath1 = myQVT1.getClasspath();
        classpath1.addClass(ATLLaunchConstants.class);
        classpath1.addClass(BaseModel.class);
        classpath1.addClass(RelationModel.class);
        classpath1.addClass(TemplateExp.class);
        classpath1.addClass(ATL2QVTr.class);
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            assert (classLoader != null);
            ((PivotMetamodelManager)myQVT1.getMetamodelManager()).getImplementationManager().getClassLoaders().add(classLoader);
            txClass1 = myQVT1.buildTransformation("qvtr", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        URI txURI2 = this.getTestURI("Families2Persons_CG.qvtras");
        MyQVT myQVT2 = this.createQVT("ATL2QVTr", txURI1);
        try {
            myQVT2.createGeneratedExecutor(txClass1);
            EMFTCSInjector.class.getName();
            AtlParser.class.getName();
            myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("atl", new AtlResourceFactoryImpl());
            myQVT2.addInputURI("atl", this.getModelsURI("families2persons/Families2Persons.atl"));
            ToStringVisitor.addFactory((ToStringVisitor.Factory)new PivotQVTrelationToStringFactory());
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("qvtr", txURI2);
            myQVT2.saveModels(null);
            myQVT2.checkOutput(txURI2, this.getModelsURI("families2persons/Families2Persons_expected.qvtras"), QVTrNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT3 = this.createQVT("Families2Persons", txURI2);
        myQVT3.setKeepOldJavaFiles();
        JavaClasspath classpath3 = myQVT3.getClasspath();
        classpath3.addClass(ATLLaunchConstants.class);
        classpath3.addClass(BaseModel.class);
        classpath3.addClass(RelationModel.class);
        classpath3.addClass(TemplateExp.class);
        classpath3.addClass(ATL2QVTr.class);
        try {
            txClass3 = myQVT3.buildTransformation("Persons", false, new String[0]);
            myQVT3.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT3.dispose();
            myQVT3 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT4 = this.createQVT("Families2Persons", txURI2);
        try {
            myQVT4.loadEPackage(txClass3, "Families.FamiliesPackage");
            myQVT4.loadEPackage(txClass3, "Persons.PersonsPackage");
            myQVT4.loadEPackage(txClass3, "trace_Families2Persons.trace_Families2PersonsPackage");
            myQVT4.createGeneratedExecutor(txClass3);
            myQVT4.addInputURI("Families", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT4.executeTransformation();
            myQVT4.addOutputURI("Persons", this.getTestURI("Persons_CG.xmi"));
            myQVT4.saveModels(null);
            myQVT4.checkOutput(this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        catch (Throwable throwable) {
            myQVT4.dispose();
            myQVT4 = null;
            QVTrCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvtd-example/org/eclipse/qvtd/xtext/qvtrelation/tests/newatl2qvtr/NewATL2QVTr"});
            throw throwable;
        }
        myQVT4.dispose();
        myQVT4 = null;
        QVTrCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvtd-example/org/eclipse/qvtd/xtext/qvtrelation/tests/newatl2qvtr/NewATL2QVTr"});
    }

    @Test
    public void testQVTrCompiler_ATL2QVTr_reverse_CG() throws Exception {
    }

    @Test
    public void testQVTrCompiler_ATL2QVTr_CG_exec() throws Exception {
    }

    @Test
    public void testQVTrCompiler_Ecore2Pivot() throws Exception {
    }

    @Test
    public void testQVTrCompiler_Ecore2Pivot_CG() throws Exception {
    }

    @Test
    public void testQVTrCompiler_Ecore2PivotRoot() throws Exception {
        URI ecoreURI = this.getModelsURI("ecore2pivotRoot/Families.ecore");
        URI asURI2a = this.getTestURI("Families2.ecore.oclas");
        ProjectManager testProjectManager = this.getTestProjectManager();
        OCL ocl = OCL.newInstance((ProjectManager)testProjectManager);
        try {
            Resource inputResource = ocl.getResourceSet().getResource(ecoreURI, true);
            assert (inputResource != null);
            QVTrCompilerTests.assertNoResourceErrors((String)"Ecore load", (Resource)inputResource);
            QVTrCompilerTests.assertNoValidationErrors((String)"Ecore load", (Resource)inputResource);
            Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()));
            Model pivotModel = ecore2as.getASModel();
            ASResource asResource = (ASResource)pivotModel.eResource();
            asResource.setURI(asURI2a);
            asResource.setSaveable(true);
            QVTrCompilerTests.assertNoResourceErrors((String)"Ecore2AS failed", (Resource)asResource);
            asResource.save(XMIUtil.createSaveOptions());
            QVTrCompilerTests.assertValidationDiagnostics((String)"Ecore2AS invalid", (Resource)asResource, (String[])NO_MESSAGES);
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
        MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("ecore2pivotRoot/Ecore2PivotRoot.qvtr"));
        URI asURI2 = this.getTestURI("Families.ecore.oclas");
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("as");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.addInputURI("ecore", ecoreURI);
            myQVT.executeTransformation();
            myQVT.addOutputURI("as", asURI2);
            myQVT.saveModels(null);
            myQVT.checkOutput(asURI2, asURI2a, DummyPivotExternalURINormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
            myQVT = null;
        }
    }

    @Test
    public void testQVTrCompiler_Ecore2PivotRoot_CG() throws Exception {
        QVTrelationTestFileSystemHelper testFileSystemHelper = this.getTestFileSystemHelper();
        testFileSystemHelper.addRequiredBundle("org.eclipse.qvtd.pivot.qvtbase");
        Class txClass1 = null;
        URI txURI1 = this.getModelsURI("ecore2pivotRoot/Ecore2PivotRoot.qvtr");
        MyQVT myQVT1 = this.createQVT("Ecore2PivotRoot", txURI1);
        myQVT1.configureGeneratedPackage("http://www.eclipse.org/emf/2002/Ecore");
        myQVT1.configureGeneratedPackage("http://www.eclipse.org/ocl/2015/Pivot");
        myQVT1.configureGeneratedPackage("http://www.eclipse.org/ocl/2015/Library");
        myQVT1.addUsedGenPackage("org.eclipse.emf.ecore/model/Ecore.genmodel", "//ecore");
        myQVT1.addUsedGenPackage("org.eclipse.ocl.pivot/model/Pivot.genmodel", "//pivot");
        ProjectManager projectManager = myQVT1.getProjectManager();
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            assert (classLoader != null);
            ((PivotMetamodelManager)myQVT1.getMetamodelManager()).getImplementationManager().getClassLoaders().add(classLoader);
            txClass1 = myQVT1.buildTransformation("as", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        URI asURI2a = this.getTestURI("Families2.ecore.oclas");
        URI ecoreURI = this.getModelsURI("ecore2pivotRoot/Families.ecore");
        OCL ocl = OCL.newInstance((ProjectManager)projectManager);
        try {
            Resource inputResource = ocl.getResourceSet().getResource(ecoreURI, true);
            assert (inputResource != null);
            QVTrCompilerTests.assertNoResourceErrors((String)"Ecore load", (Resource)inputResource);
            QVTrCompilerTests.assertNoValidationErrors((String)"Ecore load", (Resource)inputResource);
            Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()));
            Model pivotModel = ecore2as.getASModel();
            ASResource asResource = (ASResource)pivotModel.eResource();
            asResource.setURI(asURI2a);
            asResource.setSaveable(true);
            QVTrCompilerTests.assertNoResourceErrors((String)"Ecore2AS failed", (Resource)asResource);
            asResource.save(XMIUtil.createSaveOptions());
            QVTrCompilerTests.assertValidationDiagnostics((String)"Ecore2AS invalid", (Resource)asResource, (String[])NO_MESSAGES);
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
        ThreadLocalExecutor.waitForGC();
        URI asURI2 = this.getTestURI("Families.ecore.oclas");
        MyQVT myQVT2 = this.createQVT("Ecore2PivotRoot", txURI1);
        try {
            myQVT2.createGeneratedExecutor(txClass1);
            myQVT2.addInputURI("ecore", ecoreURI);
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("as", asURI2);
            myQVT2.saveModels(null);
            myQVT2.checkOutput(asURI2, asURI2a, DummyPivotExternalURINormalizer.INSTANCE);
        }
        catch (Throwable throwable) {
            myQVT2.dispose();
            myQVT2 = null;
            QVTrCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvtd-example/org/eclipse/ocl/pivot2/ecore2pivotRoot/Ecore2PivotRoot"});
            throw throwable;
        }
        myQVT2.dispose();
        myQVT2 = null;
        QVTrCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvtd-example/org/eclipse/ocl/pivot2/ecore2pivotRoot/Ecore2PivotRoot"});
    }

    @Test
    public void testQVTrCompiler_Families2Persons_CG() throws Exception {
        Class txClass;
        ConnectivityChecker.CONNECTIVITY_CLASSDATUMS.setState(true);
        ConnectivityChecker.CONNECTIVITY_CONNECTIONS.setState(true);
        ConnectivityChecker.CONNECTIVITY_EDGES.setState(true);
        ConnectivityChecker.CONNECTIVITY_NODES.setState(true);
        MyQVT myQVT1 = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons_expected.qvtras"));
        try {
            txClass = myQVT1.buildTransformation("Persons", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons_expected.qvtras"));
        try {
            myQVT2.loadEPackage(txClass, "Families.FamiliesPackage");
            myQVT2.loadEPackage(txClass, "Persons.PersonsPackage");
            myQVT2.loadEPackage(txClass, "trace_Families2Persons.trace_Families2PersonsPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("Families", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("Persons", this.getTestURI("Persons_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_Forward2Reverse() throws Exception {
        MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("reverse");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("EmptyList_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("EmptyList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("OneElementList_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("OneElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("TwoElementList_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("TwoElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("reverse", this.getTestURI("ThreeElementList_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("ThreeElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
            myQVT = null;
        }
    }

    @Test
    public void testQVTrCompiler_Forward2Reverse_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            txClass = myQVT1.buildTransformation((TypedModelsConfigurations)new DefaultConfigurations(), false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "doublylinkedlist.doublylinkedlistPackage");
            myQVT2.loadEPackage(txClass, "trace_Forward2Reverse.trace_Forward2ReversePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT2.executeTransformation("reverse");
            myQVT2.addOutputURI("reverse", this.getTestURI("EmptyList_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("EmptyList_CG.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT2.executeTransformation("reverse");
            myQVT2.addOutputURI("reverse", this.getTestURI("OneElementList_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("OneElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT2.executeTransformation("reverse");
            myQVT2.addOutputURI("reverse", this.getTestURI("TwoElementList_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("TwoElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT2.executeTransformation("reverse");
            myQVT2.addOutputURI("reverse", this.getTestURI("ThreeElementList_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("reverse", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT2.executeTransformation("forward");
            myQVT2.addOutputURI("forward", this.getTestURI("ThreeElementList_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine() throws Exception {
        MyQVT myQVT = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            ImperativeTransformation iTransformation = myQVT.compileTransformation("flat");
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("flat", this.getTestURI("MiniModel_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("MiniModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("flat", this.getTestURI("SimpleModel_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("SimpleModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(iTransformation);
            myQVT.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("flat", this.getTestURI("LargerModel_Interpreted.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("LargerModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
            myQVT = null;
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("flat", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("flat", this.getTestURI("MiniModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("MiniModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("flat", this.getTestURI("SimpleModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("SimpleModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("flat", this.getTestURI("LargerModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("LargerModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_example_CG() throws Exception {
        Class txClass;
        URI txURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/HierarchicalStateMachine2FlatStateMachine.qvtr", (boolean)true);
        MyQVT myQVT1 = this.createQVT("hstm2fstm", txURI);
        try {
            txClass = myQVT1.buildTransformation("flat", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            URI inURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/in/hier.xmi", (boolean)true);
            URI outURI = this.getTestURI("generated_CG.xmi");
            URI expectedURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/out/expected.xmi", (boolean)true);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", inURI);
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("flat", outURI);
            myQVT2.saveModels(null);
            myQVT2.checkOutput(outURI, expectedURI, FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_iCG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("flat", true, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.writeGraphMLfile(this.getTestURI("MiniModel-incremental.graphml"));
            myQVT2.addOutputURI("flat", this.getTestURI("MiniModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("MiniModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("flat", this.getTestURI("SimpleModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.writeGraphMLfile(this.getTestURI("SimpleModel-incremental.graphml"));
            myQVT2.checkOutput(this.getTestURI("SimpleModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.writeGraphMLfile(this.getTestURI("LargerModel-incremental.graphml"));
            myQVT2.addOutputURI("flat", this.getTestURI("LargerModel_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("LargerModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_Iterated2Iterated_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("Iterated2Iterated", this.getModelsURI("iterated2iterated/Iterated2Iterated.qvtr"));
        myQVT1.addUsedGenPackage("org.eclipse.emf.ecore/model/Ecore.genmodel", "//ecore");
        try {
            ProjectManager projectMap = myQVT1.getProjectManager();
            projectMap.configure(myQVT1.getResourceSet(), StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
            TypedModelsConfigurations typedModelsConfigurations = new TypedModelsConfigurations();
            typedModelsConfigurations.add(new TypedModelsConfiguration(new String[]{"to", "via"}));
            txClass = myQVT1.buildTransformation(typedModelsConfigurations, false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("Iterated2Iterated", this.getModelsURI("Iterated2Iterated/Iterated2Iterated.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "iterated.iteratedPackage");
            myQVT2.loadEPackage(txClass, "trace_Iterated2Iterated.trace_Iterated2IteratedPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("from", this.getModelsURI("iterated2iterated/samples/testcase1-in.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("to", this.getTestURI("testcase1-out_CG.iterated"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("testcase1-out_CG.iterated"), this.getModelsURI("iterated2iterated/samples/testcase1-out.xmi"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_MiToSiSimple_CG() throws Exception {
        Class txClass;
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        MyQVT myQVT1 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("java", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "javammsi.javammsiPackage");
            myQVT2.loadEPackage(txClass, "umlmmmi.umlmmmiPackage");
            myQVT2.loadEPackage(txClass, "trace_MiToSiSimple.trace_MiToSiSimplePackage");
            Map extensionToFactoryMap = myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("uml", this.getModelsURI("mitosi/samples/transportuml.xml"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("java", this.getTestURI("transportjava_CG.xml"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("transportjava_CG.xml"), this.getModelsURI("mitosi/samples/transportjava.xml"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_MiToSiSimpleWithKeys_CG() throws Exception {
        Class txClass;
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        MyQVT myQVT1 = this.createQVT("MiToSiSimpleWithKeys", this.getModelsURI("mitosi/MiToSiSimpleWithKeys.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("java", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "javammsi.javammsiPackage");
            myQVT2.loadEPackage(txClass, "umlmmmi.umlmmmiPackage");
            myQVT2.loadEPackage(txClass, "trace_MiToSiSimpleWithKeys.trace_MiToSiSimpleWithKeysPackage");
            Map extensionToFactoryMap = myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("uml", this.getModelsURI("mitosi/samples/transportuml.xml"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("java", this.getTestURI("transportjava_CG.xml"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("transportjava_CG.xml"), this.getModelsURI("mitosi/samples/transportjava.xml"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_Persons2Names2Families_CG() throws Exception {
        Class txClass;
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.getTestProjectManager().initializeResourceSet((ResourceSet)resourceSet);
        URIConverter uriConverter = resourceSet.getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFolder testFolder = testProject.getOutputFolder("samples");
        TestFile personFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/PersonsMulti.xmi"));
        TestFile familyFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesChildren.xmi"));
        TestFile refNamesFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesChildrenPlan.xmi"));
        TestFile refFamilyFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesAndPersons.xmi"));
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Persons2Names2Families.qvtr"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Families.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Names.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Persons.ecore"));
        URI namesOutURI = this.getTestURI("samples/MultiFamiliesChildrenPlan-CG.xmi");
        URI familiesOutURI = this.getTestURI("samples/MultiFamiliesChildren-CG.xmi");
        MyQVT myQVT1 = this.createQVT("Persons2Names2Families", txFile.getURI());
        try {
            txClass = myQVT1.buildTransformation(TargetConfiguration.createTargetConfigurations((String[])new String[]{"families", "persons"}), false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("Persons2Names2Families", txFile.getURI());
        try {
            Map extensionToFactoryMap = myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            myQVT2.loadEPackage(txClass, "Families.FamiliesPackage");
            myQVT2.loadEPackage(txClass, "Persons.PersonsPackage");
            myQVT2.loadEPackage(txClass, "Names.NamesPackage");
            myQVT2.loadEPackage(txClass, "trace_Persons2Names2Families.trace_Persons2Names2FamiliesPackage");
            QVTiTransformationExecutor txExecutor1 = myQVT2.createGeneratedExecutor(txClass);
            txExecutor1.setContextualProperty("PREFER_EXISTING_FAMILY_TO_NEW", (Object)Boolean.FALSE);
            txExecutor1.setContextualProperty("PREFER_CREATING_PARENT_TO_CHILD", (Object)Boolean.FALSE);
            txExecutor1.addInputURI("persons", personFile.getURI());
            txExecutor1.addInputURI("familiesLeft", familyFile.getURI());
            txExecutor1.execute("families");
            txExecutor1.addOutputURI("names", namesOutURI);
            txExecutor1.addOutputURI("familiesRight", familiesOutURI);
            txExecutor1.saveModels(null);
            myQVT2.checkOutput(namesOutURI, refNamesFile.getURI(), NamesNormalizer.INSTANCE);
            myQVT2.checkOutput(familiesOutURI, refFamilyFile.getURI(), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_Persons2Names2Families() throws Exception {
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.getTestProjectManager().initializeResourceSet((ResourceSet)resourceSet);
        URIConverter uriConverter = resourceSet.getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFolder testFolder = testProject.getOutputFolder("samples");
        TestFile personFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/PersonsMulti.xmi"));
        TestFile familyFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesChildren.xmi"));
        TestFile refNamesFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesChildrenPlan.xmi"));
        TestFile refFamilyFile = testProject.copyFile(uriConverter, testFolder, this.getModelsURI("persons2families/samples/MultiFamiliesAndPersons.xmi"));
        TestFile txFile = testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Persons2Names2Families.qvtr"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Families.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Names.ecore"));
        testProject.copyFile(uriConverter, null, this.getModelsURI("persons2families/Persons.ecore"));
        URI namesOutURI = this.getTestURI("samples/MultiFamiliesChildrenPlan-Int.xmi");
        URI familiesOutURI = this.getTestURI("samples/MultiFamiliesChildren-Int.xmi");
        MyQVT myQVT = this.createQVT("Persons2Names2Families", txFile.getURI());
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation(TargetConfiguration.createTargetConfigurations((String[])new String[]{"families", "persons"}));
            Map extensionToFactoryMap = myQVT.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            BasicQVTiExecutor txExecutor1 = myQVT.createInterpretedExecutor(QVTimperativeUtil.getEntryPoint((ImperativeTransformation)asTransformation, (String)"families"));
            txExecutor1.setContextualProperty("PREFER_EXISTING_FAMILY_TO_NEW", (Object)Boolean.FALSE);
            txExecutor1.setContextualProperty("PREFER_EXISTING_FAMILY_TO_NEW", (Object)Boolean.FALSE);
            txExecutor1.setContextualProperty("PREFER_CREATING_PARENT_TO_CHILD", (Object)Boolean.FALSE);
            txExecutor1.addInputURI("persons", personFile.getURI());
            txExecutor1.addInputURI("familiesLeft", familyFile.getURI());
            txExecutor1.execute();
            txExecutor1.addOutputURI("names", namesOutURI);
            txExecutor1.addOutputURI("familiesRight", familiesOutURI);
            txExecutor1.saveModels(null);
            myQVT.checkOutput(namesOutURI, refNamesFile.getURI(), NamesNormalizer.INSTANCE);
            myQVT.checkOutput(familiesOutURI, refFamilyFile.getURI(), null);
        }
        finally {
            myQVT.dispose();
            myQVT = null;
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm() throws Exception {
        MyQVT myQVT = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("stm");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.addInputURI("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            myQVT.executeTransformation();
            myQVT.addOutputURI("stm", this.getTestURI("Stmc_Interpreted.xmi"));
            myQVT.addOutputURI("middle", this.getTestURI("Seq2Stmc_trace.xmi"));
            myQVT.saveModels(null);
            myQVT.checkOutput(this.getTestURI("Stmc_Interpreted.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT.dispose();
            myQVT = null;
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("stm", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "SeqMM.SeqMMPackage");
            myQVT2.loadEPackage(txClass, "StmcMM.StmcMMPackage");
            myQVT2.loadEPackage(txClass, "trace_SeqToStm.trace_SeqToStmPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            myQVT2.executeTransformation();
            myQVT2.addOutputURI("stm", this.getTestURI("Stmc_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Stmc_CG.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm_iCG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("stm", true, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "SeqMM.SeqMMPackage");
            myQVT2.loadEPackage(txClass, "StmcMM.StmcMMPackage");
            myQVT2.loadEPackage(txClass, "trace_SeqToStm.trace_SeqToStmPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            myQVT2.executeTransformation();
            myQVT2.writeGraphMLfile(this.getTestURI("SeqToStm-incremental.graphml"));
            myQVT2.addOutputURI("stm", this.getTestURI("Stmc_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Stmc_CG.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    @Test
    public void testQVTrCompiler_TinyIsomorph_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("TinyIsomorph", this.getModelsURI("tinyisomorph/TinyIsomorph.qvtr"));
        try {
            txClass = myQVT1.buildTransformation((TypedModelsConfigurations)new DefaultConfigurations(), false, new String[0]);
        }
        finally {
            myQVT1.dispose();
            myQVT1 = null;
        }
        ThreadLocalExecutor.waitForGC();
        MyQVT myQVT2 = this.createQVT("TinyIsomorph", this.getModelsURI("tinyisomorph/TinyIsomorph.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "mma.mmaPackage");
            myQVT2.loadEPackage(txClass, "trace_TinyIsomorph.trace_TinyIsomorphPackage");
            myQVT2.loadEPackage(txClass, "mmb.mmbPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("mma", this.getModelsURI("tinyisomorph/samples/Zero.xmi"));
            myQVT2.executeTransformation("mmb");
            myQVT2.addOutputURI("mmb", this.getTestURI("Zero_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Zero_CG.xmi"), this.getModelsURI("tinyisomorph/samples/Zero_expected.xmi"), null);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("mma", this.getModelsURI("tinyisomorph/samples/One.xmi"));
            myQVT2.executeTransformation("mmb");
            myQVT2.addOutputURI("mmb", this.getTestURI("One_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("One_CG.xmi"), this.getModelsURI("tinyisomorph/samples/One_expected.xmi"), null);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("mma", this.getModelsURI("tinyisomorph/samples/Two.xmi"));
            myQVT2.executeTransformation("mmb");
            myQVT2.addOutputURI("mmb", this.getTestURI("Two_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Two_CG.xmi"), this.getModelsURI("tinyisomorph/samples/Two_expected.xmi"), null);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.addInputURI("mma", this.getModelsURI("tinyisomorph/samples/Three.xmi"));
            myQVT2.executeTransformation("mmb");
            myQVT2.addOutputURI("mmb", this.getTestURI("Three_CG.xmi"));
            myQVT2.saveModels(null);
            myQVT2.checkOutput(this.getTestURI("Three_CG.xmi"), this.getModelsURI("tinyisomorph/samples/Three_expected.xmi"), null);
        }
        finally {
            myQVT2.dispose();
            myQVT2 = null;
        }
    }

    public static class DummyPivotExternalURINormalizer
    implements ModelNormalizer {
        public static final @NonNull DummyPivotExternalURINormalizer INSTANCE = new DummyPivotExternalURINormalizer();

        public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull XtextTestCase.Normalizer> normalize(@NonNull Resource resource) {
            Model model = (Model)resource.getContents().get(0);
            model.setExternalURI("normalized-external-uri");
            return Collections.emptyList();
        }
    }

    public class MyQVT
    extends AbstractTestQVT {
        private boolean keepOldJavaFiles;

        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, URI binFileURI) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
            this.keepOldJavaFiles = false;
            this.getEnvironmentFactory().setSafeNavigationValidationSeverity(StatusCodes.Severity.WARNING);
        }

        private void configureGeneratedPackage(String uriString) {
            URI nsURI = URI.createURI((String)uriString);
            ProjectManager.IPackageDescriptor packageDescriptor = this.getProjectManager().getPackageDescriptor(nsURI);
            if (packageDescriptor != null) {
                packageDescriptor.configure(this.getResourceSet(), StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, null);
            }
        }

        protected @NonNull CompilerOptions createBuildCompilerChainOptions(boolean isIncremental) throws IOException {
            CompilerOptions options = super.createBuildCompilerChainOptions(isIncremental);
            if (this.keepOldJavaFiles) {
                options.setOption("GenModel", CompilerChain.KEEP_OLD_JAVA_FILES_KEY, (Object)Boolean.TRUE);
            }
            return options;
        }

        protected @NonNull QVTrCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new InstrumentedCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, options);
        }

        protected @NonNull DefaultCompilerOptions createCompilerChainOptions() {
            DefaultCompilerOptions options = super.createCompilerChainOptions();
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_EARLY_MERGE, (Object)NO_MERGES);
            options.setOption("QVTs", CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE, (Object)NO_MERGES);
            return options;
        }

        protected boolean generateGenModel() {
            return true;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.xtext.qvtrelation.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) throws Exception {
            return EMFPlugin.IS_ECLIPSE_RUNNING ? new ProjectMap(true) : QVTrCompilerTests.this.getTestProjectManager(pathFromCurrentWorkingDirectoryToFileSystem);
        }

        protected void setKeepOldJavaFiles() {
            this.keepOldJavaFiles = true;
        }

        protected class InstrumentedCompilerChain
        extends QVTrCompilerChain {
            protected InstrumentedCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, CompilerOptions options) {
                super(environmentFactory, txURI, intermediateFileNamePrefixURI, options);
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull QVTrCompilerChain.QVTr2QVTsCompilerStep createQVTr2QVTsCompilerStep() {
                return new QVTrCompilerChain.QVTr2QVTsCompilerStep(this){

                    public @NonNull ScheduleManager execute(@NonNull Resource qvtrResource, @NonNull Resource traceResource, @NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
                        ScheduleManager scheduleManager = super.execute(qvtrResource, traceResource, typedModelsConfigurations);
                        MyQVT.this.instrumentPartition(scheduleManager);
                        return scheduleManager;
                    }
                };
            }

            public @NonNull ImperativeTransformation qvtr2qvti(@NonNull Resource qvtrResource, @NonNull TypedModelsConfigurations typedModelsConfigurations) throws IOException {
                InstrumentedCompilerChain.assertNoValidationErrors((String)"QVTr validation", (Resource)qvtrResource);
                return super.qvtr2qvti(qvtrResource, typedModelsConfigurations);
            }
        }
    }

    protected static class PivotQVTrelationToStringFactory
    implements ToStringVisitor.Factory {
        protected PivotQVTrelationToStringFactory() {
            ToStringVisitor.addFactory((EPackage)PivotPackage.eINSTANCE, (ToStringVisitor.Factory)this);
            ToStringVisitor.addFactory((EPackage)QVTtemplatePackage.eINSTANCE, (ToStringVisitor.Factory)this);
            QVTrelationToStringVisitor.FACTORY.getClass();
        }

        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
            return new QVTrelationToStringVisitor(s);
        }

        public @NonNull EPackage getEPackage() {
            PivotPackage eInstance = PivotPackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

