/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.DatumCaches;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.NameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class BasicScheduleManager
extends AbstractScheduleManager {
    protected final @NonNull NameGenerator nameGenerator;
    protected final @NonNull DatumCaches datumCaches;
    private @Nullable ClassDatum booleanClassDatum;
    private @Nullable ClassDatum oclVoidClassDatum;
    private final @NonNull Set<@NonNull ClassDatum> classDatums = new HashSet<ClassDatum>();
    private final @NonNull Map<Type, Property> type2iterateProperty = new HashMap<Type, Property>();
    private final @NonNull Map<@NonNull Transformation, @NonNull Transformation2TracePackage> transformation2transformation2TracePackage = new HashMap<Transformation, Transformation2TracePackage>();

    protected BasicScheduleManager(@NonNull ScheduleModel scheduleModel, @NonNull EnvironmentFactory environmentFactory, @NonNull Transformation transformation, @NonNull ProblemHandler problemHandler,  @Nullable CompilerOptions.StepOptions schedulerOptions) {
        this(scheduleModel, environmentFactory, transformation, problemHandler, schedulerOptions, null, null, null);
    }

    protected BasicScheduleManager(@NonNull ScheduleModel scheduleModel, @NonNull EnvironmentFactory environmentFactory, @NonNull Transformation transformation, @NonNull ProblemHandler problemHandler,  @Nullable CompilerOptions.StepOptions schedulerOptions, @Nullable NameGenerator nameGenerator, @Nullable DatumCaches datumCaches, @Nullable RootDomainUsageAnalysis domainUsageAnalysis) {
        super(scheduleModel, environmentFactory, transformation, problemHandler, schedulerOptions, domainUsageAnalysis);
        this.nameGenerator = nameGenerator != null ? nameGenerator : this.createNameGenerator();
        this.datumCaches = datumCaches != null ? datumCaches : new DatumCaches(this);
    }

    @Override
    public void analyzeCompletePackage(@NonNull TypedModel typedModel, @NonNull CompletePackage completePackage) {
        this.datumCaches.analyzeCompletePackage(typedModel, completePackage);
    }

    @Override
    public void analyzeTracePackage(@NonNull TypedModel typedModel, @NonNull Package tracePackage) {
        this.domainUsageAnalysis.analyzeTracePackage(typedModel, tracePackage);
        CompleteModel completeModel = this.environmentFactory.getCompleteModel();
        CompletePackage completePackage = completeModel.getCompletePackage(tracePackage);
        this.datumCaches.analyzeCompletePackage(typedModel, completePackage);
    }

    @Override
    public @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum classDatum) {
        return this.datumCaches.getAllPropertyDatums(classDatum);
    }

    @Override
    public @NonNull ClassDatum getBooleanClassDatum() {
        ClassDatum booleanClassDatum2 = this.booleanClassDatum;
        if (booleanClassDatum2 == null) {
            TypedModel primitiveTypedModel = this.domainUsageAnalysis.getPrimitiveTypedModel();
            StandardLibrary standardLibrary = this.environmentFactory.getStandardLibrary();
            this.booleanClassDatum = booleanClassDatum2 = this.getClassDatum(primitiveTypedModel, (Type)standardLibrary.getBooleanType());
        }
        return booleanClassDatum2;
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        return this.datumCaches.getClassDatum(typedModel, completeClass);
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Iterable<@NonNull CompleteClass> completeClasses) {
        int size = Iterables.size(completeClasses);
        if (size == 1) {
            return this.datumCaches.getClassDatum(typedModel, completeClasses.iterator().next());
        }
        return this.datumCaches.getClassDatum(typedModel, Sets.newHashSet(completeClasses));
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedElement asTypedElement) {
        TypedModel typedModel;
        Class asType = (Class)asTypedElement.getType();
        assert (asType != null);
        Type elementType = PivotUtil.getElementalType((Type)asType);
        if (elementType instanceof DataType) {
            typedModel = this.getDomainUsageAnalysis().getPrimitiveTypedModel();
        } else {
            DomainUsage domainUsage = this.getDomainUsage((Element)asTypedElement);
            assert (domainUsage != null);
            typedModel = domainUsage.getTypedModel((Element)asTypedElement);
            assert (typedModel != null);
        }
        return this.datumCaches.getClassDatum(typedModel, (Type)asType);
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Type asType) {
        return this.datumCaches.getClassDatum(typedModel, asType);
    }

    @Override
    public @NonNull Iterable<@NonNull ClassDatum> getClassDatums() {
        return this.classDatums;
    }

    @Override
    public @NonNull ContainmentAnalysis getContainmentAnalysis() {
        return this.datumCaches.getContainmentAnalysis();
    }

    @Override
    public @NonNull ClassDatum getElementalTargetClassDatum(@NonNull PropertyDatum propertyDatum) {
        return this.datumCaches.getElementalTargetClassDatum(propertyDatum);
    }

    @Override
    public @NonNull Property getIterateProperty(@NonNull Type type) {
        Property iterateProperty = this.type2iterateProperty.get(type);
        if (iterateProperty == null) {
            iterateProperty = this.createProperty("\u00abiterate\u00bb", type, true);
            this.type2iterateProperty.put(type, iterateProperty);
        }
        return iterateProperty;
    }

    @Override
    public @NonNull NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    @Override
    public @NonNull ClassDatum getOclVoidClassDatum() {
        ClassDatum oclVoidClassDatum2 = this.oclVoidClassDatum;
        if (oclVoidClassDatum2 == null) {
            TypedModel primitiveTypedModel = this.domainUsageAnalysis.getPrimitiveTypedModel();
            StandardLibrary standardLibrary = this.environmentFactory.getStandardLibrary();
            this.oclVoidClassDatum = oclVoidClassDatum2 = this.getClassDatum(primitiveTypedModel, (Type)standardLibrary.getOclVoidType());
        }
        return oclVoidClassDatum2;
    }

    @Override
    public @NonNull PropertyDatum getPropertyDatum(@NonNull ClassDatum sourceClassDatum, @NonNull Property property, @Nullable ClassDatum targetClassDatum) {
        return this.datumCaches.getPropertyDatum(sourceClassDatum, property, targetClassDatum);
    }

    @Override
    public @NonNull Iterable<@NonNull PropertyDatum> getPropertyDatums(@NonNull NavigationEdge navigationEdge) {
        Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
        if (property == this.standardLibraryHelper.getOclContainerProperty()) {
            Node targetNode;
            Node castTarget = targetNode = QVTscheduleUtil.getSourceNode((Edge)navigationEdge);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
            return this.datumCaches.getOclContainerPropertyDatums(classDatum);
        }
        return Collections.singletonList(this.getPropertyDatum(navigationEdge));
    }

    @Override
    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        return this.datumCaches.getSuccessPropertyDatum(successProperty);
    }

    @Override
    public @NonNull Transformation2TracePackage getTransformation2TracePackage(@NonNull Transformation transformation) {
        Transformation2TracePackage transformation2TracePackage = this.transformation2transformation2TracePackage.get(transformation);
        if (transformation2TracePackage == null) {
            transformation2TracePackage = this.createTransformation2TracePackage(transformation);
            this.transformation2transformation2TracePackage.put(transformation, transformation2TracePackage);
        }
        return transformation2TracePackage;
    }
}

