/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.ocl.examples.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.ocl.examples.modelregistry.environment.FileHandle;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.ecore.mappings.MappingConfigurationException;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.qvt.declarative.editor.ui.pages.EditorPageManager;
import org.eclipse.qvt.declarative.editor.ui.text.ITextEditorWithUndoContext;
import org.eclipse.qvt.declarative.editor.ui.text.TextResource;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.unparser.IUnparser;
import org.eclipse.qvt.declarative.parser.utils.ProblemCounter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPageManager
extends EditorPageManager {
    protected final TextResource textResource;

    public TextPageManager(PagedEditor pagedEditor, XMLResource resource, TextResource textResource) {
        super(pagedEditor, resource, textResource != null, String.valueOf(pagedEditor.getCreationFactory().getEditorName()) + " Text");
        this.textResource = textResource;
    }

    @Override
    public ProblemCounter cannotDeactivate(Map<XMLResource, XMLResource> updates, IProgressMonitor monitor) {
        FileHandle fileHandle = this.getFileHandle();
        ICSTFileEnvironment environment = this.getCreationFactory().createFileEnvironment(fileHandle, this.getResourceSet(), this.resource.getURI());
        ProblemCounter reporter = new ProblemCounter();
        environment.setProblemHandler((ProblemHandler)reporter);
        StringReader reader = new StringReader(this.getCurrentContents());
        try {
            environment.parse((Reader)reader, environment.getFile(), null);
            updates.put(this.resource, (XMLResource)environment.getASTResource());
            reporter.flush(null);
        }
        catch (Exception e) {
            QVTEditorPlugin.logError("Internal error while validating", e);
            reporter.handleProblem(ProblemHandler.Severity.FATAL, ProblemHandler.Phase.UTILITY, e.getMessage(), "", -1, -1);
        }
        return reporter;
    }

    @Override
    public void createContents(OutputStream outputStream) throws MappingConfigurationException, IOException {
        IUnparser unparser = this.getCreationFactory().createUnparser((Resource)this.resource);
        unparser.unparse();
        outputStream.write(unparser.getBytes());
    }

    @Override
    protected ITextEditorWithUndoContext createEditor() {
        return this.getCreationFactory().createTextEditor(this);
    }

    @Override
    public void doSave(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.textResource != null) {
            this.textResource.setSaveInProgress(true);
        }
        try {
            super.doSave(monitor);
            this.refresh();
        }
        finally {
            if (this.textResource != null) {
                this.textResource.setSaveInProgress(false);
            }
        }
    }

    @Override
    public String getFileExtension() {
        return this.getCreationFactory().getTextExtension();
    }

    @Override
    public boolean gotoMarker(IMarker marker) {
        try {
            Object builderId = marker.getAttribute("builderId");
            if (this.getCreationFactory().getBuilderId().equals(builderId)) {
                this.pagedEditor.setActiveEditor((IEditorPart)this.getEditor());
                IDE.gotoMarker(this.getEditor(), (IMarker)marker);
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    @Override
    public void refresh() {
        this.refreshMarkers(this.getEditorInput().getFile());
    }

    protected void refreshMarkers(IFile file) {
        URI uri = URI.createFileURI((String)file.toString());
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(this.pagedEditor.getProject());
        EclipseFileHandle fileHandle = projectHandle.getFileHandle((IResource)this.pagedEditor.getEditorInputFile());
        ICSTFileEnvironment environment = this.getCreationFactory().createFileEnvironment((FileHandle)fileHandle, this.getResourceSet(), uri);
        ProblemHandler reporter = this.getCreationFactory().createProblemHandler(file);
        environment.setProblemHandler(reporter);
        try {
            try {
                StringReader reader = new StringReader(this.getCurrentContents());
                ICSTRootEnvironment rootEnvironment = environment.parse((Reader)reader, environment.getFile(), null);
                if (rootEnvironment != null) {
                    rootEnvironment.validate();
                }
            }
            catch (Exception e) {
                reporter.utilityProblem(ProblemHandler.Severity.ERROR, "Failed to refreshMarkers: " + e, null, -1, -1);
                QVTEditorPlugin.logError("Failed to refreshMarkers on " + file.getFullPath().toString(), e);
                reporter.flush(null);
            }
        }
        finally {
            reporter.flush(null);
        }
    }

    @Override
    public void saveTo(IFile file, IProgressMonitor monitor) {
        this.refreshMarkers(file);
        super.saveTo(file, monitor);
    }
}

