/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.qvt.declarative.editor.AbstractOutlineElement;
import org.eclipse.qvt.declarative.editor.OutlineBehavior;
import org.eclipse.qvt.declarative.editor.OutlineElement;
import org.eclipse.qvt.declarative.editor.OutlineGroup;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonEditorDefinition;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.eclipse.qvt.declarative.parser.utils.CommonASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTreeModelBuilder
extends TreeModelBuilderBase {
    public static final Integer DEFAULT_CATEGORY = 0;
    protected final ICreationFactory creationFactory;
    protected final boolean showAST;
    protected final Map<Object, ModelTreeNode> itemMap = new HashMap<Object, ModelTreeNode>();
    protected final Stack<Integer> categoryStack;

    public CommonTreeModelBuilder(ICreationFactory creationFactory, boolean showAST) {
        this.creationFactory = creationFactory;
        this.showAST = showAST;
        this.categoryStack = new Stack();
        this.categoryStack.push(0);
    }

    protected CommonASTModelVisitor<Notifier> createASTVisitor(CommonEditorDefinition editorDefinition) {
        return new CommonASTModelVisitor<Notifier>(editorDefinition, Notifier.class);
    }

    protected ModelTreeNode createSubItem(Object n, int category) {
        ModelTreeNode item = super.createSubItem(n, category);
        this.itemMap.put(n, item);
        return item;
    }

    protected ModelTreeNode createTopItem(Object n, int category) {
        ModelTreeNode item = super.createTopItem(n, category);
        this.itemMap.clear();
        this.itemMap.put(n, item);
        return item;
    }

    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    public ModelTreeNode getItem(Object n) {
        return this.itemMap.get(n);
    }

    public ICommonPlugin getPlugin() {
        return this.creationFactory.getPlugin();
    }

    public void visitTree(Object root) {
        if (root instanceof ICommonParseResult) {
            root = this.showAST ? ((ICommonParseResult)root).getAST() : ((ICommonParseResult)root).getCST();
        }
        CommonEditorDefinition editorDefinition = this.getPlugin().getEditorDefinition();
        this.createASTVisitor(editorDefinition).enter(root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommonASTModelVisitor<N>
    extends CommonASTVisitor<Object, N> {
        protected final CommonEditorDefinition editorDefinition;
        protected final Class<OutlineBehavior> outlineBehaviorClass;

        public CommonASTModelVisitor(CommonEditorDefinition editorDefinition, Class<N> nodeClass) {
            this(editorDefinition, nodeClass, OutlineBehavior.class);
        }

        public CommonASTModelVisitor(CommonEditorDefinition editorDefinition, Class<N> nodeClass, Class<OutlineBehavior> outlineBehaviorClass) {
            super(nodeClass);
            this.editorDefinition = editorDefinition;
            this.outlineBehaviorClass = outlineBehaviorClass;
        }

        protected Object enterCollection(Collection<?> collection) {
            for (Object o : collection) {
                this.enter(o);
            }
            return null;
        }

        protected void enterElement(N astNode, AbstractOutlineElement element) {
            if (element instanceof OutlineElement) {
                this.enterOutlineElement(astNode, (OutlineElement)element);
            } else if (element instanceof OutlineGroup) {
                this.enterOutlineGroup(astNode, (OutlineGroup)element);
            } else {
                this.unexpectedEnterOutline(astNode, element);
            }
        }

        protected void enterOutlineElement(N astNode, OutlineElement element) {
            if (astNode instanceof EObject) {
                EStructuralFeature feature = element.getFeature();
                Object selection = ((EObject)astNode).eGet(feature, false);
                this.enter(selection);
            } else {
                this.unexpectedEnterOutline(astNode, (AbstractOutlineElement)element);
            }
        }

        protected void enterOutlineGroup(N astNode, OutlineGroup group) {
            EList elements = group.getElements();
            if (!elements.isEmpty()) {
                AbstractOutlineElement childElement;
                boolean isEmpty = true;
                Iterator iterator = elements.iterator();
                if (iterator.hasNext() && !this.isEmpty(astNode, childElement = (AbstractOutlineElement)iterator.next())) {
                    isEmpty = false;
                }
                if (!isEmpty) {
                    try {
                        boolean isFlat;
                        boolean isHidden = group.isHidden();
                        boolean bl = isFlat = group.getName() == null && group.getImage() == null;
                        if (isHidden) {
                            CommonTreeModelBuilder.this.categoryStack.push(this.editorDefinition.getCategory(group));
                        } else if (isEmpty) {
                            CommonTreeModelBuilder.this.categoryStack.push(DEFAULT_CATEGORY);
                        } else {
                            if (!isFlat) {
                                CommonTreeModelBuilder.this.pushSubItem(group, CommonTreeModelBuilder.this.categoryStack.peek());
                            } else {
                                CommonTreeModelBuilder.this.createSubItem(group, CommonTreeModelBuilder.this.categoryStack.peek());
                            }
                            CommonTreeModelBuilder.this.categoryStack.push(DEFAULT_CATEGORY);
                        }
                        for (AbstractOutlineElement childElement2 : elements) {
                            this.enterElement(astNode, childElement2);
                        }
                        if (!(isHidden || isEmpty || isFlat)) {
                            CommonTreeModelBuilder.this.popSubItem();
                        }
                    }
                    finally {
                        CommonTreeModelBuilder.this.categoryStack.pop();
                    }
                }
            }
        }

        protected boolean isEmpty(N astNode, AbstractOutlineElement element) {
            if (element instanceof OutlineElement) {
                return this.isEmptyOutlineElement(astNode, (OutlineElement)element);
            }
            if (element instanceof OutlineGroup) {
                return this.isEmptyOutlineGroup(astNode, (OutlineGroup)element);
            }
            return false;
        }

        protected boolean isEmptyOutlineElement(N astNode, OutlineElement element) {
            if (astNode instanceof EObject) {
                EStructuralFeature feature = element.getFeature();
                Object selection = ((EObject)astNode).eGet(feature, false);
                if (feature.isMany()) {
                    return ((Collection)selection).isEmpty();
                }
                return false;
            }
            return false;
        }

        protected boolean isEmptyOutlineGroup(N astNode, OutlineGroup group) {
            EList elements = group.getElements();
            if (elements.isEmpty()) {
                return true;
            }
            for (AbstractOutlineElement childElement : elements) {
                if (this.isEmpty(astNode, childElement)) continue;
                return false;
            }
            return true;
        }

        public Object postVisit(N astNode) {
            boolean isHidden;
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, this.outlineBehaviorClass);
            boolean bl = isHidden = behavior != null && behavior.isHidden();
            if (!isHidden) {
                CommonTreeModelBuilder.this.popSubItem();
            }
            CommonTreeModelBuilder.this.categoryStack.pop();
            return super.postVisit(astNode);
        }

        public boolean preVisit(N astNode) {
            boolean isHidden;
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, this.outlineBehaviorClass);
            boolean bl = isHidden = behavior != null && behavior.isHidden();
            if (isHidden) {
                CommonTreeModelBuilder.this.categoryStack.push(DEFAULT_CATEGORY);
                return true;
            }
            boolean isTerminal = behavior != null && behavior.getElements().isEmpty();
            return this.preVisit(astNode, isTerminal);
        }

        protected boolean preVisit(N astNode, boolean isTerminal) {
            if (isTerminal) {
                CommonTreeModelBuilder.this.createSubItem(astNode, CommonTreeModelBuilder.this.categoryStack.peek());
                return false;
            }
            CommonTreeModelBuilder.this.pushSubItem(astNode, CommonTreeModelBuilder.this.categoryStack.peek());
            CommonTreeModelBuilder.this.categoryStack.push(DEFAULT_CATEGORY);
            return true;
        }

        protected void unexpectedEnterOutline(N astNode, AbstractOutlineElement element) {
            QVTEditorPlugin.logError("Unexpected enter outline for a '" + element.getClass().getName() + "' at a '" + astNode.getClass().getSimpleName() + "' by a '" + ((Object)((Object)this)).getClass().getSimpleName() + "'", null);
        }

        public Object visit(N astNode) {
            int size = CommonTreeModelBuilder.this.categoryStack.size();
            Object result = super.visit(astNode);
            assert (size == CommonTreeModelBuilder.this.categoryStack.size());
            return result;
        }

        public void visitEObject(N astNode) {
            EList elements;
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, this.outlineBehaviorClass);
            if (behavior != null && !(elements = behavior.getElements()).isEmpty()) {
                for (AbstractOutlineElement element : elements) {
                    this.enterElement(astNode, element);
                }
                return;
            }
            super.visitEObject(astNode);
        }
    }
}

