/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.unparser;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.parser.unparser.OCLExpressionUnparser;

public class OCLUnparser
extends OCLExpressionUnparser {
    public OCLUnparser(Resource resource) {
        super(resource, (UMLReflection<?, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)new DummyEcoreEnvironment().getUMLReflection());
    }

    protected String formatQualifiedName(Object object) {
        if (object instanceof PrimitiveType) {
            return super.formatName(object);
        }
        return super.formatQualifiedName(object);
    }

    public void unparse() {
        this.initialize();
        boolean first = true;
        for (EObject eObject : this.resource.getContents()) {
            if (!first) {
                this.append("\n");
            }
            if (eObject instanceof Constraint) {
                this.unparseConstraint((Constraint)eObject);
            } else {
                this.unparseUnsupported(eObject);
            }
            first = false;
        }
    }

    protected void unparseConstraint(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.append("\ncontext");
        for (EModelElement constrainedElement : constraint.getConstrainedElements()) {
            this.append(" ");
            if (constrainedElement instanceof EStructuralFeature) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)constrainedElement;
                this.appendQualifiedName(eStructuralFeature.getEContainingClass());
                this.append("::");
                this.appendName(eStructuralFeature);
                this.append(" : ");
                this.appendQualifiedName(eStructuralFeature.getEType());
                continue;
            }
            if (constrainedElement instanceof EOperation) {
                EOperation eOperation = (EOperation)constrainedElement;
                this.appendQualifiedName(eOperation.getEContainingClass());
                this.append("::");
                this.appendName(eOperation);
                this.append("(");
                boolean isFirst = true;
                for (EParameter eParameter : eOperation.getEParameters()) {
                    if (!isFirst) {
                        this.append(", ");
                    }
                    this.appendName(eParameter);
                    EClassifier parameterType = eParameter.getEType();
                    if (parameterType != null) {
                        this.append(" : ");
                        this.appendQualifiedName(eParameter.getEType());
                    }
                    isFirst = false;
                }
                this.append(")");
                EClassifier returnType = eOperation.getEType();
                this.append(" : ");
                if (returnType == null) continue;
                this.appendQualifiedName(returnType);
                continue;
            }
            if (constrainedElement instanceof EClass) {
                this.appendQualifiedName(constrainedElement);
                continue;
            }
            this.appendQualifiedName(constrainedElement);
        }
        this.append("\n");
        String stereotype = constraint.getStereotype();
        if ("body".equals(stereotype)) {
            this.unparseKeyedExpression(constraint, "body");
        } else if ("definition".equals(stereotype)) {
            this.unparseDefinition(constraint);
        } else if ("derivation".equals(stereotype)) {
            this.unparseDerivation(constraint);
        } else if ("initial".equals(stereotype)) {
            this.unparseInitial(constraint);
        } else if ("invariant".equals(stereotype)) {
            this.unparseKeyedExpression(constraint, "inv");
        } else if ("postcondition".equals(stereotype)) {
            this.unparseKeyedExpression(constraint, "post");
        } else if ("precondition".equals(stereotype)) {
            this.unparseKeyedExpression(constraint, "pre");
        } else {
            this.append("***" + this.getClass().getSimpleName() + "-Unsupported-" + constraint.getClass().getSimpleName() + " " + stereotype + " ***\n");
        }
    }

    protected void unparseDefinition(Constraint constraint) {
        ExpressionInOCL specification = constraint.getSpecification();
        if (specification == null) {
            return;
        }
        this.append("def");
        String name = constraint.getName();
        if (name != null) {
            this.append(" ");
            this.append(name);
        }
        this.append(": ");
        this.doExpressionSwitch((EObject)specification.getBodyExpression());
    }

    protected void unparseDerivation(Constraint constraint) {
        ExpressionInOCL specification = constraint.getSpecification();
        if (specification == null) {
            return;
        }
        this.append("derive: ");
        this.doExpressionSwitch((EObject)specification.getBodyExpression());
    }

    protected void unparseInitial(Constraint constraint) {
        ExpressionInOCL specification = constraint.getSpecification();
        if (specification == null) {
            return;
        }
        this.append("init: ");
        this.doExpressionSwitch((EObject)specification.getBodyExpression());
    }

    protected void unparseKeyedExpression(Constraint constraint, String keyword) {
        ExpressionInOCL specification = constraint.getSpecification();
        if (specification == null) {
            return;
        }
        this.append(keyword);
        String name = constraint.getName();
        if (name != null) {
            this.append(" ");
            this.append(name);
        }
        this.append(": ");
        this.doExpressionSwitch((EObject)specification.getBodyExpression());
    }

    public static class DummyEcoreEnvironment
    extends EcoreEnvironment {
        public DummyEcoreEnvironment() {
            super(null);
        }
    }
}

