/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.unparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTCore.Area;
import org.eclipse.qvt.declarative.ecore.QVTCore.Assignment;
import org.eclipse.qvt.declarative.ecore.QVTCore.BottomPattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.CoreDomain;
import org.eclipse.qvt.declarative.ecore.QVTCore.EnforcementMode;
import org.eclipse.qvt.declarative.ecore.QVTCore.EnforcementOperation;
import org.eclipse.qvt.declarative.ecore.QVTCore.GuardPattern;
import org.eclipse.qvt.declarative.ecore.QVTCore.Mapping;
import org.eclipse.qvt.declarative.ecore.QVTCore.PropertyAssignment;
import org.eclipse.qvt.declarative.ecore.QVTCore.VariableAssignment;
import org.eclipse.qvt.declarative.parser.qvt.environment.QVTReflectionImpl;
import org.eclipse.qvt.declarative.parser.unparser.OCLExpressionUnparser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTcUnparser
extends OCLExpressionUnparser {
    public QVTcUnparser(Resource resource) {
        super(resource, (UMLReflection)QVTReflectionImpl.INSTANCE);
    }

    public void unparse() {
        this.initialize();
        boolean first = true;
        for (EObject eObject : this.resource.getContents()) {
            if (!first) {
                this.append("\n");
            }
            if (eObject instanceof Transformation) {
                this.unparseTransformation((Transformation)eObject);
            } else {
                this.unparseUnsupported(eObject);
            }
            first = false;
        }
        for (EObject eObject : this.resource.getContents()) {
            if (!first) {
                this.append("\n");
            }
            if (eObject instanceof Transformation) {
                for (EOperation operation : ((Transformation)eObject).getEOperations()) {
                    if (operation instanceof Function) {
                        this.unparseQuery((Function)operation);
                        continue;
                    }
                    this.unparseUnsupported(operation);
                }
                for (Rule rule : ((Transformation)eObject).getRule()) {
                    if (rule instanceof Mapping) {
                        this.unparseMapping((Mapping)rule);
                        continue;
                    }
                    this.unparseUnsupported(rule);
                }
            }
            first = false;
        }
    }

    protected void unparseArea(Area area, List<EPackage> areaPackages) {
        if (area == null) {
            return;
        }
        this.append(" (\n");
        this.unparseGuardPattern(area.getGuardPattern(), areaPackages);
        this.append(") {\n");
        this.unparseBottomPattern(area.getBottomPattern(), areaPackages);
        this.append("}\n");
    }

    protected Object unparseAreaVariable(Variable variable, List<EPackage> areaPackages) {
        if (variable == null) {
            this.append("_null_variable_");
        } else {
            this.appendName(variable);
            EClassifier type = (EClassifier)variable.getType();
            if (type != null) {
                EPackage variablePackage = type.getEPackage();
                if (areaPackages != null && areaPackages.contains(variablePackage)) {
                    this.append(" : ");
                    this.appendName(type);
                } else if (variablePackage != null && "oclstdlib".equals(variablePackage.getName())) {
                    this.append(" : ");
                    this.appendName(type);
                } else {
                    if (type.eIsProxy()) {
                        type = (EClassifier)variable.getType();
                    }
                    if (type != null && !(type instanceof VoidType)) {
                        this.append(" : ");
                        this.appendQualifiedName(type);
                    }
                }
            }
        }
        return this;
    }

    protected void unparseAssignment(Assignment assignment) {
        if (assignment == null) {
            return;
        }
        if (assignment.isIsDefault()) {
            this.append("default ");
        }
        if (assignment instanceof PropertyAssignment) {
            PropertyAssignment propertyAssignment = (PropertyAssignment)assignment;
            this.doExpressionSwitch((ETypedElement)propertyAssignment.getSlotExpression());
            this.append(".");
            this.appendName(propertyAssignment.getTargetProperty());
        } else if (assignment instanceof VariableAssignment) {
            VariableAssignment variableAssignment = (VariableAssignment)assignment;
            this.appendName(variableAssignment.getTargetVariable());
        } else {
            this.unparseUnsupported(assignment);
        }
        this.append(" := ");
        this.doExpressionSwitch((ETypedElement)assignment.getValue());
        this.append(";\n");
    }

    protected void unparseBottomPattern(BottomPattern pattern, List<EPackage> areaPackages) {
        if (pattern == null) {
            return;
        }
        this.indent();
        EList variables = pattern.getVariable();
        EList realizedVariables = pattern.getRealizedVariable();
        if (realizedVariables.size() > 0 || variables.size() > 0) {
            boolean first = true;
            for (Variable realizedVariable : realizedVariables) {
                if (!first) {
                    this.append(",\n");
                }
                this.append("realize ");
                this.unparseAreaVariable(realizedVariable, areaPackages);
                first = false;
            }
            for (Variable variable : variables) {
                if (!first) {
                    this.append(",\n");
                }
                this.unparseAreaVariable(variable, areaPackages);
                first = false;
            }
            this.exdent();
            this.append("\n|\n");
            this.indent();
        }
        for (Predicate predicate : pattern.getPredicate()) {
            this.unparsePredicate(predicate);
        }
        for (Assignment assignment : pattern.getAssignment()) {
            this.unparseAssignment(assignment);
        }
        for (EnforcementOperation enforcementOperation : pattern.getEnforcementOperation()) {
            this.unparseEnforcementOperation(enforcementOperation);
        }
        this.exdent();
    }

    protected void unparseCoreDomain(CoreDomain domain) {
        if (domain == null) {
            return;
        }
        if (domain.isIsCheckable()) {
            this.append("check ");
        }
        if (domain.isIsEnforceable()) {
            this.append("enforce ");
        }
        this.appendName(domain.getTypedModel());
        this.unparseArea((Area)domain, (List<EPackage>)domain.getTypedModel().getUsedPackage());
    }

    protected void unparseEnforcementOperation(EnforcementOperation enforcementOperation) {
        if (enforcementOperation == null) {
            return;
        }
        this.append(enforcementOperation.getEnforcementMode() == EnforcementMode.CREATION ? "creation " : "deletion ");
        this.doExpressionSwitch((ETypedElement)enforcementOperation.getOperationCallExp());
        this.append(";\n");
    }

    protected void unparseGuardPattern(GuardPattern pattern, List<EPackage> areaPackages) {
        if (pattern == null) {
            return;
        }
        this.indent();
        EList variables = pattern.getVariable();
        for (Variable variable : variables) {
            this.unparseAreaVariable(variable, areaPackages);
        }
        EList predicates = pattern.getPredicate();
        if (predicates.size() > 0) {
            if (variables.size() > 0) {
                this.exdent();
                this.append("\n|\n");
                this.indent();
            }
            for (Predicate predicate : predicates) {
                this.unparsePredicate(predicate);
            }
        }
        this.exdent();
    }

    protected void unparseMapping(Mapping mapping) {
        EList specifications;
        Transformation transformation;
        if (mapping == null) {
            return;
        }
        this.append("map ");
        if (mapping.getName() != null) {
            this.appendName(mapping);
            this.append(" ");
        }
        if (mapping.getContext() == null && (transformation = mapping.getTransformation()) != null) {
            this.append("in ");
            this.appendName(transformation);
            this.append(" ");
        }
        if (!(specifications = mapping.getSpecification()).isEmpty()) {
            this.append("refines ");
            boolean isFirst = true;
            for (Iterator specification : specifications) {
                if (!isFirst) {
                    this.append(", ");
                }
                this.appendName(specification);
                isFirst = false;
            }
        }
        this.append(" {\n");
        this.indent();
        for (Domain domain : mapping.getDomain()) {
            if (domain instanceof CoreDomain) {
                this.unparseCoreDomain((CoreDomain)domain);
                continue;
            }
            this.unparseUnsupported(domain);
        }
        this.append("where");
        Mapping rootMapping = mapping;
        while (rootMapping.getContext() != null) {
            rootMapping = rootMapping.getContext();
        }
        ArrayList middleTypedModels = new ArrayList(rootMapping.getTransformation().getModelParameter());
        ArrayList<EPackage> middlePackages = new ArrayList<EPackage>();
        for (Domain domain : mapping.getDomain()) {
            middleTypedModels.remove(domain.getTypedModel());
        }
        for (TypedModel middleTypedModel : middleTypedModels) {
            middlePackages.addAll((Collection<EPackage>)middleTypedModel.getUsedPackage());
        }
        this.unparseArea((Area)mapping, middlePackages);
        for (Mapping composedMapping : mapping.getLocal()) {
            this.unparseMapping(composedMapping);
        }
        this.exdent();
        this.append("}\n");
    }

    protected void unparseParameter(EParameter parameter) {
        if (parameter == null) {
            return;
        }
        this.appendName(parameter);
        this.append(" : ");
        this.appendName(parameter.getEType());
    }

    protected void unparsePredicate(Predicate predicate) {
        this.doExpressionSwitch((ETypedElement)predicate.getConditionExpression());
        this.append(";\n");
    }

    protected void unparseQuery(Function query) {
        if (query == null) {
            return;
        }
        this.append("query ");
        this.appendQualifiedName(query);
        this.append("(");
        boolean first = true;
        for (EParameter eParameter : query.getEParameters()) {
            if (!first) {
                this.append(", ");
            }
            this.unparseParameter(eParameter);
            first = false;
        }
        this.append(") : ");
        this.appendName(query.getEType());
        OCLExpression body = query.getQueryExpression();
        if (body != null) {
            this.append(" {\n");
            this.indent();
            this.doExpressionSwitch((ETypedElement)body);
            this.append("\n");
            this.exdent();
            this.append("}\n");
        } else {
            this.append(";\n");
        }
    }

    protected void unparseTransformation(Transformation transformation) {
        if (transformation == null) {
            return;
        }
        this.append("transformation ");
        this.appendName(transformation);
        this.append(" {\n");
        this.indent();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            this.unparseTypedModel(typedModel);
        }
        this.exdent();
        this.append("}\n");
    }

    protected void unparseTypedModel(TypedModel typedModel) {
        EList typedModels;
        if (typedModel == null) {
            return;
        }
        this.appendName(typedModel);
        EList usedPackages = typedModel.getUsedPackage();
        if (usedPackages.size() > 0) {
            this.append(" imports ");
            boolean first = true;
            for (EPackage ePackage : usedPackages) {
                if (!first) {
                    this.append(",");
                }
                this.appendName(ePackage);
                first = false;
            }
        }
        if ((typedModels = typedModel.getDependsOn()).size() > 0) {
            this.append(" uses ");
            boolean first = true;
            for (TypedModel dependsOn : typedModels) {
                if (!first) {
                    this.append(",");
                }
                this.appendName(dependsOn);
                first = false;
            }
        }
        this.append(";\n");
    }
}

