/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.DomainOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.DomainPattern;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationCallExp;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomainAssignment;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.RelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationDomainOperations
extends DomainOperations {
    public static RelationDomainOperations INSTANCE = new RelationDomainOperations();

    public boolean checkPrimitiveDomainIsUnnamed(RelationDomain relationDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (relationDomain.getPattern() != null) {
            return true;
        }
        if (relationDomain.getName() == null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)relationDomain, context)};
        this.appendError(diagnostics, relationDomain, QVTRelationMessages._UI_RelationDomain_PrimitiveDomainMustBeUnnamed, messageSubstitutions);
        return false;
    }

    public boolean checkRootVariableIsDefinedByRelation(RelationDomain relationDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Variable rootVariable = relationDomain.getRootVariable();
        if (rootVariable == null) {
            return true;
        }
        Rule rule = relationDomain.getRule();
        if (!(rule instanceof Relation)) {
            return true;
        }
        if (RelationOperations.INSTANCE.definesVariable((Relation)rule, rootVariable)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)rootVariable, context), this.getObjectLabel((EObject)rule, context)};
        this.appendError(diagnostics, relationDomain, QVTRelationMessages._UI_RelationDomain_RootVariableIsNotDefinedByRelation, messageSubstitutions);
        return false;
    }

    public boolean checkRootVariableTypeIsDeclaredByDomainTypedModel(RelationDomain relationDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Variable rootVariable = relationDomain.getRootVariable();
        if (rootVariable == null) {
            return true;
        }
        EClassifier type = this.getTransitiveElementType(rootVariable.getEType());
        if (type == null) {
            return true;
        }
        if (this.declaresType(relationDomain, type)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)type, context), this.getObjectLabel((EObject)rootVariable, context), this.getObjectLabel((EObject)relationDomain, context)};
        this.appendError(diagnostics, relationDomain, QVTRelationMessages._UI_RelationDomain_RootVariableTypeIsNotDeclaredByDomainTypedModel, messageSubstitutions);
        return false;
    }

    public boolean checkEveryEnforceableVariableIsMatchedOrAssigned(RelationDomain relationDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!relationDomain.isIsEnforceable()) {
            return true;
        }
        HashSet sharedVariables = new HashSet();
        HashSet<Variable> passedVariables = new HashSet<Variable>();
        HashSet<Variable> collectedVariables = new HashSet<Variable>();
        HashSet<Variable> defaultedVariables = new HashSet<Variable>();
        HashMap matchedVariableFeatures = new HashMap();
        for (Domain domain : relationDomain.getRule().getDomain()) {
            DomainPattern pattern;
            if (domain == relationDomain || !(domain instanceof RelationDomain) || (pattern = ((RelationDomain)domain).getPattern()) == null) continue;
            sharedVariables.addAll(pattern.getBindsTo());
        }
        TreeIterator i = relationDomain.eAllContents();
        while (i.hasNext()) {
            ObjectTemplateExp templateExp;
            EObject eObject = (EObject)i.next();
            if (eObject instanceof RelationCallExp) {
                for (OCLExpression argument : ((RelationCallExp)eObject).getArgument()) {
                    if (!(argument instanceof VariableExp)) continue;
                    passedVariables.add((Variable)((VariableExp)argument).getReferredVariable());
                }
                continue;
            }
            if (eObject instanceof ObjectTemplateExp) {
                templateExp = (ObjectTemplateExp)eObject;
                Variable templateVariable = templateExp.getBindsTo();
                HashSet<EStructuralFeature> matchedFeatures = (HashSet<EStructuralFeature>)matchedVariableFeatures.get(templateVariable);
                if (matchedFeatures == null) {
                    matchedFeatures = new HashSet<EStructuralFeature>();
                    matchedVariableFeatures.put(templateVariable, matchedFeatures);
                }
                for (PropertyTemplateItem part : templateExp.getPart()) {
                    matchedFeatures.add(part.getReferredProperty());
                }
                continue;
            }
            if (eObject instanceof CollectionTemplateExp) {
                templateExp = (CollectionTemplateExp)eObject;
                collectedVariables.add(templateExp.getBindsTo());
                continue;
            }
            if (!(eObject instanceof RelationDomainAssignment)) continue;
            RelationDomainAssignment assignment = (RelationDomainAssignment)eObject;
            defaultedVariables.add(assignment.getVariable());
        }
        boolean allOk = true;
        return allOk;
    }
}

