/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.usage;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class DirectedDomainUsageAnalysis
implements DomainUsageAnalysis.Root {
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    private final @NonNull Set<@NonNull Property> dirtyProperties = new HashSet<Property>();
    private final @NonNull Set<@NonNull EReference> dirtyEReferences = new HashSet<EReference>();
    private RootDomainUsageAnalysis.DomainUsageConstant inputUsage = null;
    private RootDomainUsageAnalysis.DomainUsageConstant outputUsage = null;

    public DirectedDomainUsageAnalysis(@NonNull RootDomainUsageAnalysis domainUsageAnalysis) {
        this.domainUsageAnalysis = domainUsageAnalysis;
    }

    protected void addDirtyProperty(@NonNull Property property) {
        this.dirtyProperties.add(property);
        EObject eProperty = property.getESObject();
        if (eProperty instanceof EReference) {
            this.dirtyEReferences.add((EReference)eProperty);
        }
    }

    protected void analyzePropertyAssignments(@NonNull Transformation transformation) {
        for (Property dirtyProperty : this.dirtyProperties) {
            if (!dirtyProperty.isIsTransient()) {
                QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is not transient"));
            }
            if (dirtyProperty.isIsReadOnly()) {
                QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is readonly"));
            }
            if (!dirtyProperty.isIsRequired()) continue;
            QVTruntimeUtil.errPrintln((String)("Dirty " + dirtyProperty + " is required"));
        }
    }

    public void analyzeTransformation(@Nullable Iterable<@NonNull TypedModel> outputTypedModels) {
        int unenforceableMask = 0;
        int enforceableMask = 0;
        Transformation transformation = this.domainUsageAnalysis.getTransformation();
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)transformation)) {
            if (typedModel.isIsPrimitive()) continue;
            DomainUsage domainUsage = this.domainUsageAnalysis.getUsage((Element)typedModel);
            int bitMask = domainUsage.getMask();
            boolean isEnforceable = false;
            boolean isUnenforceable = false;
            for (Rule rule : QVTbaseUtil.getRule((Transformation)transformation)) {
                for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)rule)) {
                    if (domain.getTypedModel() != typedModel) continue;
                    if (domain.isIsEnforceable() && (outputTypedModels == null || Iterables.contains(outputTypedModels, (Object)typedModel))) {
                        isEnforceable = true;
                        continue;
                    }
                    isUnenforceable = true;
                }
            }
            if (isEnforceable) {
                enforceableMask |= bitMask;
            }
            if (!isUnenforceable) continue;
            unenforceableMask |= bitMask;
        }
        this.setInputUsage(unenforceableMask);
        this.setOutputUsage(enforceableMask);
        this.analyzePropertyAssignments(transformation);
    }

    @Override
    public @Nullable DomainUsage basicGetUsage(@Nullable Element element) {
        return this.domainUsageAnalysis.basicGetUsage(element);
    }

    public @NonNull DomainUsage getInputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.inputUsage);
    }

    public @NonNull DomainUsage getOutputUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.outputUsage);
    }

    @Override
    public @NonNull DomainUsage getUsage(@NonNull Element element) {
        return this.domainUsageAnalysis.getUsage(element);
    }

    @Override
    @Deprecated
    public @NonNull DomainUsage getConstantUsage(int bitMask) {
        return this.domainUsageAnalysis.getConstantUsage(bitMask);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.domainUsageAnalysis.getEnvironmentFactory();
    }

    public boolean isDirty(@NonNull EReference eReference) {
        return this.dirtyEReferences.contains(eReference);
    }

    public boolean isDirty(@NonNull Property property) {
        return property.isIsTransient() || this.dirtyProperties.contains(property);
    }

    public boolean isInput(@NonNull DomainUsage usage) {
        return (usage.getMask() & this.inputUsage.bitMask) != 0;
    }

    public boolean isOutput(@NonNull DomainUsage usage) {
        return (usage.getMask() & this.outputUsage.bitMask) != 0;
    }

    protected void setInputUsage(int inputMask) {
        int anyMask = this.domainUsageAnalysis.getAnyMask();
        this.inputUsage = this.domainUsageAnalysis.getConstantUsage(anyMask & inputMask);
    }

    protected void setOutputUsage(int outputMask) {
        int anyMask = this.domainUsageAnalysis.getAnyMask();
        this.outputUsage = this.domainUsageAnalysis.getConstantUsage(anyMask & outputMask);
    }
}

