/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.profilingdatatable;

import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.profiler.core.ATLModelHandler;
import org.eclipse.m2m.atl.profiler.core.ATLProfiler;
import org.eclipse.m2m.atl.profiler.core.ProfilerModelHandler;
import org.eclipse.m2m.atl.profiler.core.util.ProfilerModelExporter;
import org.eclipse.m2m.atl.profiler.exportmodel.ExportRoot;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;
import org.eclipse.m2m.atl.profiler.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.m2m.atl.profiler.ui.Messages;
import org.eclipse.m2m.atl.profiler.ui.activators.ExecutionViewerActivator;
import org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionView;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.CallsComparator;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.MemoryComparator;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.NameComparator;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.NativeOperationFilter;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.ProfilingDataTableContentProvider;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.ProfilingDataTableLabelProvider;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.TimeComparator;
import org.eclipse.m2m.atl.profiler.ui.profilingdatatable.TotalInstructionComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class ProfilingDataTableView
extends ViewPart
implements Observer,
ISelectionListener {
    public static final String INSTRUCTIONS_COLNAME = Messages.getString("ProfilingDataTableView_EXECUTED_INSTRUCTIONS");
    public static final String TIME_EXECUTION_COLNAME = Messages.getString("ProfilingDataTableView_TIME_EXECUTION");
    public static final String CALLS_COLNAME = Messages.getString("ProfilingDataTableView_CALLS");
    public static final String OPERATION_NAME_COLNAME = Messages.getString("ProfilingDataTableView_OPERATION_NAME");
    public static final String INMEMORY_COLNAME = Messages.getString("ProfilingDataTableView_MEMORY_COL");
    public static final String MAXMEMORY_COLNAME = Messages.getString("ProfilingDataTableView_MAX_MEMORY_COL");
    public static final String OUTMEMORY_COLNAME = Messages.getString("ProfilingDataTableView_END_MEMORY_COL");
    public static final String ID = "org.eclipse.m2m.atl.profiler.ui.profilingdatatable";
    private static final String SHOW_PERCENTS = Messages.getString("ProfilingDataTableView_PERCENT_STATISTICS");
    private static final String EXPORT_DATA = Messages.getString("ProfilingDataTableView_XMI_EXPORT");
    private static final String SHOW_PERCENTS_GIF = "percentsStatistics.gif";
    private static final String SAVE_GIF = "save.gif";
    private static final String HIDE_NATIVE_OPERATIONS_GIF = "hideNativeOperations.gif";
    private static final String SHOW_PERCENTAGES = Messages.getString("ProfilingDataTableView_HIDE_NATIVE_OPERATIONS");
    private static int instructionsColId;
    private static int timeExecutionColId;
    private static int callsColId;
    private static int operationNameColId;
    private static int inMemoryColId;
    private static int maxMemoryColId;
    private static int outMemoryColId;
    private static boolean showPercents;
    private static long totalInstructions;
    private static double totalTime;
    private Action showPercentsAction;
    private Action hideNativeOperationsAction;
    private NativeOperationFilter hideNativeOperationsfilter;
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    private Action doubleClickAction;
    private Action xmiExportAction;
    private DirectoryDialog exportDirectorydialog;

    public ProfilingDataTableView() {
        ATLProfiler.getInstance().addObserver((Observer)this);
        showPercents = false;
    }

    public void dispose() {
        super.dispose();
        ATLProfiler.getInstance().deleteObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 65536);
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new ProfilingDataTableContentProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfilingDataTableLabelProvider((AdapterFactory)new ModelItemProviderAdapterFactory()));
        this.exportDirectorydialog = new DirectoryDialog(parent.getShell());
        this.makeColumns();
        this.makeListeners();
        this.makefilters();
        this.makeActions();
        this.setDefaultActions();
        this.contributeToActionBars();
        this.hookDoubleClickAction();
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void makeListeners() {
        Tree tree = this.treeViewer.getTree();
        this.addColumnSelectionListener(operationNameColId, tree, new NameComparator(), new NameComparator(false));
        this.addColumnSelectionListener(timeExecutionColId, tree, new TimeComparator(), new TimeComparator(false));
        this.addColumnSelectionListener(instructionsColId, tree, new TotalInstructionComparator(), new TotalInstructionComparator(false));
        this.addColumnSelectionListener(callsColId, tree, new CallsComparator(), new CallsComparator(false));
        this.addColumnSelectionListener(inMemoryColId, tree, new MemoryComparator(MemoryComparator.ColumnType.InMem), new MemoryComparator(MemoryComparator.ColumnType.InMem, false));
        this.addColumnSelectionListener(maxMemoryColId, tree, new MemoryComparator(MemoryComparator.ColumnType.MaxMem), new MemoryComparator(MemoryComparator.ColumnType.MaxMem, false));
        this.addColumnSelectionListener(outMemoryColId, tree, new MemoryComparator(MemoryComparator.ColumnType.OutMem), new MemoryComparator(MemoryComparator.ColumnType.OutMem, false));
    }

    private void addColumnSelectionListener(final int colId, final Tree tree, final ViewerComparator wc, final ViewerComparator descWc) {
        tree.getColumn(colId).addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int direction;

            public void widgetSelected(SelectionEvent e) {
                if (this.direction == 0) {
                    this.setupColumnSorting(colId, 128, tree, wc);
                } else if (this.direction == 128) {
                    this.setupColumnSorting(colId, 1024, tree, descWc);
                } else {
                    this.setupColumnSorting(colId, 0, tree, null);
                }
                ProfilingDataTableView.this.treeViewer.refresh();
            }

            private void setupColumnSorting(int colId2, int dir, Tree tree2, ViewerComparator wc2) {
                ProfilingDataTableView.this.treeViewer.collapseAll();
                ProfilingDataTableView.this.treeViewer.setComparator(wc2);
                tree2.setSortColumn(tree2.getColumn(colId2));
                this.direction = dir;
                tree2.setSortDirection(this.direction);
            }
        });
    }

    private void makeColumns() {
        int i = 0;
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        operationNameColId = i++;
        TreeColumn opNameCol = new TreeColumn(tree, 16384);
        opNameCol.setText(OPERATION_NAME_COLNAME);
        opNameCol.setWidth(150);
        callsColId = i++;
        TreeColumn callsCol = new TreeColumn(tree, 0x1000000);
        callsCol.setText(CALLS_COLNAME);
        callsCol.setWidth(75);
        timeExecutionColId = i++;
        TreeColumn timeExecCol = new TreeColumn(tree, 0x1000000);
        timeExecCol.setText(TIME_EXECUTION_COLNAME);
        timeExecCol.setWidth(120);
        instructionsColId = i++;
        TreeColumn instrCountCol = new TreeColumn(tree, 0x1000000);
        instrCountCol.setText(INSTRUCTIONS_COLNAME);
        instrCountCol.setWidth(140);
        inMemoryColId = i++;
        TreeColumn inMemCol = new TreeColumn(tree, 0x1000000);
        inMemCol.setText(INMEMORY_COLNAME);
        inMemCol.setWidth(120);
        maxMemoryColId = i++;
        TreeColumn maxMemCol = new TreeColumn(tree, 0x1000000);
        maxMemCol.setText(MAXMEMORY_COLNAME);
        maxMemCol.setWidth(105);
        outMemoryColId = i;
        TreeColumn outMemCol = new TreeColumn(tree, 0x1000000);
        outMemCol.setText(OUTMEMORY_COLNAME);
        outMemCol.setWidth(85);
    }

    private void makefilters() {
        this.hideNativeOperationsfilter = new NativeOperationFilter();
    }

    private void makeActions() {
        this.hideNativeOperationsAction = new Action(SHOW_PERCENTAGES, 2){

            public void run() {
                ProfilingDataTableView.this.updateFilters(ProfilingDataTableView.this.hideNativeOperationsAction);
            }
        };
        this.hideNativeOperationsAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(HIDE_NATIVE_OPERATIONS_GIF));
        this.showPercentsAction = new Action(SHOW_PERCENTS, 2){

            public void run() {
                if (showPercents) {
                    showPercents = false;
                    totalTime = ProfilerModelHandler.getInstance().getModelTotalTime();
                    totalInstructions = ProfilerModelHandler.getInstance().getModelTotalInstructions();
                } else {
                    showPercents = true;
                }
                ProfilingDataTableView.this.treeViewer.refresh();
            }
        };
        this.showPercentsAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(SHOW_PERCENTS_GIF));
        this.xmiExportAction = new Action(EXPORT_DATA){

            public void run() {
                String path = ProfilingDataTableView.this.exportDirectorydialog.open();
                if (path != null) {
                    path = String.valueOf(path) + "/profiler_export.xmi";
                    URI uri = URI.createFileURI((String)path);
                    Resource rsc = new ResourceSetImpl().createResource(uri);
                    rsc.getContents().clear();
                    ExportRoot exportModel = null;
                    try {
                        exportModel = ProfilerModelExporter.exportCurrentProfilingModel();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (exportModel != null) {
                        rsc.getContents().add((Object)exportModel);
                        try {
                            rsc.save(Collections.EMPTY_MAP);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ProfilingDataTableView.this.showMessage(String.valueOf(Messages.getString("ProfilingDataTableView_EXPORT_SUCCESSFULL")) + path, Messages.getString("ProfilingDataTableView_EXPORT"));
                    } else {
                        ProfilingDataTableView.this.showError(Messages.getString("ProfilingDataTableView_UNABLE_TO_EXPORT"), Messages.getString("ProfilingDataTableView_EXPORT"));
                    }
                }
            }
        };
        this.xmiExportAction.setImageDescriptor(ExecutionViewerActivator.getImageDescriptor(SAVE_GIF));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ProfilingDataTableView.this.treeViewer.getSelection();
                if (ProfilingDataTableView.this.treeViewer.getComparator() != null) {
                    ProfilingDataTableView.this.treeViewer.collapseAll();
                    ProfilingDataTableView.this.treeViewer.setComparator(null);
                    ProfilingDataTableView.this.treeViewer.getTree().setSortDirection(0);
                    TreeSelection current = (TreeSelection)selection;
                    ProfilingDataTableView.this.treeViewer.setSelection((ISelection)current);
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProfilingDataTableView.this.doubleClickAction.run();
            }
        });
    }

    private void setDefaultActions() {
        this.hideNativeOperationsAction.setChecked(true);
        this.treeViewer.addFilter((ViewerFilter)this.hideNativeOperationsfilter);
    }

    private void updateFilters(Action updateFiltersAction) {
        if (updateFiltersAction.isChecked()) {
            this.treeViewer.addFilter((ViewerFilter)this.hideNativeOperationsfilter);
        } else {
            this.treeViewer.removeFilter((ViewerFilter)this.hideNativeOperationsfilter);
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.hideNativeOperationsAction);
        manager.add((IAction)this.showPercentsAction);
        manager.add((IAction)this.xmiExportAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.hideNativeOperationsAction);
        manager.add((IAction)this.showPercentsAction);
        manager.add((IAction)this.xmiExportAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setInput(final Object arg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ProfilingDataTableView.this.treeViewer.setInput(arg);
                ProfilingDataTableView.this.treeViewer.refresh();
            }
        });
    }

    public void update(Observable o, Object arg) {
        this.setInput(arg);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreePath tp;
        TreeSelection current;
        if (part instanceof ExecutionView && !ExecutionView.isShowCallTree()) {
            TreePath tp2;
            TreeSelection current2 = (TreeSelection)selection;
            if (current2.getFirstElement() instanceof ProfilingOperation && (tp2 = current2.getPaths()[0]).getLastSegment() instanceof ProfilingOperation) {
                ProfilingOperation pOp = (ProfilingOperation)tp2.getLastSegment();
                String atlName = ATLModelHandler.getInstance().getATLName(pOp.getContent());
                Object[] segments = new Object[]{ProfilerModelHandler.getInstance().getOperationRegistry().get(atlName), pOp};
                if (!pOp.getContent().equals("__resolve__") && !pOp.getContent().equals("__match_") && !pOp.getContent().equals("__exec__") || !this.hideNativeOperationsAction.isChecked()) {
                    TreePath newTp = new TreePath(segments);
                    TreeSelection newselection = new TreeSelection(newTp);
                    this.treeViewer.setSelection((ISelection)newselection);
                }
            }
        } else if (part instanceof ExecutionView && ExecutionView.isShowCallTree() && (current = (TreeSelection)selection).getFirstElement() instanceof ProfilingOperation && (tp = current.getPaths()[0]).getLastSegment() instanceof ProfilingOperation) {
            ProfilingOperation pOp = (ProfilingOperation)tp.getLastSegment();
            String atlName = ATLModelHandler.getInstance().getATLName(pOp.getContent());
            Object[] segments = new Object[]{ProfilerModelHandler.getInstance().getOperationRegistry().get(atlName)};
            TreePath newTp = new TreePath(segments);
            TreeSelection newselection = new TreeSelection(newTp);
            this.treeViewer.setSelection((ISelection)newselection);
        }
    }

    private void showMessage(String message, String title) {
        MessageDialog.openInformation((Shell)this.treeViewer.getControl().getShell(), (String)title, (String)message);
    }

    private void showError(String message, String title) {
        MessageDialog.openError((Shell)this.treeViewer.getControl().getShell(), (String)title, (String)message);
    }

    public static int getTotalInstructionsId() {
        return instructionsColId;
    }

    public static int getTotalTimeExecutionId() {
        return timeExecutionColId;
    }

    public static int getCallsId() {
        return callsColId;
    }

    public static int getOperationNameId() {
        return operationNameColId;
    }

    public static int getInMemoryColId() {
        return inMemoryColId;
    }

    public static boolean isShowPercentAction() {
        return showPercents;
    }

    public static void setShowPercentAction(boolean s) {
        showPercents = s;
    }

    public static long getTotalInstructions() {
        return totalInstructions;
    }

    public static double getTotalTime() {
        return totalTime;
    }

    public static int getMaxMemoryColID() {
        return maxMemoryColId;
    }

    public static int getOutMemoryColId() {
        return outMemoryColId;
    }
}

