/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.extractors.Extractor;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;

public abstract class ModelLoader {
    protected Map loadedModels = new HashMap();
    private Map injectors = new HashMap();
    private Map extractors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModelLoader() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.injectors.put("xml", clazz);
        this.extractors = new HashMap();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.m2m.atl.engine.extractors.xml.XMLExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.extractors.put("xml", clazz2);
    }

    public void addInjector(String prefix, Class inj) {
        this.injectors.put(prefix, inj);
    }

    public void addExtractor(String prefix, Class ext) {
        this.extractors.put(prefix, ext);
    }

    public abstract ASMModel loadModel(String var1, ASMModel var2, InputStream var3) throws IOException;

    protected abstract ASMModel realLoadModel(String var1, ASMModel var2, String var3) throws IOException;

    public ASMModel loadModel(String name, ASMModel metamodel, String href) throws IOException {
        ASMModel ret = null;
        href = href.replaceAll("\\\\:", "<colon>");
        String[] ss = href.split(":");
        int i = 0;
        while (i < ss.length) {
            ss[i] = ss[i].replaceAll("<colon>", ":");
            ++i;
        }
        if (ss.length == 1) {
            ret = this.realLoadModel(name, metamodel, ss[0]);
        } else if (ss[0].equals("uri") || ss[0].equals("platform")) {
            ret = this.realLoadModel(name, metamodel, href);
        } else if (ss[0].equals("xmi")) {
            String url = ss[ss.length - 1];
            ret = this.realLoadModel(name, metamodel, url);
        } else {
            ret = this.newModel(name, ss[ss.length - 1], metamodel);
            this.inject(ret, ss[0], ss.length == 3 ? ss[1] : null, ss[ss.length - 1], null);
        }
        this.loadedModels.put(name, ret);
        return ret;
    }

    public ASMModelElement inject(ASMModel ret, String kind, String params, String uri, InputStream in) {
        ASMModelElement root = null;
        try {
            Class injectorClass;
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            if (uri != null) {
                try {
                    in = new FileInputStream(uri);
                }
                catch (FileNotFoundException fnfe) {
                    in = new URL(uri).openStream();
                }
            }
            if ((injectorClass = (Class)this.injectors.get(kind)) != null) {
                Injector inj = (Injector)injectorClass.newInstance();
                if (params != null) {
                    String[] sparams = params.split(",");
                    HashMap<String, String> args = new HashMap<String, String>();
                    int i = 0;
                    while (i < sparams.length) {
                        String p = sparams[i];
                        String[] pair = p.split("=");
                        if (pair.length == 1) {
                            if (p.indexOf("=") == -1) {
                                args.put("name", pair[0]);
                            } else {
                                args.put(pair[0], "");
                            }
                        } else {
                            args.put(pair[0], pair[1]);
                        }
                        ++i;
                    }
                    Map types = inj.getParameterTypes();
                    Iterator i2 = types.keySet().iterator();
                    while (i2.hasNext()) {
                        String pname = (String)i2.next();
                        String type = (String)types.get(pname);
                        if (type.equals("String")) {
                            String val = (String)args.get(pname);
                            if (val != null) {
                                paramsMap.put(pname, val);
                                continue;
                            }
                            ATLLogger.warning((String)("could not find value for parameter \"" + pname + "\" : " + type + "."));
                            continue;
                        }
                        if (type.startsWith("Model:")) {
                            paramsMap.put(pname, this.loadedModels.get(args.get(pname)));
                            continue;
                        }
                        if (type.equals("RandomAccessFile") && uri != null) {
                            paramsMap.put(pname, new RandomAccessFile(uri, "r"));
                            continue;
                        }
                        ATLLogger.warning((String)("unknown parameter type \"" + type + "\" of \"" + pname + "\"."));
                    }
                }
                root = inj.inject(ret, in, paramsMap);
                ret.setIsTarget(false);
            } else {
                ATLLogger.severe((String)("ERROR: could not find injector for \"" + kind + "\""));
            }
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return root;
    }

    public abstract ASMModel newModel(String var1, ASMModel var2);

    public abstract ASMModel newModel(String var1, String var2, ASMModel var3);

    protected abstract void setParameter(String var1, Object var2);

    protected abstract void realSave(ASMModel var1, String var2) throws IOException;

    public void save(ASMModel model, String href) throws IOException {
        String[] ss = href.split(":");
        if (ss.length == 1) {
            this.realSave(model, href);
        } else if (ss[0].equals("xmi")) {
            String url = ss[ss.length - 1];
            this.setParameter("useIDs", "false");
            this.setParameter("removeIDs", "false");
            this.setParameter("encoding", "ISO-8859-1");
            this.setParameter("xmiVersion", null);
            if (ss.length == 3) {
                String[] sparams = ss[1].split(",");
                int i = 0;
                while (i < sparams.length) {
                    String p = sparams[i];
                    String[] pair = p.split("=");
                    if (pair.length == 2) {
                        this.setParameter(pair[0], pair[1]);
                    }
                    ++i;
                }
            }
            this.realSave(model, url);
        } else if (ss[0].equals("file")) {
            this.realSave(model, href);
        } else if (ss[0].equals("platform")) {
            this.realSave(model, href);
        } else {
            this.extract(model, ss[0], ss.length == 3 ? ss[1] : null, ss[ss.length - 1], null);
        }
    }

    public void extract(ASMModel model, String kind, String params, String uri, OutputStream out) {
        try {
            Class extractorClass;
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (uri != null) {
                out = new FileOutputStream(uri);
            }
            if ((extractorClass = (Class)this.extractors.get(kind)) != null) {
                Extractor ext = (Extractor)extractorClass.newInstance();
                if (params != null) {
                    String[] sparams = params.split(",");
                    HashMap<String, String> args = new HashMap<String, String>();
                    int i = 0;
                    while (i < sparams.length) {
                        String p = sparams[i];
                        String[] pair = p.split("=");
                        if (pair.length == 1) {
                            if (p.indexOf("=") == -1) {
                                args.put("name", pair[0]);
                            } else {
                                args.put(pair[0], "");
                            }
                        } else {
                            args.put(pair[0], pair[1]);
                        }
                        ++i;
                    }
                    Map types = ext.getParameterTypes();
                    Iterator i2 = types.keySet().iterator();
                    while (i2.hasNext()) {
                        String pname = (String)i2.next();
                        String type = (String)types.get(pname);
                        if (type.equals("String")) {
                            String val = (String)args.get(pname);
                            if (val != null) {
                                paramsMap.put(pname, val);
                                continue;
                            }
                            ATLLogger.warning((String)("could not find value for parameter \"" + pname + "\" : " + type + "."));
                            continue;
                        }
                        if (type.startsWith("Model:")) {
                            paramsMap.put(pname, (String)this.loadedModels.get(args.get(pname)));
                            continue;
                        }
                        ATLLogger.warning((String)("unknown parameter type \"" + type + "\" of \"" + pname + "\"."));
                    }
                }
                ext.extract(model, out, paramsMap);
            } else {
                ATLLogger.severe((String)("ERROR: could not find extractor for \"" + kind + "\""));
            }
        }
        catch (Throwable e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public abstract ASMModel getMOF();

    public abstract ASMModel getATL();

    public abstract ASMModel getBuiltInMetaModel(String var1);

    public abstract void unload(ASMModel var1);
}

