/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.launch;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.engine.emfvm.ASM;
import org.eclipse.m2m.atl.engine.emfvm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.adapter.EMFModelAdapter;
import org.eclipse.m2m.atl.engine.emfvm.adapter.UML2ModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFVMLauncher
implements ILauncher {
    public static final String LAUNCHER_NAME = "EMF-specific VM";
    public static final String MODEL_FACTORY_NAME = "EMF";
    protected Map<String, IModel> models;
    protected Map<String, ASM> libraries;

    public String getName() {
        return LAUNCHER_NAME;
    }

    protected void addModel(IModel model, String name, String referenceModelName) {
        if (this.models.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("EMFVMLauncher.MODEL_EVER_REGISTERED", name));
        } else {
            this.models.put(name, model);
        }
        if (!this.models.containsKey(referenceModelName)) {
            this.models.put(referenceModelName, (IModel)model.getReferenceModel());
        }
    }

    public void addInModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(false);
        this.addModel(model, name, referenceModelName);
    }

    public void addInOutModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(true);
        this.addModel(model, name, referenceModelName);
    }

    public void addOutModel(IModel model, String name, String referenceModelName) {
        model.setIsTarget(true);
        this.addModel(model, name, referenceModelName);
    }

    public void addLibrary(String name, Object library) {
        if (this.libraries.containsKey(name)) {
            ATLLogger.warning((String)Messages.getString("EMFVMLauncher.LIBRARY_EVER_REGISTERED", name));
        } else {
            this.libraries.put(name, this.getASMFromObject(library));
        }
    }

    public void initialize(Map<String, Object> parameters) {
        this.models = new HashMap<String, IModel>();
        this.libraries = new HashMap<String, ASM>();
    }

    public Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        if (!mode.equals("run")) {
            ATLLogger.warning((String)("mode " + mode + " unsupported for EMFVM, running launch instead"));
        }
        ArrayList<ASM> superimpose = new ArrayList<ASM>();
        ASM mainModule = this.getASMFromObject(modules[0]);
        int i = 1;
        while (i < modules.length) {
            superimpose.add(this.getASMFromObject(modules[i]));
            ++i;
        }
        return this.launch(mode, monitor, options, mainModule, superimpose);
    }

    protected Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, ASM mainModule, List<ASM> superimpose) {
        EMFModelAdapter modelAdapter = "true".equals(options.get("supportUML2Stereotypes")) ? new UML2ModelAdapter() : new EMFModelAdapter();
        modelAdapter.setAllowInterModelReferences("true".equals(options.get("allowInterModelReferences")));
        return mainModule.run(this.models, this.libraries, superimpose, options, monitor, modelAdapter);
    }

    public Object loadModule(InputStream inputStream) {
        return new ASMXMLReader().read(inputStream);
    }

    protected ASM getASMFromObject(Object module) {
        if (module instanceof InputStream) {
            return (ASM)this.loadModule((InputStream)module);
        }
        if (module instanceof ASM) {
            return (ASM)module;
        }
        return null;
    }

    public IModel getModel(String modelName) {
        return this.models.get(modelName);
    }

    public Object getLibrary(String libraryName) {
        return this.libraries.get(libraryName);
    }

    public String getDefaultModelFactoryName() {
        return MODEL_FACTORY_NAME;
    }
}

