/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.tck.InheritanceTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.StringClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryParamStyleTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InheritanceTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ReturnWithURLRequestFilter.class, StringClient.class});
    }

    @Test
    public void defaultStyleIsMultiPair() throws Exception {
        String expected = "?myParam=foo&myParam=bar&myParam=baz";
        StringClient client = (StringClient)this.builder().build(StringClient.class);
        QueryParamStyleTest.test(client, expected);
    }

    @Test
    public void explicitMultiPair() throws Exception {
        String expected = "?myParam=foo&myParam=bar&myParam=baz";
        StringClient client = (StringClient)this.builder().queryParamStyle(QueryParamStyle.MULTI_PAIRS).build(StringClient.class);
        QueryParamStyleTest.test(client, expected);
    }

    @Test
    public void commaSeparated() throws Exception {
        String expected = "?myParam=foo,bar,baz";
        StringClient client = (StringClient)this.builder().queryParamStyle(QueryParamStyle.COMMA_SEPARATED).build(StringClient.class);
        QueryParamStyleTest.test(client, expected);
    }

    @Test
    public void arrayPairs() throws Exception {
        String expected = "?myParam[]=foo&myParam[]=bar&myParam[]=baz";
        StringClient client = (StringClient)this.builder().queryParamStyle(QueryParamStyle.ARRAY_PAIRS).build(StringClient.class);
        QueryParamStyleTest.test(client, expected);
    }

    public static void test(StringClient client, String expected) {
        String responseStr = client.multiValues(Arrays.asList("foo", "bar", "baz"));
        Assert.assertNotNull((Object)responseStr, (String)"Response entity is null");
        Assert.assertTrue((boolean)responseStr.contains(expected), (String)("Expected snippet, " + expected + ", in: " + responseStr));
    }

    private RestClientBuilder builder() {
        return ((RestClientBuilder)RestClientBuilder.newBuilder().register((Object)new ReturnWithURLRequestFilter())).baseUri(URI.create("http://localhost/stub"));
    }
}

