/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.processors;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@ApplicationScoped
public class DirectProcessorBean {
    private Map<String, List<String>> collector = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> EXPECTED = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
    private static Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();

    private static void increment(String counter) {
        counters.computeIfAbsent(counter, x -> new AtomicInteger(0)).incrementAndGet();
    }

    @Outgoing(value="publisher-synchronous-message")
    public PublisherBuilder<Integer> streamForProcessorOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-synchronous-payload")
    public PublisherBuilder<Integer> streamForProcessorOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-asynchronous-message")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-asynchronous-payload")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Incoming(value="synchronous-message")
    public void getMessgesFromProcessorOfMessages(String value) {
        this.add("processor-message", value);
    }

    @Incoming(value="synchronous-payload")
    public void getMessgesFromProcessorOfPayloads(String value) {
        this.add("processor-payload", value);
    }

    @Incoming(value="asynchronous-message")
    public void getMessgesFromProcessorBuilderOfMessages(String value) {
        this.add("processor-builder-message", value);
    }

    @Incoming(value="asynchronous-payload")
    public void getMessgesFromProcessorBuilderOfPayloads(String value) {
        this.add("processor-builder-payload", value);
    }

    @Incoming(value="publisher-synchronous-message")
    @Outgoing(value="synchronous-message")
    public Message<String> messageSynchronous(Message<Integer> message) {
        DirectProcessorBean.increment("synchronous-message");
        return Message.of((Object)Integer.toString((Integer)message.getPayload() + 1));
    }

    @Incoming(value="publisher-synchronous-payload")
    @Outgoing(value="synchronous-payload")
    public String payloadSynchronous(int value) {
        DirectProcessorBean.increment("synchronous-payload");
        return Integer.toString(value + 1);
    }

    @Incoming(value="publisher-asynchronous-message")
    @Outgoing(value="asynchronous-message")
    public CompletionStage<Message<String>> messageAsynchronous(Message<Integer> message) {
        DirectProcessorBean.increment("asynchronous-message");
        return CompletableFuture.supplyAsync(() -> Message.of((Object)Integer.toString((Integer)message.getPayload() + 1)), TckBase.EXECUTOR);
    }

    @Incoming(value="publisher-asynchronous-payload")
    @Outgoing(value="asynchronous-payload")
    public CompletionStage<String> payloadAsynchronous(int value) {
        DirectProcessorBean.increment("asynchronous-payload");
        return CompletableFuture.supplyAsync(() -> Integer.toString(value + 1), TckBase.EXECUTOR);
    }

    private void add(String key, String value) {
        this.collector.computeIfAbsent(key, x -> new CopyOnWriteArrayList()).add(value);
    }

    void verify() {
        Awaitility.await().until(() -> this.collector.size() == 4);
        ((MapAssert)Assertions.assertThat(this.collector).hasSize(4)).allSatisfy((k, v) -> Assertions.assertThat((List)v).containsExactlyElementsOf(EXPECTED));
        Assertions.assertThat((AtomicInteger)counters.get("synchronous-message")).hasValue(EXPECTED.size());
        Assertions.assertThat((AtomicInteger)counters.get("synchronous-payload")).hasValue(EXPECTED.size());
        Assertions.assertThat((AtomicInteger)counters.get("asynchronous-message")).hasValue(EXPECTED.size());
        Assertions.assertThat((AtomicInteger)counters.get("asynchronous-payload")).hasValue(EXPECTED.size());
    }
}

