/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.connector;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.IncomingConnectorFactory;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@ApplicationScoped
@Connector(value="Dummy")
public class DummyConnector
implements IncomingConnectorFactory,
OutgoingConnectorFactory {
    private List<String> elements = new CopyOnWriteArrayList<String>();
    private List<Config> configs = new CopyOnWriteArrayList<Config>();

    List<String> elements() {
        return this.elements;
    }

    List<Config> getReceivedConfigurations() {
        return this.configs;
    }

    public SubscriberBuilder<? extends Message<?>, Void> getSubscriberBuilder(Config config) {
        Assertions.assertThat((String)((String)config.getValue("channel-name", String.class))).isNotBlank();
        Assertions.assertThat((String)((String)config.getValue("connector", String.class))).isEqualTo("Dummy");
        this.configs.add(config);
        config.getValue("attribute", String.class);
        config.getValue("common-A", String.class);
        config.getValue("common-B", String.class);
        return ReactiveStreams.builder().map(Message::getPayload).forEach(s -> this.elements.add((String)s));
    }

    public PublisherBuilder<? extends Message<?>> getPublisherBuilder(Config config) {
        this.configs.add(config);
        String[] values = ((String)config.getValue("items", String.class)).split(",");
        Assertions.assertThat((String)((String)config.getValue("channel-name", String.class))).isNotBlank();
        Assertions.assertThat((String)((String)config.getValue("connector", String.class))).isEqualTo("Dummy");
        config.getValue("attribute", String.class);
        config.getValue("common-A", String.class);
        config.getValue("common-B", String.class);
        return ReactiveStreams.fromIterable(Arrays.asList(values)).map(Message::of);
    }
}

