/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@ApplicationScoped
public class BeanWithChain {
    private List<String> list = new CopyOnWriteArrayList<String>();

    @Outgoing(value="source")
    public PublisherBuilder<String> source() {
        return ReactiveStreams.of((Object[])new String[]{"hello", "with", "MicroProfile", "reactive", "messaging"});
    }

    @Incoming(value="source")
    @Outgoing(value="processed-a")
    public String toUpperCase(String payload) {
        return payload.toUpperCase();
    }

    @Incoming(value="processed-a")
    @Outgoing(value="processed-b")
    public PublisherBuilder<String> filter(PublisherBuilder<String> input) {
        return input.filter(item -> item.length() > 4);
    }

    @Incoming(value="processed-b")
    public void sink(String word) {
        this.list.add(word);
    }

    public List<String> list() {
        return this.list;
    }
}

